/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fields;

import com.adesoft.fields.Filterable;
import com.adesoft.filters.DFilter;
import com.adesoft.filters.Operators;
import java.io.Serializable;
import java.util.Arrays;

public final class StringArrayField
implements Filterable,
Serializable {
    private static final long serialVersionUID = 520L;
    private final String[] values;

    public StringArrayField(String[] stringArray) {
        this.values = stringArray;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            if (0 != stringBuffer.length()) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.values[i]);
        }
        return stringBuffer.toString();
    }

    public final String[] getValues() {
        return this.values;
    }

    @Override
    public int compare(Object object) {
        StringArrayField stringArrayField = (StringArrayField)object;
        if (this.getValues().length != stringArrayField.getValues().length) {
            return this.getValues().length - stringArrayField.getValues().length;
        }
        for (int i = 0; i < this.getValues().length; ++i) {
            int n = this.getValues()[i].compareTo(stringArrayField.getValues()[i]);
            if (0 == n) continue;
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StringArrayField) {
            return Arrays.equals(this.values, ((StringArrayField)object).values);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.getValues().length; ++i) {
            String string = this.getValues()[i];
            for (int j = 0; j < string.length(); ++j) {
                n = 31 * n + string.charAt(j);
            }
        }
        return n;
    }

    @Override
    public boolean check(DFilter dFilter) {
        return Operators.test(dFilter.getOperator(), this.toString(), dFilter.getValue());
    }

    @Override
    public int intValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long longValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float floatValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean booleanValue() {
        throw new UnsupportedOperationException();
    }
}

