/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fields;

import com.adesoft.fields.Filterable;
import com.adesoft.filters.DFilter;
import com.adesoft.filters.Operators;
import java.io.Serializable;

public final class StringField
implements Filterable,
Serializable {
    private static final long serialVersionUID = 520L;
    private final String value;
    public static final StringField EMPTY = new StringField("");

    public StringField(String string) {
        this.value = string;
    }

    @Override
    public final String toString() {
        return this.value;
    }

    @Override
    public int compare(Object object) {
        return this.value.compareTo(((StringField)object).value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StringField) {
            return this.value.equals(((StringField)object).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean check(DFilter dFilter) {
        return Operators.test(dFilter.getOperator(), this.toString(), dFilter.getValue());
    }

    @Override
    public int intValue() {
        return Integer.parseInt(this.value);
    }

    @Override
    public long longValue() {
        return Long.parseLong(this.value);
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.value);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public boolean booleanValue() {
        return "true".equalsIgnoreCase(this.value);
    }
}

