/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.filters;

import com.adesoft.fields.DoubleField;
import com.adesoft.fields.IntegerField;
import com.adesoft.fields.SlotField;
import com.adesoft.struct.Field;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.jdom.Element;

public final class DFilter
implements Serializable {
    private static final long serialVersionUID = 520L;
    public static final String DEBUG_SEPARATOR = "\u00a7";
    private final int _iOperator;
    private final int _iOperatorFamily;
    private final Field _Field;
    private final boolean onFathers;
    private String _sValue;
    private int _iValue;
    private double _dValue;
    private long _timeValue;

    public DFilter(Field field, int n, int n2, boolean bl) {
        this(field, n, n2, "", bl);
    }

    public DFilter(Field field, int n, int n2, String string, boolean bl) {
        if (null == field) {
            throw new IllegalArgumentException("Invalid field");
        }
        this._Field = field;
        this._iOperator = n2;
        this._iOperatorFamily = n;
        this._sValue = string;
        this._iValue = DFilter.getIntValue(string);
        this._dValue = DFilter.getDoubleValue(string);
        this._timeValue = DFilter.getTimeValue(string);
        this.onFathers = bl;
    }

    public DFilter(Field field, int n, int n2, String string, int n3, double d, long l, boolean bl) {
        if (null == field) {
            throw new IllegalArgumentException("Invalid field");
        }
        this._Field = field;
        this._iOperator = n2;
        this._iOperatorFamily = n;
        this._sValue = string;
        this._iValue = n3;
        this._dValue = d;
        this._timeValue = l;
        this.onFathers = bl;
    }

    public void setValue(String string) {
        this._sValue = string;
        this._iValue = DFilter.getIntValue(string);
        this._dValue = DFilter.getDoubleValue(string);
        this._timeValue = DFilter.getTimeValue(string);
    }

    public Field getField() {
        return this._Field;
    }

    public double getDoubleValue() {
        return this._dValue;
    }

    public int getIntValue() {
        return this._iValue;
    }

    public String getValue() {
        return this._sValue;
    }

    public long getTime() {
        return this._timeValue;
    }

    public int getOperator() {
        return this._iOperator;
    }

    public int getOperatorFamily() {
        return this._iOperatorFamily;
    }

    public boolean isOnFathers() {
        return this.onFathers;
    }

    public String getStringValue(Field field) {
        if (null == field) {
            return "";
        }
        if (field.getType() == IntegerField.class) {
            return Integer.toString(this.getIntValue());
        }
        if (field.getType() == DoubleField.class) {
            return Double.toString(this.getDoubleValue());
        }
        return this.getValue();
    }

    public String toString() {
        return this._Field.getName() + DEBUG_SEPARATOR + this._iOperatorFamily + DEBUG_SEPARATOR + this._iOperator + DEBUG_SEPARATOR + this._sValue + DEBUG_SEPARATOR + this.onFathers + DEBUG_SEPARATOR;
    }

    public static Element getXml(DFilter[][] dFilterArray) {
        Element element = new Element("filter");
        if (null != dFilterArray) {
            for (int i = 0; i < dFilterArray.length; ++i) {
                DFilter[] dFilterArray2 = dFilterArray[i];
                Element element2 = new Element("and");
                element.addChild(element2);
                for (int j = 0; j < dFilterArray2.length; ++j) {
                    Element element3 = new Element("or");
                    element2.addChild(element3);
                    Field field = dFilterArray2[j].getField();
                    element3.addAttribute("name", field.getName());
                    element3.addAttribute("family", dFilterArray2[j].getOperatorFamily());
                    element3.addAttribute("op", dFilterArray2[j].getOperator());
                    if (SlotField.class == field.getType()) {
                        element3.addAttribute("value", dFilterArray2[j].getIntValue());
                    } else {
                        element3.addAttribute("value", dFilterArray2[j].getValue());
                    }
                    element3.addAttribute("group", dFilterArray2[j].isOnFathers());
                }
            }
        }
        return element;
    }

    private static final int getIntValue(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static final double getDoubleValue(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    private static final long getTimeValue(String string) {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance();
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.parse(string).getTime();
        }
        catch (Throwable throwable) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return simpleDateFormat.parse(string).getTime();
            }
            catch (Throwable throwable2) {
                return 0L;
            }
        }
    }
}

