/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.filters;

import com.adesoft.fields.BooleanField;
import com.adesoft.fields.DateField;
import com.adesoft.fields.DateHourField;
import com.adesoft.fields.DoubleField;
import com.adesoft.fields.HourField;
import com.adesoft.fields.IntegerField;
import com.adesoft.fields.SlotField;
import com.adesoft.fields.StringField;
import com.adesoft.struct.Field;
import java.util.ArrayList;

public final class Operators {
    public static final int NONE = -1;
    public static final int STRING_OPERATOR = 0;
    public static final int NUMBER_OPERATOR = 1;
    public static final int BOOLEAN_OPERATOR = 2;
    public static final int DATE_OPERATOR = 3;
    public static final int COUNT_OPERATOR = 4;
    public static final int NUMBER_EQUAL = 0;
    public static final int NUMBER_DIFFERENT = 1;
    public static final int NUMBER_SUPERIOR = 2;
    public static final int NUMBER_SUPERIOR_EQUAL = 3;
    public static final int NUMBER_INFERIOR = 4;
    public static final int NUMBER_INFERIOR_EQUAL = 5;
    public static final int STRING_CONTAINS = 0;
    public static final int STRING_EQUAL = 1;
    public static final int STRING_NOT_CONTAINS = 2;
    public static final int STRING_NOT_EQUAL = 3;
    public static final int STRING_BEGINWITH = 4;
    public static final int STRING_NOT_BEGINWITH = 5;
    public static final int STRING_SUPERIOR = 6;
    public static final int STRING_INFERIOR = 7;
    public static final int STRING_SUPERIOR_EQUAL = 8;
    public static final int STRING_INFERIOR_EQUAL = 9;
    public static final int BOOLEAN_TRUE = 0;
    public static final int BOOLEAN_FALSE = 1;
    public static final int LIST_DIFFERENT = 0;
    public static final int LIST_EQUAL = 1;
    public static final int DATE_EQUAL = 0;
    public static final int DATE_DIFFERENT = 1;
    public static final int DATE_SUPERIOR = 2;
    public static final int DATE_SUPERIOR_EQUAL = 3;
    public static final int DATE_INFERIOR = 4;
    public static final int DATE_INFERIOR_EQUAL = 5;

    private Operators() {
    }

    public static boolean test(int n, boolean bl) {
        switch (n) {
            case 0: {
                return bl;
            }
            case 1: {
                return !bl;
            }
        }
        return true;
    }

    public static boolean test(int n, double d, double d2) {
        switch (n) {
            case 4: {
                return d < d2;
            }
            case 5: {
                return d <= d2;
            }
            case 2: {
                return d > d2;
            }
            case 3: {
                return d >= d2;
            }
            case 1: {
                return d != d2;
            }
            case 0: {
                return d == d2;
            }
        }
        return true;
    }

    public static boolean test(int n, long l, long l2) {
        switch (n) {
            case 4: {
                return l < l2;
            }
            case 5: {
                return l <= l2;
            }
            case 2: {
                return l > l2;
            }
            case 3: {
                return l >= l2;
            }
            case 1: {
                return l != l2;
            }
            case 0: {
                return l == l2;
            }
        }
        return true;
    }

    public static boolean test(int n, int n2, int n3) {
        switch (n) {
            case 4: {
                return n2 < n3;
            }
            case 5: {
                return n2 <= n3;
            }
            case 2: {
                return n2 > n3;
            }
            case 3: {
                return n2 >= n3;
            }
            case 1: {
                return n2 != n3;
            }
            case 0: {
                return n2 == n3;
            }
        }
        return true;
    }

    public static boolean test(int n, Object object, Object object2) {
        boolean bl = false;
        if (null != object && null != object2) {
            bl = object.equals(object2);
        }
        switch (n) {
            case 1: {
                return bl;
            }
            case 0: {
                return !bl;
            }
        }
        return true;
    }

    public static boolean test(int n, String string, String string2) {
        switch (n) {
            case 1: {
                return string.equalsIgnoreCase(string2);
            }
            case 3: {
                return !string.equalsIgnoreCase(string2);
            }
            case 0: {
                String string3 = string.toLowerCase();
                String string4 = string2.toLowerCase();
                return -1 != string3.indexOf(string4);
            }
            case 2: {
                String string5 = string.toLowerCase();
                String string6 = string2.toLowerCase();
                return -1 == string5.indexOf(string6);
            }
            case 4: {
                String string7 = string.toLowerCase();
                String string8 = string2.toLowerCase();
                return string7.startsWith(string8);
            }
            case 5: {
                String string9 = string.toLowerCase();
                String string10 = string2.toLowerCase();
                return !string9.startsWith(string10);
            }
            case 6: {
                return string.compareToIgnoreCase(string2) > 0;
            }
            case 7: {
                return string.compareToIgnoreCase(string2) < 0;
            }
            case 8: {
                return string.compareToIgnoreCase(string2) >= 0;
            }
            case 9: {
                return string.compareToIgnoreCase(string2) <= 0;
            }
        }
        return true;
    }

    public static int getOperatorFamily(Field field) {
        if (null == field) {
            return -1;
        }
        if (field.getType() == IntegerField.class) {
            return 1;
        }
        if (field.getType() == Boolean.class || field.getType() == BooleanField.class) {
            return 2;
        }
        if (field.getType() == String.class || field.getType() == StringField.class) {
            return 0;
        }
        if (field.getType() == DoubleField.class) {
            return 1;
        }
        if (field.getType() == DateField.class || field.getType() == DateHourField.class) {
            return 3;
        }
        if (field.getType() == HourField.class) {
            return 0;
        }
        if (field.getType() == SlotField.class) {
            return 1;
        }
        return -1;
    }

    public static Field[] getOnlyWithoutNoneFamily(Field[] fieldArray) {
        if (null == fieldArray || 0 == fieldArray.length) {
            return null;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (-1 == Operators.getOperatorFamily(fieldArray[i])) continue;
            arrayList.add(fieldArray[i]);
        }
        Field[] fieldArray2 = new Field[arrayList.size()];
        arrayList.toArray(fieldArray2);
        return fieldArray2;
    }
}

