/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.linkgraph;

import com.adesoft.linkgraph.GraphEdgeLink;
import com.adesoft.linkgraph.GraphElement;
import com.adesoft.linkgraph.GraphNodeCourse;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.io.Serializable;

public final class Edge
implements GraphElement,
Comparable,
Serializable {
    private static final long serialVersionUID = 520L;
    private final GraphNodeCourse firstNode;
    private final GraphNodeCourse nextNode;
    private final GraphEdgeLink edge;
    private transient Shape shape;
    private transient boolean draw;

    public Edge(GraphNodeCourse graphNodeCourse, GraphNodeCourse graphNodeCourse2, GraphEdgeLink graphEdgeLink) {
        this.firstNode = graphNodeCourse;
        this.nextNode = graphNodeCourse2;
        this.edge = graphEdgeLink;
    }

    public GraphNodeCourse getFirstNode() {
        return this.firstNode;
    }

    public GraphNodeCourse getNextNode() {
        return this.nextNode;
    }

    @Override
    public int getType() {
        return 2;
    }

    public GraphEdgeLink getEdge() {
        return this.edge;
    }

    @Override
    public int getOid() {
        return this.getEdge().getOid();
    }

    @Override
    public boolean isActive() {
        return this.getEdge().isActive();
    }

    public boolean isTwoWayEdge() {
        return this.getEdge().isTwoWayEdge();
    }

    public int getLinkType() {
        return this.getEdge().getLinkType();
    }

    public boolean haveLinkTowards() {
        return this.getEdge().haveLinkTowards();
    }

    public String toString() {
        return this.getEdge().toString();
    }

    @Override
    public String getShortLabel() {
        return this.getEdge().toString();
    }

    public int hashCode() {
        return this.getOid();
    }

    public boolean equals(Object object) {
        if (object instanceof Edge) {
            Edge edge = (Edge)object;
            if (null != this.nextNode) {
                return this.firstNode.equals(edge.firstNode) && this.nextNode.equals(edge.nextNode) && this.edge.equals(edge.edge);
            }
            return this.firstNode.equals(edge.firstNode) && null == edge.nextNode && this.edge.equals(edge.edge);
        }
        return false;
    }

    public final int compareTo(Object object) {
        return this.getOid() - ((GraphElement)object).getOid();
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public void setLine(Line2D line2D) {
        this.shape = line2D;
        this.draw = true;
    }

    public void setSingleEdgeLine(QuadCurve2D quadCurve2D) {
        this.shape = quadCurve2D;
        this.draw = true;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        if (this.isDraw()) {
            return this.getShape().intersects(rectangle);
        }
        return false;
    }

    @Override
    public void resizeWidth(double d) {
        if (this.isDraw()) {
            if (this.getShape() instanceof Line2D) {
                Line2D line2D = (Line2D)this.getShape();
                line2D.setLine(line2D.getX1() * d, line2D.getY1(), line2D.getX2() * d, line2D.getY2());
            } else {
                QuadCurve2D quadCurve2D = (QuadCurve2D)this.getShape();
                quadCurve2D.setCurve(quadCurve2D.getX1() * d, quadCurve2D.getY1(), quadCurve2D.getCtrlX() * d, quadCurve2D.getCtrlY(), quadCurve2D.getX2() * d, quadCurve2D.getY2());
            }
        }
    }

    @Override
    public boolean isDraw() {
        return this.draw;
    }
}

