/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.linkgraph;

import com.adesoft.struct.links.ConsecutiveInfo;
import com.adesoft.struct.links.NsdInfo;
import com.adesoft.struct.links.SequenceInfo;
import java.io.Serializable;

public final class GraphEdgeLink
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final int oid;
    private final String name;
    private final int[] coursesOids;
    private final boolean active;
    private final short linkBetween;
    private final boolean continuous;
    private final boolean overridable;
    private final int linkType;
    private final Object linkInfo;
    private int profileId;
    private final boolean twoWayEdge;
    private final boolean reverseEdges;
    private final boolean inSequence;

    public GraphEdgeLink(int n, short s, Object object, int n2, String string, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.oid = n2;
        this.name = string;
        this.coursesOids = nArray;
        this.active = bl;
        this.continuous = bl2;
        this.overridable = bl3;
        this.twoWayEdge = bl4;
        this.reverseEdges = bl5;
        this.inSequence = bl6;
        this.linkType = n;
        this.linkInfo = object;
        this.linkBetween = s;
    }

    public GraphEdgeLink(int n, short s, Object object, int n2, String string, int[] nArray, boolean bl, boolean bl2, boolean bl3, int n3, boolean bl4, boolean bl5, boolean bl6) {
        this(n, s, object, n2, string, nArray, bl, bl2, bl3, bl4, bl5, bl6);
        this.profileId = n3;
    }

    public int[] getCoursesOids() {
        return this.coursesOids;
    }

    public int getNbCourses() {
        return this.coursesOids.length;
    }

    public int getOid() {
        return this.oid;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReverseEdges() {
        return this.reverseEdges;
    }

    public boolean isTwoWayEdge() {
        return this.twoWayEdge;
    }

    public boolean isInSequence() {
        return this.inSequence;
    }

    public int getLinkType() {
        return this.linkType;
    }

    public short getLinkBetween() {
        return this.linkBetween;
    }

    public boolean haveLinkTowards() {
        return 3 == this.getLinkBetween() || 4 == this.getLinkBetween() || 5 == this.getLinkBetween() || 6 == this.getLinkBetween();
    }

    public NsdInfo getNsd() {
        return (NsdInfo)this.linkInfo;
    }

    public SequenceInfo getSequence() {
        return (SequenceInfo)this.linkInfo;
    }

    public ConsecutiveInfo getConsecutive() {
        return (ConsecutiveInfo)this.linkInfo;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GraphEdgeLink) {
            return this.getOid() == ((GraphEdgeLink)object).getOid();
        }
        return false;
    }
}

