/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.linkgraph;

import com.adesoft.collections.Iterators;
import com.adesoft.linkgraph.GraphElement;
import com.adesoft.linkgraph.GraphNodeCourse;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class GraphFolder
implements GraphElement,
Comparable,
Serializable {
    private static final long serialVersionUID = 520L;
    private final int fatherOid;
    private final int oid;
    private final String name;
    private final Color color;
    private transient GraphFolder father;
    private transient List children;
    private transient GraphNodeCourse[] courses;
    private transient Rectangle rectangle;
    private transient boolean open;
    private transient boolean draw;

    public GraphFolder(int n, int n2, String string, Color color) {
        this.fatherOid = n;
        this.oid = n2;
        this.name = string;
        this.color = color;
    }

    @Override
    public int getOid() {
        return this.oid;
    }

    public int getFatherOid() {
        return this.fatherOid;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getShortLabel() {
        if (null != this.name && this.name.length() > 20) {
            return this.name.substring(0, 20);
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GraphFolder) {
            return ((GraphFolder)object).getOid() == this.getOid();
        }
        return false;
    }

    public void setFather(GraphFolder graphFolder) {
        this.father = graphFolder;
    }

    public GraphFolder getFather() {
        return this.father;
    }

    public void addChild(GraphFolder graphFolder) {
        if (null == this.children) {
            this.children = new ArrayList();
        }
        this.children.add(graphFolder);
    }

    public Iterator children() {
        return null == this.children ? Iterators.EMPTY_ITERATOR : this.children.iterator();
    }

    public GraphFolder[] getChildren() {
        if (null == this.children) {
            return new GraphFolder[0];
        }
        GraphFolder[] graphFolderArray = new GraphFolder[this.children.size()];
        this.children.toArray(graphFolderArray);
        return graphFolderArray;
    }

    public boolean hasChildren() {
        return null != this.children && !this.children.isEmpty();
    }

    public void setRectangle(Rectangle rectangle) {
        if (null != this.rectangle) {
            int n = rectangle.x - this.rectangle.x;
            int n2 = rectangle.y - this.rectangle.y;
            this.translateChildren(n, n2);
        }
        this.rectangle = rectangle;
    }

    private void translateChildren(int n, int n2) {
        for (int i = 0; i < this.courses.length; ++i) {
            if (!this.courses[i].isDraw()) continue;
            this.courses[i].getRectangle().translate(n, n2);
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            GraphFolder graphFolder = (GraphFolder)iterator.next();
            if (!graphFolder.isDraw()) continue;
            graphFolder.translate(n, n2);
        }
    }

    private void translate(int n, int n2) {
        this.rectangle.setLocation(this.rectangle.x + n, this.rectangle.y + n2);
        this.translateChildren(n, n2);
    }

    @Override
    public Shape getShape() {
        return this.rectangle;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        if (this.isDraw()) {
            return this.rectangle.intersects(rectangle) || this.rectangle.contains(rectangle);
        }
        return false;
    }

    @Override
    public void resizeWidth(double d) {
        if (this.isDraw()) {
            Rectangle rectangle = this.getRectangle();
            rectangle.setBounds((int)((double)rectangle.x * d), rectangle.y, (int)((double)rectangle.width * d), rectangle.height);
        }
    }

    public void spreadX(double d) {
        if (this.isDraw()) {
            this.rectangle.x = (int)(10.0 + (double)this.rectangle.x * d);
            this.rectangle.y = (int)(10.0 + (double)this.rectangle.y * d);
        }
    }

    @Override
    public boolean isDraw() {
        return this.draw;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public void propagateOpen(boolean bl) {
        this.draw = !this.open && bl;
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            GraphFolder graphFolder = (GraphFolder)iterator.next();
            if (!this.open) {
                graphFolder.setOpen(false);
                graphFolder.propagateOpen(false);
                continue;
            }
            graphFolder.propagateOpen(true);
        }
        for (int i = 0; i < this.courses.length; ++i) {
            this.courses[i].setDraw(this, this.open);
        }
    }

    public GraphFolder getChildByOid(int n) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            GraphFolder graphFolder = (GraphFolder)iterator.next();
            if (graphFolder.getOid() != n) continue;
            return graphFolder;
        }
        return null;
    }

    public void setCourses(GraphNodeCourse[] graphNodeCourseArray) {
        this.courses = graphNodeCourseArray;
    }

    public GraphNodeCourse[] getCourses() {
        return this.courses;
    }

    public int getLevel() {
        int n = 0;
        for (GraphFolder graphFolder = this.getFather(); null != graphFolder; graphFolder = graphFolder.getFather()) {
            ++n;
        }
        return n;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public final int compareTo(Object object) {
        return this.getOid() - ((GraphElement)object).getOid();
    }
}

