/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.linkgraph;

import com.adesoft.collections.Iterators;
import com.adesoft.linkgraph.Edge;
import com.adesoft.linkgraph.GraphEdgeLink;
import com.adesoft.linkgraph.GraphElement;
import com.adesoft.linkgraph.GraphFolder;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public final class GraphNodeCourse
implements GraphElement,
Comparable,
Serializable {
    private static final long serialVersionUID = 520L;
    private final int id;
    private final int oid;
    private final boolean active;
    private final String name;
    private final Color color;
    private final int folderOid;
    private final String duration;
    private transient ArrayList edges;
    private transient ArrayList singleActivityEdges;
    private transient Rectangle rectangle;
    private transient boolean draw;
    private transient GraphFolder folder;
    public static final Comparator ID_SORT = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((GraphNodeCourse)object).getOid() - ((GraphNodeCourse)object2).getOid();
        }
    };

    public GraphNodeCourse(int n, int n2, int n3, boolean bl, String string, Color color, String string2) {
        this.folderOid = n;
        this.oid = n2;
        this.id = n3;
        this.active = bl;
        this.name = string;
        this.color = color;
        this.duration = string2;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getOid() {
        return this.oid;
    }

    public int getId() {
        return this.id;
    }

    public int getFolderOid() {
        return this.folderOid;
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getShortLabel() {
        if (null != this.name && this.name.length() > 20) {
            return this.name.substring(0, 20);
        }
        return this.name;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public String getDuration() {
        return this.duration;
    }

    public int hashCode() {
        return this.getOid();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GraphNodeCourse) {
            return this.getOid() == ((GraphNodeCourse)object).getOid();
        }
        return false;
    }

    public final int compareTo(Object object) {
        return this.getOid() - ((GraphElement)object).getOid();
    }

    public Edge addNextNode(GraphEdgeLink graphEdgeLink, GraphNodeCourse graphNodeCourse) {
        if (null == this.edges) {
            this.edges = new ArrayList();
        }
        Edge edge = new Edge(this, graphNodeCourse, graphEdgeLink);
        this.edges.add(edge);
        return edge;
    }

    public Edge addSingleActivityEdge(GraphEdgeLink graphEdgeLink) {
        if (null == this.singleActivityEdges) {
            this.singleActivityEdges = new ArrayList();
        }
        Edge edge = new Edge(this, null, graphEdgeLink);
        this.singleActivityEdges.add(edge);
        return edge;
    }

    public Iterator edges() {
        return null != this.edges ? this.edges.iterator() : Iterators.EMPTY_ITERATOR;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Override
    public Shape getShape() {
        return this.rectangle;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        if (this.isDraw()) {
            return this.rectangle.intersects(rectangle) || this.rectangle.contains(rectangle);
        }
        return false;
    }

    @Override
    public void resizeWidth(double d) {
        if (this.isDraw()) {
            Rectangle rectangle = this.getRectangle();
            rectangle.setBounds((int)((double)rectangle.x * d), rectangle.y, (int)((double)rectangle.width * d), rectangle.height);
        }
    }

    public void spreadX(double d) {
        if (this.isDraw()) {
            this.rectangle.x = (int)(10.0 + (double)this.rectangle.x * d);
            this.rectangle.y = (int)(10.0 + (double)this.rectangle.y * d);
        }
    }

    @Override
    public boolean isDraw() {
        return this.draw;
    }

    public void setDraw(GraphFolder graphFolder, boolean bl) {
        this.folder = graphFolder;
        this.draw = bl;
    }

    public GraphFolder getFolder() {
        return this.folder;
    }
}

