/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.login;

import com.adesoft.beans.FullAdeApi6;
import com.adesoft.config.ConfigManager;
import com.adesoft.log.Category;
import com.adesoft.login.WebSessions;
import com.adesoft.misc.Util;
import com.adesoft.properties.ServerProperty;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebClientAliveRegister
implements Runnable {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.login.WebClientAliveRegister");
    private long timer;
    private long lastCheckingTime;
    private AtomicBoolean stop;
    private AtomicBoolean pause;
    private List<String> registeredSessionList;
    private Thread executingThread;

    public WebClientAliveRegister(long l) {
        this.timer = l;
        this.lastCheckingTime = 0L;
        this.stop = new AtomicBoolean(true);
        this.pause = new AtomicBoolean(true);
        this.registeredSessionList = Collections.synchronizedList(new ArrayList());
    }

    public void stop() {
        this.stop.set(true);
        if (this.pause.get()) {
            try {
                this.executingThread.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public boolean isStop() {
        return this.stop.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(String string) {
        List<String> list = this.registeredSessionList;
        synchronized (list) {
            if (!this.registeredSessionList.contains(string)) {
                this.registeredSessionList.add(string);
                if (this.executingThread == null || !this.executingThread.isAlive()) {
                    this.executingThread = new Thread((Runnable)this, "Ade WebSessions Client Access Thread");
                    this.lastCheckingTime = 0L;
                    this.executingThread.start();
                }
            }
        }
    }

    public boolean unregisterClient(String string) {
        return this.registeredSessionList.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.stop.set(false);
        this.pause.set(false);
        this.executingThread = Thread.currentThread();
        while (!this.stop.get()) {
            if (this.pause.compareAndSet(false, true)) {
                Util.pause((long)this.timer);
                this.pause.set(false);
            }
            if (this.stop.get()) break;
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = this.registeredSessionList;
            synchronized (list) {
                for (String string : this.registeredSessionList) {
                    try {
                        FullAdeApi6 fullAdeApi6 = new FullAdeApi6();
                        fullAdeApi6.setSessionId(string);
                        Date date = fullAdeApi6.getLastAccessedTime();
                        if (date.getTime() >= this.lastCheckingTime) continue;
                        arrayList.add(string);
                    }
                    catch (RemoteException remoteException) {
                        LOG.error((Object)("WebClientAliveRegister: " + remoteException));
                    }
                }
                for (String string : arrayList) {
                    LOG.info((Object)("WebClientAliveRegister: disconnect dead session: " + string));
                    if (ConfigManager.getInstance().getBooleanProperty(ServerProperty.TRACE_TIMEOUTS)) {
                        LOG.security((Object)("Timeout from WebClientInactivity : " + string));
                    }
                    WebSessions.getInstance().disconnect(string);
                }
                this.registeredSessionList.removeAll(arrayList);
                this.stop.compareAndSet(false, this.registeredSessionList.isEmpty());
                this.lastCheckingTime = System.currentTimeMillis();
            }
        }
    }

    public boolean isPaused() {
        return this.pause.get();
    }

    public boolean wakeAndCheck() {
        boolean bl = false;
        if (!this.isStop() && this.pause.get()) {
            try {
                this.executingThread.interrupt();
                bl = true;
            }
            catch (SecurityException securityException) {
                bl = false;
            }
        }
        return bl;
    }
}

