/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.login;

import com.adesoft.beans.FullAdeApi6;
import com.adesoft.log.Category;
import com.adesoft.login.WebSessions;
import com.adesoft.misc.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebClientPinger
implements Runnable {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.login.WebClientPinger");
    private AtomicBoolean stop = new AtomicBoolean(true);
    private AtomicBoolean pause = new AtomicBoolean(true);
    private long timer;
    private Map<String, String> clientMap;
    private Thread thread;

    public WebClientPinger(long l) {
        this.timer = l;
        this.clientMap = new ConcurrentHashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(String string, String string2) {
        Map<String, String> map = this.clientMap;
        synchronized (map) {
            if (!this.clientMap.containsKey(string)) {
                this.clientMap.put(string, string2);
                if (this.thread == null || !this.thread.isAlive()) {
                    this.thread = new Thread((Runnable)this, "Ade WebSessions Client Pinger Thread");
                    this.thread.start();
                }
            }
        }
    }

    public String unregisterClient(String string) {
        return this.clientMap.remove(string);
    }

    public String getRegisterSession(String string) {
        return this.clientMap.get(string);
    }

    public void stop() {
        this.stop.set(true);
        if (this.pause.get()) {
            try {
                this.thread.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public boolean isStop() {
        return this.stop.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.stop.set(false);
        this.pause.set(false);
        while (!this.stop.get()) {
            if (this.pause.compareAndSet(false, true)) {
                Util.pause((long)this.timer);
                this.pause.set(false);
            }
            if (this.stop.get()) break;
            ArrayList<CopyEntryValue> arrayList = new ArrayList<CopyEntryValue>();
            Map<String, String> map = this.clientMap;
            synchronized (map) {
                for (Map.Entry<String, String> entry : this.clientMap.entrySet()) {
                    arrayList.add(new CopyEntryValue(entry.getKey(), entry.getValue()));
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                CopyEntryValue copyEntryValue = (CopyEntryValue)arrayList.get(i);
                String string = copyEntryValue.key;
                String string2 = copyEntryValue.value;
                if (string2 == null) continue;
                try {
                    FullAdeApi6 fullAdeApi6 = new FullAdeApi6();
                    fullAdeApi6.setSessionId(string2);
                    if (fullAdeApi6.pingFromClient()) continue;
                    this.removeWebSession(string);
                    continue;
                }
                catch (Throwable throwable) {
                    this.removeWebSession(string);
                }
            }
            this.stop.compareAndSet(false, this.clientMap.isEmpty());
        }
    }

    private void removeWebSession(String string) {
        try {
            this.clientMap.remove(string);
            LOG.info((Object)("WebClientPinger: remove session " + string));
            WebSessions.getInstance().removeSessionByIdentifier(string, false);
        }
        catch (Throwable throwable) {
            LOG.error((Object)("WebClientPinger: removeWebSession (" + string + ") " + throwable));
        }
    }

    private class CopyEntryValue {
        public String value;
        public String key;

        public CopyEntryValue(String string, String string2) {
            this.value = new String(string2);
            this.key = new String(string);
        }
    }
}

