/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.login;

import com.adesoft.beans.ApiXml6;
import com.adesoft.beans.HttpSessionRegister;
import com.adesoft.config.ConfigManager;
import com.adesoft.config.ServerLocation;
import com.adesoft.errors.InvalidLogin;
import com.adesoft.errors.TooManyConnections;
import com.adesoft.log.Category;
import com.adesoft.login.IWebClientCallback;
import com.adesoft.login.SSOProperties;
import com.adesoft.login.WebClientAliveRegister;
import com.adesoft.login.WebClientPinger;
import com.adesoft.login.WebSession;
import com.adesoft.properties.ClientProperty;
import com.adesoft.properties.ServerProperty;
import com.adesoft.proxies.RetryProvider;
import com.adesoft.proxies.RetryProxy;
import com.adesoft.security.EncryptedPassword;
import com.adesoft.server.Server;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class WebSessions
implements RetryProvider {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.login.WebSessions");
    private static final String DEFAULT_NAME = "ApiXml6";
    public static final String SERVERADE = "serverAde";
    private static WebSessions instance = new WebSessions();
    private WebClientPinger clientPinger = new WebClientPinger(Long.parseLong(ClientProperty.PING_INTERVAL.getDefaultValue()));
    private WebClientAliveRegister clientAliveRegister = new WebClientAliveRegister(Long.parseLong(ConfigManager.getInstance().getProperty(ServerProperty.WEBCLIENT_INACTIVITY)));
    private String serverAde;
    private int serverAdePort;
    private String serverName;
    private String serverWeb;
    private String adeVersion;
    private final ApiXml6 remoteProxy;
    private final Map<String, WebSession> sessionsById = new ConcurrentHashMap<String, WebSession>();
    private final Map<String, SSOProperties> serviceUrlByModule = new WeakHashMap<String, SSOProperties>();

    protected WebSessions() {
        this.remoteProxy = (ApiXml6)RetryProxy.newInstance((RetryProvider)this, ApiXml6.class);
        try {
            this.serverAde = ServerLocation.getInstance().getServerHost();
            this.serverAdePort = ServerLocation.getInstance().getServerPort();
            this.serverName = ServerLocation.getInstance().getServerName();
            this.serverWeb = ConfigManager.getInstance().getProperty(ServerProperty.WEB_SERVER);
            this.adeVersion = ((Server)ConfigManager.getInstance().getServer()).getVersionId();
        }
        catch (RuntimeException runtimeException) {
            LOG.error((Object)runtimeException);
        }
        catch (RemoteException remoteException) {
            LOG.error((Object)remoteException);
        }
    }

    public static WebSessions getInstance() {
        return instance;
    }

    private WebClientPinger getClientPinger() {
        return this.clientPinger;
    }

    private WebClientAliveRegister getClientAliveRegister() {
        return this.clientAliveRegister;
    }

    public synchronized ApiXml6 getRemote() {
        return this.remoteProxy;
    }

    public synchronized Object createProxyObject() {
        try {
            return (ApiXml6)Naming.lookup("rmi://" + this.getServerAde() + ':' + this.serverAdePort + '/' + DEFAULT_NAME);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Wrong server URL : " + malformedURLException);
        }
        catch (NotBoundException notBoundException) {
            throw new RuntimeException("Server is not bound : " + notBoundException);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Network error : " + remoteException);
        }
    }

    public void connect(String string) {
        try {
            String string2 = this.getPassword(string);
            if (null == string2) {
                throw new InvalidLogin();
            }
            byte[] byArray = this.getRemote().getPublicKey();
            String string3 = this.getRemote().getIdentifier(this.getLogin(string), EncryptedPassword.cipher(byArray, this.getPassword(string)));
            this.setIdentifier(string, string3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InvalidLogin();
        }
    }

    public void connect(String string, String string2, String string3, IWebClientCallback iWebClientCallback, InetAddress inetAddress, boolean bl) {
        try {
            String string4 = this.getPassword(string);
            if (null == string4) {
                throw new InvalidLogin();
            }
            byte[] byArray = this.getRemote().getPublicKey();
            String string5 = this.getRemote().getIdentifier(this.getLogin(string), EncryptedPassword.cipher(byArray, string4), string2, iWebClientCallback, inetAddress, bl);
            if (this.getRemote().isWebClientNotifiable(string5)) {
                this.setIdentifier(string, string5);
                this.getClientPinger().registerClient(string5, string);
                this.getClientAliveRegister().registerClient(string);
            } else {
                this.setIdentifier(string, string5);
            }
            this.getSession(string).setWebModule(string3);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvalidLogin) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 != null && throwable2 instanceof TooManyConnections) {
                    this.getClientAliveRegister().wakeAndCheck();
                }
                throw (InvalidLogin)throwable;
            }
            throw new InvalidLogin(throwable);
        }
    }

    public String connect(String string, String string2, String string3, String string4, String string5, IWebClientCallback iWebClientCallback, InetAddress inetAddress) {
        try {
            String[] stringArray = this.getRemote().getIdentifier(string, string3, string4, iWebClientCallback, inetAddress);
            this.setLogin(string2, stringArray[1]);
            if (this.getRemote().isWebClientNotifiable(stringArray[0])) {
                this.setIdentifier(string2, stringArray[0]);
                this.getClientPinger().registerClient(stringArray[0], string2);
                this.getClientAliveRegister().registerClient(string2);
            } else {
                this.setIdentifier(string2, stringArray[0]);
            }
            this.getSession(string2).setWebModule(string5);
            return stringArray[1];
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvalidLogin) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 != null && throwable2 instanceof TooManyConnections) {
                    this.getClientAliveRegister().wakeAndCheck();
                }
                throw (InvalidLogin)throwable;
            }
            throw new InvalidLogin(throwable);
        }
    }

    public void disconnect(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getIdentifier(string);
        if (string2 == null) {
            this.removeSession(string);
        } else {
            this.removeSessionByIdentifier(string2, true);
        }
        LOG.info((Object)("WebSessions: disconnect session= " + string + " - identifier=" + string2));
    }

    public Map<String, WebSession> getSessions() {
        return this.sessionsById;
    }

    protected WebSession getSession(String string) {
        WebSession webSession = this.sessionsById.get(string);
        if (null == webSession) {
            webSession = new WebSession(string);
            this.sessionsById.put(string, webSession);
        }
        return webSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionByIdentifier(String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, WebSession> entry : this.sessionsById.entrySet()) {
            if (!string.equals(entry.getValue().getIdentifier())) continue;
            arrayList.add(entry.getKey());
        }
        for (Map.Entry<String, WebSession> entry : arrayList) {
            this.sessionsById.remove(entry);
            this.getClientAliveRegister().unregisterClient((String)((Object)entry));
        }
        this.getClientPinger().unregisterClient(string);
        if (bl) {
            try {
                this.getRemote().removeIdentifier(string);
            }
            catch (Throwable throwable) {
                LOG.error((Object)("WebSessions: exception occured on removing session by identifier: " + throwable));
            }
            finally {
                HttpSessionRegister.getInstance().unregisterHttpSession(string);
            }
        }
    }

    public void removeSession(String string) {
        this.sessionsById.remove(string);
    }

    public int getProjectId(String string) {
        return this.getSession(string).getProjectId();
    }

    public String getPassword(String string) {
        String string2;
        WebSession webSession = this.getSession(string);
        String string3 = webSession.getPassword();
        if (string3 == null && (string2 = webSession.getIdentifier()) != null) {
            for (WebSession webSession2 : this.sessionsById.values()) {
                if (!string2.equals(webSession2.getIdentifier()) || webSession2.getPassword() == null) continue;
                string3 = webSession2.getPassword();
                webSession.setPassword(string3);
                break;
            }
        }
        return string3;
    }

    public String getLogin(String string) {
        String string2;
        WebSession webSession = this.getSession(string);
        String string3 = webSession.getLogin();
        if (string3 == null && (string2 = webSession.getIdentifier()) != null) {
            for (WebSession webSession2 : this.sessionsById.values()) {
                if (!string2.equals(webSession2.getIdentifier()) || webSession2.getLogin() == null) continue;
                string3 = webSession2.getLogin();
                webSession.setLogin(string3);
                break;
            }
        }
        return string3;
    }

    public String getIdentifier(String string) {
        return this.getSession(string).getIdentifier();
    }

    public void setProjectId(String string, int n) {
        this.getSession(string).setProjectId(n);
    }

    public void setPassword(String string, String string2) {
        this.getSession(string).setPassword(string2);
    }

    public void setLogin(String string, String string2) {
        this.getSession(string).setLogin(string2);
    }

    public void setIdentifier(String string, String string2) {
        this.getSession(string).setIdentifier(string2);
    }

    public void setClientTimeZone(String string, TimeZone timeZone) {
        this.getSession(string).setClientTimeZone(timeZone);
    }

    public TimeZone getClientTimeZone(String string) {
        return this.getSession(string).getClientTimeZone();
    }

    public String getServerAde() {
        return this.serverAde;
    }

    public int getServerAdePort() {
        return this.serverAdePort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerWeb() {
        return this.serverWeb;
    }

    public void setServer(String string) {
        this.serverAde = string;
    }

    public void setServerPort(int n) {
        this.serverAdePort = n;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setServerWeb(String string) {
        this.serverWeb = string;
    }

    public String getAdeVersion() {
        return this.adeVersion;
    }

    public SSOProperties getSSOProperties(String string) {
        return this.serviceUrlByModule.get(string);
    }

    public void setSSOProperties(String string, SSOProperties sSOProperties) {
        this.serviceUrlByModule.put(string, sSOProperties);
    }

    public void stopWebClientPinger() {
        if (this.clientPinger != null) {
            this.clientPinger.stop();
        }
    }

    public void stopWebClientAliveRegister() {
        if (this.clientAliveRegister != null) {
            this.clientAliveRegister.stop();
        }
    }
}

