/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.pac;

import com.adesoft.beans.AdeApi;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.CalendarBean;
import com.adesoft.beans.ClientBean;
import com.adesoft.beans.CustomAction;
import com.adesoft.beans.filters.FiltersPacParticipants;
import com.adesoft.beans.filters.FiltersResources;
import com.adesoft.beans.settings.EventSettings;
import com.adesoft.beans.settings.PacAttendanceSettings;
import com.adesoft.config.ConfigManager;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.NotFoundException;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.pac.PacScanConfig;
import com.adesoft.pac.PacScanLogger;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import com.google.zxing.oned.Code128Reader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.jdom.Element;

public class PacScan
implements CustomAction {
    private PacScanLogger log;
    private AdeApi api;
    private CalendarBean calendar;
    private PacScanConfig pacScanConfig;
    private String groupsCategory;
    private String studentsCategory;
    private List<SessionAndStudentsIds> sessionAndStudentsList;
    private Map<String, String> filesPath;
    boolean isFromTask;

    public PacScan() {
        this.isFromTask = true;
    }

    public PacScan(Map<String, String> map) {
        this.isFromTask = false;
        this.filesPath = map;
    }

    public PacScanLogger getLog() {
        return this.log;
    }

    private void getConfiguration() {
        String string;
        Element element = ConfigManager.getInstance().readXmlFile("Pac");
        Element element2 = element.getChild("PACScan");
        if (null != element2) {
            string = element2.getString("scanLog");
            String string2 = element2.getString("scanDir");
            String string3 = element2.getString("scanMail", "");
            String string4 = element2.getString("login");
            String string5 = element2.getString("password");
            this.pacScanConfig = new PacScanConfig(string, string2, string3, string4, string5);
        }
        if (null != (string = element.getChild("PACADELink"))) {
            this.groupsCategory = string.getString("groups", "trainee");
            this.studentsCategory = string.getString("students", "category8");
        }
    }

    private void init() {
        String string = "";
        try {
            string = this.api.getProjectById(this.api.getProjectId()).getString("name");
        }
        catch (AdeException | RemoteException | SQLException exception) {
            exception.printStackTrace();
        }
        this.log = new PacScanLogger(this.pacScanConfig.getPacLogDir(), string);
        this.sessionAndStudentsList = new ArrayList<SessionAndStudentsIds>();
    }

    public void startFromClient(AdeApi adeApi, CalendarBean calendarBean, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("projectId", string);
        this.start(adeApi, null, calendarBean, -1, -1L, hashMap, null);
    }

    @Override
    public void start(AdeApi adeApi, ClientBean clientBean, CalendarBean calendarBean, int n, long l, HashMap<String, String> hashMap, ArrayList<String> arrayList) {
        this.getConfiguration();
        this.api = adeApi;
        this.calendar = calendarBean;
        int n2 = Integer.parseInt(hashMap.get("projectId"));
        adeApi.setProjectId(n2);
        adeApi.setLogin(this.pacScanConfig.getLogin());
        adeApi.setPassword(this.pacScanConfig.getPassword());
        this.init();
        this.log.log("d\u00e9but de traitement", true);
        if (this.filesPath == null) {
            Path path2 = Paths.get(this.pacScanConfig.getScanDir(), new String[0]);
            PathMatcher pathMatcher = path2.getFileSystem().getPathMatcher("glob:**.{[gG][iI][fF],[jJ][pP][eE][gG],[jJ][pP][gG],[pP][nN][gG],[pP][dD][fF]}");
            try (Stream<Path> stream = Files.list(path2);){
                this.filesPath = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(pathMatcher::matches).map(Path::toString).collect(Collectors.toMap(string -> string, string -> string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.log.log("Erreur : " + iOException.getMessage());
            }
        }
        this.filesPath.entrySet().stream().forEach(this::scanFile);
        try {
            this.doPac();
        }
        catch (NotFoundException | ProjectNotFoundException | IOException exception) {
            exception.printStackTrace();
            this.log.log("Erreur : " + exception.getMessage());
        }
        this.filesPath.values().stream().map(string -> Paths.get(string, new String[0])).forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.log.log("Erreur : " + iOException.getMessage());
            }
        });
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(Map.Entry<String, String> entry) {
        block9: {
            try {
                if (this.isFromTask) {
                    this.log.log("Lecture du fichier " + Paths.get(entry.getValue(), new String[0]).getFileName().toString());
                }
                if (entry.getKey().toLowerCase().endsWith(".pdf")) {
                    File file = new File(entry.getValue());
                    try (PDDocument pDDocument = PDDocument.load((File)file);){
                        PDPageTree pDPageTree = pDDocument.getPages();
                        for (PDPage pDPage : pDPageTree) {
                            PDResources pDResources = pDPage.getResources();
                            for (COSName cOSName : pDResources.getXObjectNames()) {
                                PDXObject pDXObject = pDResources.getXObject(cOSName);
                                if (!(pDXObject instanceof PDImageXObject)) continue;
                                BufferedImage bufferedImage = ((PDImageXObject)pDXObject).getImage();
                                this.sessionAndStudentsList.add(this.scanCodes(bufferedImage));
                            }
                        }
                        break block9;
                    }
                }
                BufferedImage bufferedImage = ImageIO.read(new File(entry.getValue()));
                this.sessionAndStudentsList.add(this.scanCodes(bufferedImage));
            }
            catch (com.google.zxing.NotFoundException | IOException throwable) {
                throwable.printStackTrace();
                this.log.log("Erreur : " + throwable.getMessage());
            }
        }
    }

    private void doPac() throws NotFoundException, ProjectNotFoundException, RemoteException {
        Map<Integer, Set> map = this.sessionAndStudentsList.stream().collect(Collectors.toMap(sessionAndStudentsIds -> sessionAndStudentsIds.getSessionId(), sessionAndStudentsIds -> sessionAndStudentsIds.getStudentsIds(), (set, set2) -> Stream.concat(set.stream(), set2.stream()).collect(Collectors.toSet())));
        for (Map.Entry<Integer, Set> entry : map.entrySet()) {
            int n = entry.getKey();
            Set set3 = entry.getValue();
            if (n > 0) {
                String string;
                Element element2;
                EventSettings eventSettings = new EventSettings();
                eventSettings.setEventId(n);
                try {
                    element2 = this.api.getEventById(eventSettings, 8);
                }
                catch (NotFoundException | ProjectNotFoundException | RemoteException exception) {
                    this.log.log("Erreur traitement s\u00e9ance : " + exception.getMessage());
                    exception.printStackTrace();
                    return;
                }
                String string2 = element2.getAttributeValue("name");
                String string3 = element2.getAttributeValue("startHour");
                String string4 = element2.getAttributeValue("date");
                int n2 = element2.getInt("week");
                int n3 = element2.getInt("day");
                int n4 = element2.getInt("slot");
                int n5 = element2.getInt("duration");
                Date date = null;
                Date date2 = null;
                date = this.calendar.getDate(n2, n3, n4);
                date2 = this.calendar.getDate(n2, n3, n4 + n5);
                this.log.log("Traitement en cours s\u00e9ance \"" + string2 + "\" du " + string4 + " \u00e0 " + string3);
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                Element[] elementArray = element2.getChild("resources").getChildrenArray();
                for (Element element3 : elementArray) {
                    string = element3.getString("category");
                    if (string.equals(this.groupsCategory)) {
                        int n6 = element3.getInt("id");
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        arrayList.add(n6);
                        FiltersResources filtersResources = new FiltersResources();
                        filtersResources.addFilterGroups(arrayList);
                        filtersResources.addFilterTree(false, true);
                        Element[] elementArray2 = this.api.getResources(filtersResources, 1).getChildrenArray();
                        arrayList.clear();
                        for (Object object2 : elementArray2) {
                            arrayList.add(object2.getInt("id"));
                        }
                        AdeList object = new AdeList(arrayList);
                        FiltersPacParticipants filtersPacParticipants = new FiltersPacParticipants();
                        filtersPacParticipants.addFilterGroups(object);
                        try {
                            Object object2;
                            List list = this.api.getPacParticipants(filtersPacParticipants).getChildren();
                            object2 = list.stream().collect(Collectors.toMap(element -> element.getInt("id"), element -> {
                                int n;
                                int n2 = n = -10;
                                for (Element element2 : element.getChild("pacParticipantGroups").getChildrenArray()) {
                                    int n3 = element2.getInt("id");
                                    Iterator iterator = arrayList.iterator();
                                    while (iterator.hasNext()) {
                                        int n4 = (Integer)iterator.next();
                                        if (n3 != n4) continue;
                                        n2 = n3;
                                        break;
                                    }
                                    if (n2 != n) break;
                                }
                                return n2;
                            }));
                            hashMap.putAll((Map<Integer, Integer>)object2);
                        }
                        catch (NotFoundException | RemoteException | SQLException exception) {
                            this.log.log("Erreur traitement s\u00e9ance \"" + string2 + " ; " + exception.getMessage());
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    if (!string.equals(this.studentsCategory)) continue;
                    hashMap.put(element3.getInt("id"), -10);
                }
                for (Map.Entry entry2 : hashMap.entrySet()) {
                    PacAttendanceSettings pacAttendanceSettings = new PacAttendanceSettings();
                    pacAttendanceSettings.setPacParticipantId((Integer)entry2.getKey());
                    pacAttendanceSettings.setResourceId((Integer)entry2.getValue());
                    pacAttendanceSettings.setStartDate(date);
                    pacAttendanceSettings.setEndDate(date2);
                    if (set3.contains(entry2.getKey())) {
                        pacAttendanceSettings.setValue(0);
                    } else {
                        pacAttendanceSettings.setValue(1);
                    }
                    try {
                        this.api.createPacAttendances(pacAttendanceSettings);
                    }
                    catch (SQLException sQLException) {
                        string = this.api.getResourceById((Integer)entry2.getKey(), 2).getAttributeValue("name");
                        this.log.log("Erreur traitement s\u00e9ance \"" + string2 + " du " + string4 + " \u00e0 " + string3 + " pour \u00e9tudiant " + string + ", enregistrement d\u00e9j\u00e0 existant");
                        sQLException.printStackTrace();
                    }
                    catch (NotFoundException | RemoteException exception) {
                        try {
                            exception.printStackTrace();
                            string = this.api.getResourceById((Integer)entry2.getKey(), 2).getAttributeValue("name");
                            this.log.log("Erreur traitement s\u00e9ance \"" + string2 + " du " + string4 + " \u00e0 " + string3 + " pour \u00e9tudiant " + string);
                        }
                        catch (NotFoundException notFoundException) {
                            notFoundException.printStackTrace();
                            this.log.log("Erreur traitement s\u00e9ance \"" + string2 + " du " + string4 + " \u00e0 " + string3 + ", \u00e9tudiant non trouv\u00e9, id : " + entry2.getKey());
                        }
                    }
                }
                this.api.lockEventDate(new EventSettings(n));
                continue;
            }
            this.log.log("Erreur traitement s\u00e9ance : code-barres s\u00e9ance non trouv\u00e9");
        }
    }

    private SessionAndStudentsIds scanCodes(BufferedImage bufferedImage) throws com.google.zxing.NotFoundException, IOException {
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (bufferedImage != null) {
            BufferedImageLuminanceSource bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)bufferedImageLuminanceSource));
            Code128Reader code128Reader = new Code128Reader();
            Hashtable<DecodeHintType, Boolean> hashtable = new Hashtable<DecodeHintType, Boolean>();
            hashtable.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
            GenericMultipleBarcodeReader genericMultipleBarcodeReader = new GenericMultipleBarcodeReader((Reader)code128Reader);
            try {
                Result[] resultArray;
                for (Result result : resultArray = genericMultipleBarcodeReader.decodeMultiple(binaryBitmap, hashtable)) {
                    String string = result.toString();
                    if (string.startsWith("s")) {
                        n = Integer.parseInt(string.substring(1));
                        continue;
                    }
                    hashSet.add(Integer.parseInt(string));
                }
            }
            catch (Exception exception) {
                this.log.log("page vide ?");
            }
        }
        return new SessionAndStudentsIds(n, hashSet);
    }

    public void end() {
        this.log.log("Fin de traitement", true);
        try {
            if (this.isFromTask) {
                if (!this.pacScanConfig.getScanMail().isEmpty()) {
                    this.api.sendMail(this.pacScanConfig.getScanMail(), "Rapport PAC", this.log.getLogContentForMail().toString());
                }
                this.log.cleanLogContentForMail();
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            this.log.log("Erreur d'evoi de mail, " + remoteException.getMessage());
        }
        finally {
            this.log.close();
        }
    }

    private class SessionAndStudentsIds {
        private int sessionId;
        private Set<Integer> studentsIds;

        public SessionAndStudentsIds(int n, Set<Integer> set) {
            this.sessionId = n;
            this.studentsIds = set;
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public Set<Integer> getStudentsIds() {
            return this.studentsIds;
        }
    }
}

