/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.security;

import com.adesoft.log.Category;
import com.adesoft.security.EncryptedPassword;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.spec.DHParameterSpec;

public final class EncryptKeys {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.util.EncryptKeys");
    private static EncryptKeys instance = new EncryptKeys();
    private final KeyPairGenerator keyPairGen;
    private final Set<KeyPair> keys = Collections.newSetFromMap(new ConcurrentHashMap());

    private EncryptKeys() {
        this.keyPairGen = this.getKeyPairGenerator();
    }

    private KeyPairGenerator getKeyPairGenerator() {
        DHParameterSpec dHParameterSpec = new DHParameterSpec(EncryptedPassword.skip1024Modulus, EncryptedPassword.skip1024Base);
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
            keyPairGenerator.initialize(dHParameterSpec);
            return keyPairGenerator;
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable);
            return null;
        }
    }

    public static EncryptKeys getInstance() {
        return instance;
    }

    public byte[] getNextPublicKey() {
        try {
            KeyPair keyPair = this.keyPairGen.generateKeyPair();
            byte[] byArray = keyPair.getPublic().getEncoded();
            this.keys.add(keyPair);
            return byArray;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Invalid KeyPairGenerator : " + throwable);
        }
    }

    public PrivateKey getPrivateKey(byte[] byArray) {
        for (KeyPair keyPair : this.keys) {
            if (!Arrays.equals(keyPair.getPublic().getEncoded(), byArray)) continue;
            return keyPair.getPrivate();
        }
        throw new IllegalArgumentException("Invalid PublicKey");
    }
}

