/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.security;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;

public final class EncryptedPassword
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final byte[] encryptedMsg;
    private final byte[] publicKey;
    private final byte[] serverPublicKey;
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    public static final BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    public static final BigInteger skip1024Base = BigInteger.valueOf(2L);

    private EncryptedPassword(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.encryptedMsg = byArray;
        this.publicKey = byArray2;
        this.serverPublicKey = byArray3;
    }

    public static EncryptedPassword cipher(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        return EncryptedPassword._cipher(byArray, byArray2);
    }

    public static EncryptedPassword cipher(byte[] byArray, String string) throws GeneralSecurityException {
        return EncryptedPassword._cipher(byArray, string.getBytes());
    }

    public static EncryptedPassword cipher(byte[] byArray, char[] cArray) throws GeneralSecurityException {
        return EncryptedPassword._cipher(byArray, new String(cArray, 0, cArray.length).getBytes());
    }

    private static EncryptedPassword _cipher(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("DH");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
        keyPairGenerator.initialize(((DHPublicKey)publicKey).getParams());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        keyAgreement.init(keyPair.getPrivate());
        keyAgreement.doPhase(publicKey, true);
        SecretKey secretKey = keyAgreement.generateSecret("DES");
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, secretKey);
        byte[] byArray3 = cipher.doFinal(byArray2);
        byte[] byArray4 = keyPair.getPublic().getEncoded();
        return new EncryptedPassword(byArray3, byArray4, byArray);
    }

    public byte[] getEncryptedMsg() {
        return this.encryptedMsg;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getServerPublicKey() {
        return this.serverPublicKey;
    }

    public String decipher(PrivateKey privateKey) throws GeneralSecurityException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.getPublicKey());
        KeyFactory keyFactory = KeyFactory.getInstance("DH");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        SecretKey secretKey = keyAgreement.generateSecret("DES");
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, secretKey);
        return new String(cipher.doFinal(this.getEncryptedMsg()));
    }
}

