/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public final class Md5Digest {
    private final byte[] _key;
    private final MessageDigest _digest;

    public Md5Digest() throws NoSuchAlgorithmException {
        this._key = Md5Digest.getRandomKey();
        this._digest = MessageDigest.getInstance("MD5");
    }

    public Md5Digest(String string) throws NoSuchAlgorithmException {
        this._key = Md5Digest.prepareKey(string);
        this._digest = MessageDigest.getInstance("MD5");
    }

    private static byte[] prepareKey(String string) {
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        return string.getBytes();
    }

    private static byte[] getRandomKey() {
        Random random = new Random();
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        return byArray;
    }

    private byte[] getKey() {
        return this._key;
    }

    public static String asHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Long.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    public byte[] getKey(String string) {
        byte[] byArray = this.getKey();
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = new byte[byArray2.length + 64 + byArray.length];
        byte[] byArray4 = new byte[64];
        Arrays.fill(byArray4, "+".getBytes()[0]);
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray4, 0, byArray3, 0, 64);
        System.arraycopy(byArray2, 0, byArray3, 64, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, 64 + byArray2.length, byArray.length);
        this._digest.update(byArray3);
        byte[] byArray5 = this._digest.digest();
        byte[] byArray6 = new byte[byArray5.length];
        for (int i = 0; i < byArray5.length; i += 4) {
            byArray6[i] = byArray5[i + 3];
            byArray6[i + 1] = byArray5[i + 2];
            byArray6[i + 2] = byArray5[i + 1];
            byArray6[i + 3] = byArray5[i];
        }
        return byArray6;
    }
}

