/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.server;

import com.adesoft.arrays.IntArray;
import com.adesoft.collections.HashKeyEnum;
import com.adesoft.collections.MyHashTable;
import com.adesoft.server.Permission;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

public final class AllPermissions
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final Permission[] refPermissions;
    private final MyHashTable permissionsByUserOid;

    public AllPermissions(Permission[] permissionArray) {
        this.refPermissions = permissionArray;
        this.permissionsByUserOid = new MyHashTable();
    }

    private HashSet getPermissionsArray(int n) {
        HashSet hashSet = (HashSet)this.permissionsByUserOid.get(n);
        if (null == hashSet) {
            hashSet = new HashSet();
            this.permissionsByUserOid.put(n, hashSet);
        }
        return hashSet;
    }

    public void addPermission(Permission permission, int n) {
        HashSet hashSet = this.getPermissionsArray(n);
        hashSet.add(permission);
    }

    public void removePermission(Permission permission, int n) {
        HashSet hashSet = this.getPermissionsArray(n);
        hashSet.remove((Object)permission);
    }

    public Permission[] getRefPermissions() {
        return this.refPermissions;
    }

    public Permission[] getPermissions(int n) {
        HashSet hashSet = this.getPermissionsArray(n);
        Permission[] permissionArray = new Permission[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            permissionArray[n2] = (Permission)((Object)iterator.next());
            ++n2;
        }
        return permissionArray;
    }

    public int[] getUserOids() {
        IntArray intArray = new IntArray();
        HashKeyEnum hashKeyEnum = this.permissionsByUserOid.keys();
        while (hashKeyEnum.hasMoreKeys()) {
            intArray.add(hashKeyEnum.nextKey());
        }
        return intArray.getValues();
    }
}

