/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.server;

import com.adesoft.config.ConfigManager;
import com.adesoft.misc.Enum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;

public final class Permission
extends Enum {
    private static final long serialVersionUID = 520L;
    private static final String FILENAME = "Permissions";
    private static final Map indexByName = new TreeMap();
    public static final Permission GLOBAL_ADD_GROUP = new Permission("GLOBAL_ADD_GROUP", "$GLOBAL_ADD_GROUP", true);
    public static final Permission GLOBAL_ADD_USER = new Permission("GLOBAL_ADD_USER", "$GLOBAL_ADD_USER", true);
    public static final Permission GLOBAL_REMOVE_GROUP = new Permission("GLOBAL_REMOVE_GROUP", "$GLOBAL_REMOVE_GROUP", true);
    public static final Permission GLOBAL_REMOVE_USER = new Permission("GLOBAL_REMOVE_USER", "$GLOBAL_REMOVE_USER", true);
    public static final Permission GLOBAL_MODIFY_GROUP = new Permission("GLOBAL_MODIFY_GROUP", "$GLOBAL_MODIFY_GROUP", true);
    public static final Permission GLOBAL_MODIFY_USER = new Permission("GLOBAL_MODIFY_USER", "$GLOBAL_MODIFY_USER", true);
    public static final Permission GLOBAL_MODIFY_RIGHTS = new Permission("GLOBAL_MODIFY_RIGHTS", "$GLOBAL_MODIFY_RIGHTS", true);
    public static final Permission GLOBAL_CREATE_PROJECT = new Permission("GLOBAL_CREATE_PROJECT", "$GLOBAL_CREATE_PROJECT", true);
    public static final Permission GLOBAL_REMOVE_PROFILE = new Permission("GLOBAL_REMOVE_PROFILE", "$GLOBAL_REMOVE_PROFILE", true);
    public static final Permission GLOBAL_MODIFY_PROFILE = new Permission("GLOBAL_MODIFY_PROFILE", "$GLOBAL_MODIFY_PROFILE", true);
    public static final Permission GLOBAL_ADD_PROFILE = new Permission("GLOBAL_ADD_PROFILE", "$GLOBAL_ADD_PROFILE", true);
    public static final Permission GLOBAL_USE_CLIENT = new Permission("GLOBAL_USE_CLIENT", "$GLOBAL_USE_CLIENT", true);
    public static final Permission PROJECTS_MODIFY_RIGHTS = new Permission("PROJECTS_MODIFY_RIGHTS", "$PROJECTS_MODIFY_RIGHTS", false);
    public static final Permission PROJECTS_CREATE_PARTICIPANT = new Permission("PROJECTS_CREATE_PARTICIPANT", "$PROJECTS_CREATE_PARTICIPANT", false);
    public static final Permission PROJECTS_CREATE_STUDENT = new Permission("PROJECTS_CREATE_STUDENT", "$PROJECTS_CREATE_STUDENT", false);
    public static final Permission PROJECTS_CREATE_TEACHER = new Permission("PROJECTS_CREATE_TEACHER", "$PROJECTS_CREATE_TEACHER", false);
    public static final Permission PROJECTS_CREATE_ROOM = new Permission("PROJECTS_CREATE_ROOM", "$PROJECTS_CREATE_ROOM", false);
    public static final Permission PROJECTS_CREATE_EQUIPMENT = new Permission("PROJECTS_CREATE_EQUIPMENT", "$PROJECTS_CREATE_EQUIPMENT", false);
    public static final Permission PROJECTS_CREATE_CATEGORY5 = new Permission("PROJECTS_CREATE_CATEGORY5", "$PROJECTS_CREATE_CATEGORY5", false);
    public static final Permission PROJECTS_CREATE_CATEGORY6 = new Permission("PROJECTS_CREATE_CATEGORY6", "$PROJECTS_CREATE_CATEGORY6", false);
    public static final Permission PROJECTS_CREATE_CATEGORY7 = new Permission("PROJECTS_CREATE_CATEGORY7", "$PROJECTS_CREATE_CATEGORY7", false);
    public static final Permission PROJECTS_CREATE_CATEGORY8 = new Permission("PROJECTS_CREATE_CATEGORY8", "$PROJECTS_CREATE_CATEGORY8", false);
    public static final Permission PROJECTS_CREATE_ACTIVITY = new Permission("PROJECTS_CREATE_ACTIVITY", "$PROJECTS_CREATE_ACTIVITY", false);
    public static final Permission PROJECTS_CREATE_ROOT_ACTIVITY = new Permission("PROJECTS_CREATE_ROOT_ACTIVITY", "$PROJECTS_CREATE_ROOT_ACTIVITY", false);
    public static final Permission PROJECTS_CREATE_LINK = new Permission("PROJECTS_CREATE_LINK", "$PROJECTS_CREATE_LINK", false);
    public static final Permission PROJECTS_EDIT_COSTS = new Permission("PROJECTS_EDIT_COSTS", "$PROJECTS_EDIT_COSTS", false);
    public static final Permission PROJECTS_CREATE_SITES = new Permission("PROJECTS_CREATE_SITES", "$PROJECTS_CREATE_SITES", false);
    public static final Permission PROJECTS_EDIT_SITES = new Permission("PROJECTS_EDIT_SITES", "$PROJECTS_EDIT_SITES", false);
    public static final Permission PROJECTS_EDIT_COUNTERSMOVING = new Permission("PROJECTS_EDIT_COUNTERSMOVING", "$PROJECTS_EDIT_COUNTERSMOVING", false);
    public static final Permission PROJECTS_EDIT_CALENDAR = new Permission("PROJECTS_EDIT_CALENDAR", "$PROJECTS_EDIT_CALENDAR", false);
    public static final Permission PROJECTS_EDIT_DEFAULT_GRID = new Permission("PROJECTS_EDIT_DEFAULT_GRID", "$PROJECTS_EDIT_DEFAULT_GRID", false);
    public static final Permission PROJECTS_EDIT_GRID = new Permission("PROJECTS_EDIT_GRID", "$PROJECTS_EDIT_GRID", false);
    public static final Permission PROJECTS_EDIT_SPECIFIC_GRID = new Permission("PROJECTS_EDIT_SPECIFIC_GRID", "$PROJECTS_EDIT_SPECIFIC_GRID", false);
    public static final Permission PROJECTS_START_OPTIMIZATION = new Permission("PROJECTS_START_OPTIMIZATION", "$PROJECTS_START_OPTIMIZATION", false);
    public static final Permission PROJECTS_FORCE_SCHEDULING = new Permission("PROJECTS_FORCE_SCHEDULING", "$PROJECTS_FORCE_SCHEDULING", false);
    public static final Permission PROJECTS_MODIFY_OPTIMIZATION_PARAMETERS = new Permission("PROJECTS_MODIFY_OPTIMIZATION_PARAMETERS", "$PROJECTS_MODIFY_OPTIMIZATION_PARAMETERS", false);
    public static final Permission PROJECTS_CREATE_CONFIGURATION = new Permission("PROJECTS_CREATE_CONFIGURATION", "$PROJECTS_CREATE_CONFIGURATION", false);
    public static final Permission PROJECTS_CREATE_TIMEFRAME = new Permission("PROJECTS_CREATE_TIMEFRAME", "$PROJECTS_CREATE_TIMEFRAME", false);
    public static final Permission PROJECTS_CREATE_DYNAMIC_LIST = new Permission("PROJECTS_CREATE_DYNAMIC_LIST", "$PROJECTS_CREATE_DYNAMIC_LIST", false);
    public static final Permission PROJECTS_PAC_ATTENDANCE = new Permission("PROJECTS_PAC_ATTENDANCE", "$PROJECTS_PAC_ATTENDANCE", false);
    public static final Permission PROJECTS_PAC_CHECKING = new Permission("PROJECTS_PAC_CHECKING", "$PROJECTS_PAC_CHECKING", false);
    public static final Permission PROJECTS_PAC_DASHBOARD = new Permission("PROJECTS_PAC_DASHBOARD", "$PROJECTS_PAC_DASHBOARD", false);
    public static final Permission PROJECTS_PAC_ASSIGNMENT = new Permission("PROJECTS_PAC_ASSIGNMENT", "$PROJECTS_PAC_ASSIGNMENT", false);
    private static Permission[] DYNAMIC = new Permission[0];
    private static Permission[] GLOBAL_PERMISSIONS = new Permission[]{GLOBAL_ADD_GROUP, GLOBAL_ADD_USER, GLOBAL_REMOVE_GROUP, GLOBAL_REMOVE_USER, GLOBAL_MODIFY_GROUP, GLOBAL_MODIFY_USER, GLOBAL_MODIFY_RIGHTS, GLOBAL_CREATE_PROJECT, GLOBAL_REMOVE_PROFILE, GLOBAL_MODIFY_PROFILE, GLOBAL_ADD_PROFILE, GLOBAL_USE_CLIENT};
    private static Permission[] PROJECTS_PERMISSIONS = new Permission[]{PROJECTS_MODIFY_RIGHTS, PROJECTS_CREATE_PARTICIPANT, PROJECTS_CREATE_ACTIVITY, PROJECTS_CREATE_ROOT_ACTIVITY, PROJECTS_CREATE_LINK, PROJECTS_EDIT_COSTS, PROJECTS_CREATE_SITES, PROJECTS_EDIT_SITES, PROJECTS_EDIT_COUNTERSMOVING, PROJECTS_EDIT_CALENDAR, PROJECTS_EDIT_DEFAULT_GRID, PROJECTS_EDIT_SPECIFIC_GRID, PROJECTS_START_OPTIMIZATION, PROJECTS_FORCE_SCHEDULING, PROJECTS_MODIFY_OPTIMIZATION_PARAMETERS, PROJECTS_CREATE_CONFIGURATION, PROJECTS_CREATE_TIMEFRAME, PROJECTS_CREATE_DYNAMIC_LIST, PROJECTS_PAC_ATTENDANCE, PROJECTS_PAC_CHECKING, PROJECTS_PAC_DASHBOARD, PROJECTS_PAC_ASSIGNMENT, PROJECTS_CREATE_STUDENT, PROJECTS_CREATE_TEACHER, PROJECTS_CREATE_ROOM, PROJECTS_CREATE_EQUIPMENT, PROJECTS_CREATE_CATEGORY5, PROJECTS_CREATE_CATEGORY6, PROJECTS_CREATE_CATEGORY7, PROJECTS_CREATE_CATEGORY8};
    private final boolean global;
    private final String label;

    private Permission(String string, String string2, boolean bl) {
        super(string);
        indexByName.put(string, this);
        this.global = bl;
        this.label = string2;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public static Permission get(String string) {
        return (Permission)((Object)indexByName.get(string));
    }

    public static Permission[] getGlobalPermissions() {
        return GLOBAL_PERMISSIONS;
    }

    public static Permission[] getProjectPermissions() {
        return PROJECTS_PERMISSIONS;
    }

    public static synchronized void load() {
        ArrayList<Permission> arrayList = new ArrayList<Permission>();
        ArrayList<Permission> arrayList2 = new ArrayList<Permission>();
        ArrayList<Permission> arrayList3 = new ArrayList<Permission>();
        Element element = ConfigManager.getInstance().readXmlFile(FILENAME);
        Iterator iterator = element.children();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getString("name");
            String string2 = element2.getString("label");
            boolean bl = "global".equalsIgnoreCase(element2.getString("type"));
            if (null == Permission.get(string)) {
                arrayList3.add(new Permission(string, string2, bl));
            }
            if (bl) {
                arrayList.add(Permission.get(string));
                continue;
            }
            arrayList2.add(Permission.get(string));
        }
        DYNAMIC = new Permission[arrayList3.size()];
        arrayList3.toArray(DYNAMIC);
        GLOBAL_PERMISSIONS = new Permission[arrayList.size()];
        arrayList.toArray(GLOBAL_PERMISSIONS);
        PROJECTS_PERMISSIONS = new Permission[arrayList2.size()];
        arrayList2.toArray(PROJECTS_PERMISSIONS);
    }

    static {
        Permission.load();
    }
}

