/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.server;

import com.adesoft.cache.RemoteCache;
import com.adesoft.config.ConfigServer;
import com.adesoft.errors.AccesException;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.DatabaseNotValidException;
import com.adesoft.errors.EntityGroupError;
import com.adesoft.errors.InvalidLogin;
import com.adesoft.errors.PasswordDeactivatedException;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.errors.TooManyConnections;
import com.adesoft.info.InfoConnection;
import com.adesoft.info.InfoProject;
import com.adesoft.log.LogMode;
import com.adesoft.proxy.UsersProxy;
import com.adesoft.security.EncryptedPassword;
import com.adesoft.server.BackupManager;
import com.adesoft.server.Identifier;
import com.adesoft.server.Notifiable;
import com.adesoft.server.RemotePermissionManager;
import com.adesoft.spy.Control;
import com.adesoft.struct.EtEvent;
import com.adesoft.struct.Lockable;
import com.adesoft.struct.Project;
import com.adesoft.tokenparser.ParseTokenException;
import com.adesoft.workflow.WorkflowCenter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public interface Server
extends Remote,
ConfigServer,
RemotePermissionManager {
    public int copyProject(Identifier var1, int var2) throws RemoteException, ProjectNotFoundException, SQLException, AccesException;

    public int createProject(Identifier var1, String var2, Locale var3) throws Exception;

    public void deleteProject(Identifier var1, int var2) throws SQLException, AccesException, RemoteException;

    public void exportProjectLocal(Identifier var1, int var2, String var3, boolean var4, Date var5, boolean var6) throws IOException, AdeException, SQLException, RemoteException;

    public void exportProjectLocal(Identifier var1, int var2, String var3) throws IOException, AdeException, SQLException, RemoteException;

    public byte[] exportProjectRemote(Identifier var1, int var2) throws IOException, AdeException, SQLException, RemoteException;

    public byte[] exportProjectRemote(Identifier var1, int var2, boolean var3, Date var4, boolean var5) throws IOException, AdeException, SQLException, RemoteException;

    public Project getProject(Identifier var1, int var2, boolean var3) throws RemoteException, ProjectNotFoundException, AdeException;

    public InfoProject[] getProjectInfo(Identifier var1, boolean var2, boolean var3) throws RemoteException, SQLException, AdeException;

    public String getVersion() throws RemoteException;

    public String getVersionId() throws RemoteException;

    public int importFileLocal(Identifier var1, String var2, String var3) throws Exception;

    public int importFileLocal(Identifier var1, String var2) throws Exception;

    public int importFileRemote(Identifier var1, String var2, byte[] var3) throws Exception;

    public void killLock(Lockable var1) throws RemoteException;

    public void logOff(Identifier var1) throws RemoteException;

    public InfoConnection logOn(Notifiable var1, String var2, EncryptedPassword var3, String var4, InetAddress var5) throws RemoteException, InvalidLogin, TooManyConnections, SQLException, DatabaseNotValidException, AccesException, PasswordDeactivatedException;

    public InfoConnection logOn(Notifiable var1, String var2, String var3, InetAddress var4) throws RemoteException, InvalidLogin, TooManyConnections, PasswordDeactivatedException;

    public void ping() throws RemoteException;

    public byte[] trafficTest(int var1) throws RemoteException;

    public WorkflowCenter getWorkflowCenter() throws RemoteException;

    public void sendMail(String var1, String var2, String var3, String var4) throws RemoteException;

    public int getMaxConnections() throws RemoteException;

    public boolean ping(Identifier var1) throws RemoteException;

    public void sendMails(Identifier var1, int[] var2, EtEvent[] var3, boolean var4, TimeZone var5, Locale var6) throws RemoteException;

    public BackupManager getBackupManager() throws RemoteException;

    public boolean isProjectExists(int var1) throws RemoteException;

    public byte[] getPublicKey() throws RemoteException;

    public UsersProxy getUsersProxy() throws RemoteException;

    public RemoteCache getUsersCache(Identifier var1) throws RemoteException;

    public Identifier createId(String var1, EncryptedPassword var2) throws RemoteException, SQLException, PasswordDeactivatedException;

    public void kickUser(Identifier var1, int var2, boolean var3) throws RemoteException;

    public void shutdown(Identifier var1) throws RemoteException;

    public void unregister() throws RemoteException;

    public void sendServiceMessage(Identifier var1, String var2) throws RemoteException;

    public void register(Identifier var1, Control var2) throws RemoteException, InvalidLogin;

    public void setLogMode(Identifier var1, LogMode var2) throws RemoteException;

    public void importLDAPUsers(Identifier var1, int var2) throws AdeException, RemoteException, ParseTokenException, SQLException, ProjectNotFoundException;

    public void importLDAPParticipants(Identifier var1, int var2) throws AdeException, RemoteException, ProjectNotFoundException, ParseTokenException, EntityGroupError;

    public String getLDAPContent() throws AdeException, RemoteException, ProjectNotFoundException, ParseTokenException;

    public void importPACStudents(Identifier var1, int var2) throws AdeException, SQLException, RemoteException, ProjectNotFoundException, ParseTokenException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException;
}

