/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.config.ConfigManager;
import com.adesoft.server.Identifier;
import com.adesoft.server.Permission;
import com.adesoft.struct.Project;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.jdom.Element;

public abstract class AbstractProfile
implements Serializable {
    private static final String ATTR_MODULE = "module";
    private static final String ATTR_VISIBLE = "visible";
    private static final String ATTR_ENABLE = "enable";
    private String module = "";
    private String visible = "";
    private String enable = "";

    protected AbstractProfile(String string, String string2, String string3) {
        this.module = string;
        this.visible = string2;
        this.enable = string3;
    }

    protected AbstractProfile(Element element) {
        this.module = element.getString(ATTR_MODULE);
        this.visible = element.getString(ATTR_VISIBLE);
        this.enable = element.getString(ATTR_ENABLE);
    }

    protected String getModule() {
        return this.module;
    }

    protected String getVisible() {
        return this.visible;
    }

    protected String getEnable() {
        return this.enable;
    }

    public boolean isVisible(Identifier identifier, Project project) {
        try {
            String string;
            StringTokenizer stringTokenizer;
            if (0 != this.module.length()) {
                stringTokenizer = new StringTokenizer(this.module, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                    if (ConfigManager.getInstance().hasModule(string)) continue;
                    return false;
                }
            }
            if (0 != this.visible.length()) {
                stringTokenizer = new StringTokenizer(this.visible, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                    if ("true".equalsIgnoreCase(string)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(string)) {
                        return false;
                    }
                    Permission permission = Permission.get(string);
                    if (null == permission || !project.hasAccess(identifier, permission)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    public boolean isEnable(Identifier identifier, Project project) {
        try {
            if (0 != this.enable.length()) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.enable, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken().trim();
                    if ("true".equalsIgnoreCase(string)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(string)) {
                        return false;
                    }
                    Permission permission = Permission.get(string);
                    if (null == permission || !project.hasAccess(identifier, permission)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }
}

