/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.collections.MyHashTable;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public final class AccessLevel
implements Serializable,
Comparable {
    private static final long serialVersionUID = 520L;
    private static final MyHashTable levels = new MyHashTable();
    private static final Map levelsByName = new TreeMap();
    public static final AccessLevel NONE = new AccessLevel("NONE", 0);
    public static final AccessLevel READ = new AccessLevel("READ", 1);
    public static final AccessLevel USE = new AccessLevel("USE", 2);
    public static final AccessLevel RW = new AccessLevel("RW", 3);
    public static final AccessLevel WORKFLOW = new AccessLevel("WORKFLOW", 4);
    public static final int GRANT_NONE = -1;
    public static final int GRANT_ALL = 2;
    public static final int GRANT_OWNER = 3;
    public static final int GRANT_OWNER_GROUPS = 4;
    private final int level;

    private AccessLevel(String string, int n) {
        this.level = n;
        levels.put(n, (Object)this);
        levelsByName.put(string, this);
    }

    public int compareTo(Object object) {
        return this.level - ((AccessLevel)object).level;
    }

    public boolean equals(Object object) {
        if (object instanceof AccessLevel) {
            return this.level == ((AccessLevel)object).level;
        }
        return false;
    }

    public int hashCode() {
        return this.level;
    }

    public int getLevel() {
        return this.level;
    }

    public static AccessLevel getLevel(String string) {
        return (AccessLevel)levelsByName.get(string);
    }

    public static AccessLevel getLevel(int n) {
        return (AccessLevel)levels.get(n);
    }

    public boolean isMoreThanRead() {
        if (this.level != WORKFLOW.getLevel()) {
            return this.level > READ.getLevel();
        }
        return false;
    }

    public boolean isMoreThanUse() {
        if (this.level != WORKFLOW.getLevel()) {
            return this.level > USE.getLevel();
        }
        return false;
    }

    public boolean isMoreOrEquals(AccessLevel accessLevel) {
        if (this.level != WORKFLOW.getLevel()) {
            return this.level >= accessLevel.getLevel();
        }
        return false;
    }

    public static int getGrantType(String string) {
        if ("owner".equals(string)) {
            return 3;
        }
        if ("ownerGroups".equals(string)) {
            return 4;
        }
        return 2;
    }

    public static String getGrantType(int n) {
        if (n == 3) {
            return "owner";
        }
        if (n == 4) {
            return "ownerGroups";
        }
        return "all";
    }

    public String getKeyword() {
        switch (this.getLevel()) {
            case 1: {
                return "RightREAD";
            }
            case 2: {
                return "RightUSE";
            }
            case 3: {
                return "RightWRITE";
            }
            case 4: {
                return "ManagerWORKFLOW";
            }
        }
        return "RightNONE";
    }

    public String toString() {
        return this.getKeyword();
    }
}

