/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.config.ConfigManager;
import com.adesoft.struct.AccessLevel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;

public final class Action
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final String name;
    private AccessLevel level;
    private boolean canUseWhenGlobalLock;
    private boolean canUseWhenReadLock;
    private boolean init;
    private static final Map actionsXml = new TreeMap();
    public static final Action ACCESS = new Action("ACCESS");
    public static final Action EDIT = new Action("EDIT");
    public static final Action USE = new Action("USE");
    public static final Action WIDE_EDIT = new Action("WIDE_EDIT");
    public static final Action REMOVE = new Action("REMOVE");
    public static final Action COURSE_ADDFATHER = new Action("COURSE_ADDFATHER");
    public static final Action COURSE_ADDMEMBER = new Action("COURSE_ADDMEMBER");
    public static final Action COURSE_REMOVEFATHER = new Action("COURSE_REMOVEFATHER");
    public static final Action COURSE_REMOVEMEMBER = new Action("COURSE_REMOVEMEMBER");
    public static final Action COURSE_ASSOCIATE = new Action("COURSE_ASSOCIATE");
    public static final Action COURSE_ASSOCIATELINK = new Action("COURSE_ASSOCIATELINK");
    public static final Action COURSE_DELETE = new Action("COURSE_DELETE");
    public static final Action COURSE_REMOVE_PARTICIPANT = new Action("COURSE_REMOVE_PARTICIPANT");
    public static final Action COURSE_REMOVELINK = new Action("COURSE_REMOVELINK");
    public static final Action COURSE_EDIT = new Action("COURSE_EDIT");
    public static final Action COURSE_SETOTHERFIELD = new Action("COURSE_SETOTHERFIELD");
    public static final Action COURSE_SETACTIVE = new Action("COURSE_SETACTIVE");
    public static final Action COURSE_SETALIGNED = new Action("COURSE_SETALIGNED");
    public static final Action COURSE_SETSUCCESSIVE = new Action("COURSE_SETSUCCESSIVE");
    public static final Action COURSE_SETDURATION = new Action("COURSE_SETDURATION");
    public static final Action COURSE_SETGROUPED = new Action("COURSE_SETGROUPED");
    public static final Action COURSE_SETLOADFACTOR = new Action("COURSE_SETLOADFACTOR");
    public static final Action COURSE_SETNSD = new Action("COURSE_SETNSD");
    public static final Action COURSE_SETREPETITION = new Action("COURSE_SETREPETITION");
    public static final Action COURSE_SETSIZE = new Action("COURSE_SETSIZE");
    public static final Action COURSE_SETSUBJECT = new Action("COURSE_SETSUBJECT");
    public static final Action COURSE_SETSUBJECTCODE = new Action("COURSE_SETSUBJECTCODE");
    public static final Action COURSE_SETWEIGHT = new Action("COURSE_SETWEIGHT");
    public static final Action COURSE_SETCONTINUOUS = new Action("COURSE_SETCONTINUOUS");
    public static final Action COURSE_SETDEFAULTTF = new Action("COURSE_SETDEFAULTTF");
    public static final Action COURSE_EXTRACTION = new Action("COURSE_EXTRACTION");
    public static final Action EDIT_EVENT = new Action("EDIT_EVENT");
    public static final Action EDIT_INDEXED_NAME = new Action("EDIT_INDEXED_NAME");
    public static final Action EDIT_TF = new Action("EDIT_TF");
    public static final Action ENTITY_ADDFATHER = new Action("ENTITY_ADDFATHER");
    public static final Action ENTITY_ADDMEMBER = new Action("ENTITY_ADDMEMBER");
    public static final Action ENTITY_ADDSETMEMBER = new Action("ENTITY_ADDSETMEMBER");
    public static final Action ENTITY_ADDSETMEMBERSHIP = new Action("ENTITY_ADDSETMEMBERSHIP");
    public static final Action ENTITY_ASSOCIATECOURSE = new Action("ENTITY_ASSOCIATECOURSE");
    public static final Action ENTITY_DELETE = new Action("ENTITY_DELETE");
    public static final Action ENTITY_REMOVEFATHER = new Action("ENTITY_REMOVEFATHER");
    public static final Action ENTITY_REMOVEMEMBER = new Action("ENTITY_REMOVEMEMBER");
    public static final Action ENTITY_REMOVESETMEMBER = new Action("ENTITY_REMOVESETMEMBER");
    public static final Action ENTITY_REMOVESETMEMBERSHIP = new Action("ENTITY_REMOVESETMEMBERSHIP");
    public static final Action ENTITY_REMOVECOURSE = new Action("ENTITY_REMOVECOURSE");
    public static final Action ENTITY_REMOVECOURSEWORKFLOW = new Action("ENTITY_REMOVECOURSEWORKFLOW");
    public static final Action ENTITY_RESERVE = new Action("ENTITY_RESERVE");
    public static final Action ENTITY_SETCOLOR = new Action("ENTITY_SETCOLOR");
    public static final Action ENTITY_SETOTHERFIELD = new Action("ENTITY_SETOTHERFIELD");
    public static final Action ENTITY_SETCONSUMER = new Action("ENTITY_SETCONSUMER");
    public static final Action ENTITY_SETCOST = new Action("ENTITY_SETCOST");
    public static final Action ENTITY_SETSITE = new Action("ENTITY_SETSITE");
    public static final Action ENTITY_SETCOUNTER = new Action("ENTITY_SETCOUNTER");
    public static final Action ENTITY_SETCOUNTERMOVING = new Action("ENTITY_SETCOUNTER");
    public static final Action ENTITY_SETDEFAULTLUNCH = new Action("ENTITY_SETDEFAULTLUNCH");
    public static final Action ENTITY_SETDEFAULTTF = new Action("ENTITY_SETDEFAULTTF");
    public static final Action ENTITY_SETDISTRIBUTION = new Action("ENTITY_SETDISTRIBUTION");
    public static final Action ENTITY_SETEMAIL = new Action("ENTITY_SETEMAIL");
    public static final Action ENTITY_SETLUNCHDURATION = new Action("ENTITY_SETLUNCHDURATION");
    public static final Action ENTITY_SETNAME = new Action("ENTITY_SETNAME");
    public static final Action ENTITY_SETNB = new Action("ENTITY_SETNB");
    public static final Action ENTITY_SETQUALITY = new Action("ENTITY_SETQUALITY");
    public static final Action ENTITY_SETSIZE = new Action("ENTITY_SETSIZE");
    public static final Action ENTITY_SETTYPE = new Action("ENTITY_SETTYPE");
    public static final Action ENTITY_SETURL = new Action("ENTITY_SETURL");
    public static final Action ENTITY_SETUSECOUNTERS = new Action("ENTITY_SETUSECOUNTERS");
    public static final Action ENTITY_SETUSECOUNTERSMOVING = new Action("ENTITY_SETUSECOUNTERSMOVING");
    public static final Action ENTITY_UNSCHEDULE = new Action("ENTITY_UNSCHEDULE");
    public static final Action EVENT_ADD_PARTICIPANT = new Action("EVENT_ADD_PARTICIPANT");
    public static final Action EVENT_ADD_NOTE = new Action("EVENT_ADD_NOTE");
    public static final Action EVENT_DELETE = new Action("EVENT_DELETE");
    public static final Action EVENT_EDIT = new Action("EVENT_EDIT");
    public static final Action EVENT_LOCKPOSITION = new Action("EVENT_LOCKPOSITION");
    public static final Action EVENT_LOCKRESOURCES = new Action("EVENT_LOCKRESOURCES");
    public static final Action EVENT_LOCKUNACTIVEKEEPRESOURCES = new Action("EVENT_LOCKUNACTIVEKEEPRESOURCES");
    public static final Action EVENT_MOVE = new Action("EVENT_MOVE");
    public static final Action EVENT_UNSCHEDULE = new Action("EVENT_UNSCHEDULE");
    public static final Action EVENT_REMOVE_PARTICIPANT = new Action("EVENT_REMOVE_PARTICIPANT");
    public static final Action EVENT_SET_PARTICIPANTS = new Action("EVENT_SET_PARTICIPANTS");
    public static final Action EVENT_ACCEPTWORKFLOW = new Action("EVENT_ACCEPTWORKFLOW");
    public static final Action EVENT_REJECTWORKFLOW = new Action("EVENT_REJECTWORKFLOW");
    public static final Action LINK_ASSOCIATECOURSE = new Action("LINK_ASSOCIATECOURSE");
    public static final Action LINK_DELETE = new Action("LINK_DELETE");
    public static final Action LINK_EDIT = new Action("LINK_EDIT");
    public static final Action LINK_READ = new Action("LINK_READ");
    public static final Action LINK_REMOVECOURSE = new Action("LINK_REMOVECOURSE");
    public static final Action LINK_SETACTIVE = new Action("LINK_SETACTIVE");
    public static final Action LINK_SETOVERRIDABLE = new Action("LINK_SETOVERRIDABLE");
    public static final Action LINK_SETBETWEENCOURSE = new Action("LINK_SETBETWEENCOURSE");
    public static final Action LINK_SETBETWEENREP = new Action("LINK_SETBETWEENREP");
    public static final Action LINK_SETBETWEENREPNEXT = new Action("LINK_SETBETWEENREPNEXT");
    public static final Action LINK_SETBETWEENREPPRED = new Action("LINK_SETBETWEENREPPRED");
    public static final Action LINK_SETBETWEENSESS = new Action("LINK_SETBETWEENSESS");
    public static final Action LINK_SETBETWEENSESSNEXT = new Action("LINK_SETBETWEENSESSNEXT");
    public static final Action LINK_SETBETWEENSESSPRED = new Action("LINK_SETBETWEENSESSPRED");
    public static final Action LINK_SETCONTINUOUS = new Action("LINK_SETCONTINUOUS");
    public static final Action LINK_SETCOLOR = new Action("LINK_SETCOLOR");
    public static final Action LINK_SETLINKTYPE = new Action("LINK_SETLINKTYPE");
    public static final Action LINK_SETTYPE = new Action("LINK_SETTYPE");
    public static final Action PROJECT_DELETE = new Action("PROJECT_DELETE");
    public static final Action PROJECT_IMPORT_ENTITY = new Action("PROJECT_IMPORT_ENTITY");
    public static final Action PROJECT_SETCOSTWEIGHTS = new Action("PROJECT_SETCOSTWEIGHTS");
    public static final Action PROJECT_SETLUNCHDURATION = new Action("PROJECT_SETLUNCHDURATION");
    public static final Action PROJECT_SETNAME = new Action("PROJECT_SETNAME");
    public static final Action PROJECT_SETOPTIMIZING = new Action("PROJECT_SETOPTIMIZING");
    public static final Action PROJECT_SETVERSION = new Action("PROJECT_SETVERSION");
    public static final Action PROJECT_UPDATE_COUNTER = new Action("PROJECT_UPDATE_COUNTER");
    public static final Action PROJECT_UPDATE_COUNTERMOVING = new Action("PROJECT_UPDATE_COUNTERMOVING");
    public static final Action SETSECURITYINFO = new Action("SETSECURITYINFO");
    public static final Action TIMEFRAME_EDIT = new Action("TIMEFRAME_EDIT");
    public static final Action ENTITY_SEND_ENGINE = new Action("ENTITY_SEND_ENGINE");
    public static final Action COURSE_SEND_ENGINE = new Action("COURSE_SEND_ENGINE");
    public static final Action FOLDER_SEND_ENGINE = new Action("FOLDER_SEND_ENGINE");
    public static final Action COURSE_FROZEN_SEND_ENGINE = new Action("COURSE_FROZEN_SEND_ENGINE");
    public static final Action LINK_SEND_ENGINE = new Action("LINK_SEND_ENGINE");
    public static final Action FILTER_READ = new Action("FILTER_READ");
    public static final Action FILTER_DELETE = new Action("FILTER_DELETE");
    public static final Action FILTER_RENAME = new Action("FILTER_RENAME");
    public static final Action FILTER_SETSECURITYINFO = new Action("FILTER_SETSECURITYINFO");
    public static final Action FILTER_EDIT = new Action("FILTER_EDIT");
    public static final Action USER_SETSUBJECT = new Action("USER_SETSUBJECT");
    public static final Action WORKFLOW_DYNAMIC_LIST_ENTITIES = new Action("WORKFLOW_DYNAMIC_LIST_ENTITIES");
    public static final Action DYNAMICLIST_ASSOCIATECOURSE = new Action("DYNAMICLIST_ASSOCIATECOURSE");
    public static final Action WORKFLOW_INTERNAL_RESOURCE_CHECKING = new Action("WORKFLOW_INTERNAL_RESOURCE_CHECKING");
    public static final Action XFIELD_CHECKING = new Action("XFIELD_CHECKING");

    private Action(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        Map map = actionsXml;
        synchronized (map) {
            if (actionsXml.isEmpty()) {
                Element element = ConfigManager.getInstance().readXmlFile("Actions");
                Iterator iterator = element.children();
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    String string = element2.getString("name");
                    actionsXml.put(string, element2);
                }
            }
        }
        map = (Element)actionsXml.get(this.getName());
        if (null == map) {
            throw new RuntimeException("Invalid Actions.xml file for action: " + this.getName());
        }
        this.level = AccessLevel.getLevel(map.getString("level"));
        this.canUseWhenGlobalLock = this.level.isMoreThanRead();
        this.canUseWhenReadLock = map.getBoolean("noengine") ? this.level.isMoreThanRead() : this.level.isMoreThanUse();
        this.init = true;
    }

    public boolean canUseWhenGlobalLock() {
        if (!this.init) {
            this.init();
        }
        return this.canUseWhenGlobalLock;
    }

    public boolean canUseWhenReadLock() {
        if (!this.init) {
            this.init();
        }
        return this.canUseWhenReadLock;
    }

    public AccessLevel getLevel() {
        if (!this.init) {
            this.init();
        }
        return this.level;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Action) {
            return ((Action)object).getName().equals(this.getName());
        }
        return false;
    }

    public static Action getByName(String string) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = Action.class.getField(string);
        return (Action)field.get(null);
    }

    public static void main(String[] stringArray) {
        Field[] fieldArray = Action.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (field.getType() != Action.class) continue;
            System.out.println("\tpublic final static Action " + field.getName() + " = new Action (\"" + field.getName() + "\") ;");
        }
    }
}

