/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.struct.TabProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public final class CategoryProfile
implements Serializable {
    private static final long serialVersionUID = 520L;
    private boolean choosenAvailable = true;
    private boolean imposedAvailable = true;
    private boolean workflowAvailable = true;
    private boolean setMemberAvailable = true;
    private boolean setContainerAvailable = true;
    private boolean allowMultipleSelection = true;
    private int maxMembersLimit = -1;
    private List<String> checkConstraints;
    private boolean continuitySelected = false;
    private List tabs = new ArrayList();

    CategoryProfile() {
    }

    public void initWith(CategoryProfile categoryProfile) {
        this.choosenAvailable = categoryProfile.isChoosenAvailable();
        this.imposedAvailable = categoryProfile.isImposedAvailable();
        this.workflowAvailable = categoryProfile.isWorkflowAvailable();
        this.setMemberAvailable = categoryProfile.isSetMemberAvailable();
        this.setContainerAvailable = categoryProfile.isSetContainerAvailable();
        this.allowMultipleSelection = categoryProfile.allowMultipleSelection();
        this.maxMembersLimit = categoryProfile.getMaxMembersLimit();
        this.checkConstraints = categoryProfile.getCheckConstraints();
        this.continuitySelected = categoryProfile.isContinuitySelected();
        this.tabs = new ArrayList();
        Iterator iterator = categoryProfile.iterTabs();
        while (iterator.hasNext()) {
            TabProfile tabProfile = (TabProfile)iterator.next();
            this.tabs.add(tabProfile);
        }
    }

    protected void setChoosenValue(boolean bl) {
        this.choosenAvailable = bl;
    }

    protected void setContinuityValue(boolean bl) {
        this.continuitySelected = bl;
    }

    protected void setImposedValue(boolean bl) {
        this.imposedAvailable = bl;
    }

    protected void setWorkflowValue(boolean bl) {
        this.workflowAvailable = bl;
    }

    protected void setSetMemberValue(boolean bl) {
        this.setMemberAvailable = bl;
    }

    protected void setSetContainerValue(boolean bl) {
        this.setContainerAvailable = bl;
    }

    protected void setAllowMultipleSelection(boolean bl) {
        this.allowMultipleSelection = bl;
    }

    protected void setMaxMembersLimit(int n) {
        this.maxMembersLimit = n;
    }

    public void setCheckContraints(List<String> list) {
        this.checkConstraints = list;
    }

    protected void addTab(Element element) {
        TabProfile tabProfile = new TabProfile(element);
        this.addTab(tabProfile);
    }

    private void addTab(TabProfile tabProfile) {
        this.tabs.add(tabProfile);
    }

    public Iterator iterTabs() {
        return this.tabs.iterator();
    }

    public boolean isChoosenAvailable() {
        return this.choosenAvailable;
    }

    public boolean isContinuitySelected() {
        return this.continuitySelected;
    }

    public boolean isImposedAvailable() {
        return this.imposedAvailable;
    }

    public boolean isWorkflowAvailable() {
        return this.workflowAvailable;
    }

    public boolean isSetMemberAvailable() {
        return this.setMemberAvailable;
    }

    public boolean isSetContainerAvailable() {
        return this.setContainerAvailable;
    }

    public boolean allowMultipleSelection() {
        return this.allowMultipleSelection;
    }

    public int getMaxMembersLimit() {
        return this.maxMembersLimit;
    }

    public List<String> getCheckConstraints() {
        return this.checkConstraints;
    }

    protected TabProfile getTabById(String string) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabProfile tabProfile = (TabProfile)this.tabs.get(i);
            if (!string.equalsIgnoreCase(tabProfile.getId())) continue;
            return tabProfile;
        }
        return null;
    }

    public static CategoryProfile merge(ArrayList arrayList) {
        Object object;
        if (0 == arrayList.size()) {
            return null;
        }
        if (1 == arrayList.size()) {
            return (CategoryProfile)arrayList.get(0);
        }
        CategoryProfile categoryProfile = (CategoryProfile)arrayList.get(0);
        boolean bl = categoryProfile.isChoosenAvailable();
        boolean bl2 = categoryProfile.isContinuitySelected();
        boolean bl3 = categoryProfile.isImposedAvailable();
        boolean bl4 = categoryProfile.isWorkflowAvailable();
        boolean bl5 = categoryProfile.isSetMemberAvailable();
        boolean bl6 = categoryProfile.isSetContainerAvailable();
        boolean bl7 = categoryProfile.allowMultipleSelection();
        for (int i = 1; i < arrayList.size(); ++i) {
            object = (CategoryProfile)arrayList.get(i);
            bl &= ((CategoryProfile)object).isChoosenAvailable();
            bl2 &= ((CategoryProfile)object).isContinuitySelected();
            bl3 &= ((CategoryProfile)object).isImposedAvailable();
            bl4 &= ((CategoryProfile)object).isWorkflowAvailable();
            bl5 &= ((CategoryProfile)object).isSetMemberAvailable();
            bl6 &= ((CategoryProfile)object).isSetContainerAvailable();
            bl7 &= ((CategoryProfile)object).allowMultipleSelection();
        }
        CategoryProfile categoryProfile2 = new CategoryProfile();
        categoryProfile2.setChoosenValue(bl);
        categoryProfile2.setContinuityValue(bl2);
        categoryProfile2.setImposedValue(bl3);
        categoryProfile2.setWorkflowValue(bl4);
        categoryProfile2.setSetMemberValue(bl5);
        categoryProfile2.setSetContainerValue(bl6);
        categoryProfile2.setAllowMultipleSelection(bl7);
        object = categoryProfile.iterTabs();
        while (object.hasNext()) {
            boolean bl8 = true;
            TabProfile tabProfile = (TabProfile)object.next();
            ArrayList<TabProfile> arrayList2 = new ArrayList<TabProfile>();
            arrayList2.add(tabProfile);
            for (int i = 1; i < arrayList.size(); ++i) {
                CategoryProfile categoryProfile3 = (CategoryProfile)arrayList.get(i);
                TabProfile tabProfile2 = categoryProfile3.getTabById(tabProfile.getId());
                if (null == tabProfile2) {
                    bl8 = false;
                    break;
                }
                arrayList2.add(tabProfile2);
            }
            if (!bl8) continue;
            categoryProfile2.addTab(TabProfile.merge(arrayList2));
        }
        return categoryProfile2;
    }
}

