/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.config.ConfigManager;
import com.adesoft.log.Category;
import com.adesoft.properties.ServerProperty;
import com.adesoft.struct.CategoryProfile;
import com.adesoft.struct.TabProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public final class CategoryProfileManager
implements Serializable {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.CategoryProfileManager");
    private static final long serialVersionUID = 520L;
    private static final String XMLFILE = "Category";
    private static final String ROOT_CATEGORIES = "categories";
    private static final String ELT_CATEGORY = "category";
    private static final String ELT_PARTICIPANT = "participant";
    private static final String ELT_SET = "set";
    private static final String ELT_CHECK_CONSTRAINT = "checkConstraints";
    private static final String ELT_TABS = "tabs";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SAMEAS = "sameas";
    private static final String ATTR_IMPOSED = "imposed";
    private static final String ATTR_CHOOSEN = "choosen";
    private static final String ATTR_CONTINUITY = "continuity";
    private static final String ATTR_WORKFLOW = "workflow";
    private static final String ATTR_MEMBER = "member";
    private static final String ATTR_CONTAINER = "container";
    private static final String ATTR_ALLOW_MULTIPLE_SELECTION = "allowMultipleSelection";
    private static final String ATTR_MAX_MEMBERS_LIMIT = "maxMembersLimit";
    private static final String ATTR_TYPE_CONSTRAINT = "types";
    private CategoryProfile[] categoryArray = null;
    private HashMap<Integer, Integer> mapMaxMembersLimit;
    private HashMap<Integer, List<String>> mapCheckConstraints;

    public CategoryProfileManager() {
        try {
            this.parseElements(ConfigManager.getInstance().readXmlFile(XMLFILE));
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
    }

    private CategoryProfile getCategory(int n) {
        if (null == this.categoryArray) {
            this.categoryArray = new CategoryProfile[8];
        }
        if (null == this.categoryArray[n]) {
            this.categoryArray[n] = new CategoryProfile();
        }
        return this.categoryArray[n];
    }

    private void parseElements(Element element) {
        if (null != element && element.getName().equalsIgnoreCase(ROOT_CATEGORIES)) {
            for (Element element2 : element.getChildren(ELT_CATEGORY)) {
                CategoryProfile categoryProfile;
                int n = element2.getInt(ATTR_TYPE);
                int n2 = element2.getInt(ATTR_SAMEAS);
                if (-1 != n2) {
                    categoryProfile = this.getCategoryProfile(n);
                    categoryProfile.initWith(this.getCategoryProfile(n2));
                    continue;
                }
                categoryProfile = this.getCategoryProfile(n);
                Iterator iterator = element2.children();
                while (iterator.hasNext()) {
                    Element element3 = (Element)iterator.next();
                    if (element3.getName().equalsIgnoreCase(ELT_PARTICIPANT)) {
                        categoryProfile.setChoosenValue(element3.getBoolean(ATTR_CHOOSEN, true));
                        categoryProfile.setContinuityValue(element3.getBoolean(ATTR_CONTINUITY, false));
                        categoryProfile.setImposedValue(element3.getBoolean(ATTR_IMPOSED, true));
                        categoryProfile.setWorkflowValue(element3.getBoolean(ATTR_WORKFLOW, true));
                        continue;
                    }
                    if (element3.getName().equalsIgnoreCase(ELT_SET)) {
                        categoryProfile.setSetMemberValue(element3.getBoolean(ATTR_MEMBER, true));
                        categoryProfile.setSetContainerValue(element3.getBoolean(ATTR_CONTAINER, true));
                        categoryProfile.setAllowMultipleSelection(element3.getBoolean(ATTR_ALLOW_MULTIPLE_SELECTION, true));
                        categoryProfile.setMaxMembersLimit(element3.getInt(ATTR_MAX_MEMBERS_LIMIT, -1));
                        continue;
                    }
                    if (element3.getName().equalsIgnoreCase(ELT_CHECK_CONSTRAINT)) {
                        String string = element3.getString(ATTR_TYPE_CONSTRAINT);
                        Element element4 = string.split(",");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (Element element5 : element4) {
                            arrayList.add(element5.trim());
                        }
                        categoryProfile.setCheckContraints(arrayList);
                        continue;
                    }
                    if (!element3.getName().equalsIgnoreCase(ELT_TABS)) continue;
                    for (Element element4 : element3.getChildren()) {
                        categoryProfile.addTab(element4);
                    }
                }
            }
        }
    }

    public CategoryProfile getCategoryProfile(int n) {
        return this.getCategory(n - 1);
    }

    public CategoryProfile getCategoryProfile(int[] nArray) {
        ArrayList<CategoryProfile> arrayList = new ArrayList<CategoryProfile>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getCategory(nArray[i] - 1));
        }
        return CategoryProfile.merge(arrayList);
    }

    public TabProfile getTabProfile(int n, String string) {
        return this.getCategory(n - 1).getTabById(string);
    }

    public TabProfile getTabProfile(int[] nArray, String string) {
        ArrayList<TabProfile> arrayList = new ArrayList<TabProfile>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getCategory(nArray[i] - 1).getTabById(string));
        }
        return TabProfile.merge(arrayList);
    }

    public HashMap<Integer, Integer> getMaxMembersLimitByCategoryMap() {
        if (null == this.mapMaxMembersLimit) {
            this.mapMaxMembersLimit = new HashMap();
            boolean bl = true;
            int n = ConfigManager.getInstance().getIntProperty(ServerProperty.NB_CATEGORIES);
            for (int i = 1; i < n + 1; ++i) {
                int n2 = this.getCategoryProfile(i).getMaxMembersLimit();
                if (n2 != -1) {
                    bl = false;
                }
                this.mapMaxMembersLimit.put(i, n2);
            }
            if (bl) {
                this.mapMaxMembersLimit = null;
            }
        }
        return this.mapMaxMembersLimit;
    }

    public HashMap<Integer, List<String>> getMapCheckConstraints() {
        if (null == this.mapCheckConstraints) {
            this.mapCheckConstraints = new HashMap();
            int n = ConfigManager.getInstance().getIntProperty(ServerProperty.NB_CATEGORIES);
            for (int i = 1; i < n + 1; ++i) {
                List<String> list = this.getCategoryProfile(i).getCheckConstraints();
                if (null == list) continue;
                this.mapCheckConstraints.put(i, list);
            }
        }
        return this.mapCheckConstraints;
    }
}

