/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.fields.Filterable;
import com.adesoft.filters.DFilter;
import com.adesoft.filters.Operators;
import java.awt.Color;
import java.io.Serializable;

public class ColoredString
implements Filterable,
Serializable {
    private static final long serialVersionUID = 520L;
    private Color color;
    private final String text;
    private boolean isItalic;
    private boolean isBold;

    public ColoredString(String string) {
        this.color = Color.black;
        this.text = string;
        this.isItalic = false;
        this.isBold = false;
    }

    public ColoredString(Color color, String string) {
        this.color = color;
        this.text = string;
        this.isItalic = false;
        this.isBold = false;
    }

    public ColoredString(Color color, String string, boolean bl, boolean bl2) {
        this.color = color;
        this.text = string;
        this.isItalic = bl;
        this.isBold = bl2;
    }

    public ColoredString(String string, boolean bl, boolean bl2) {
        this.color = Color.black;
        this.text = string;
        this.isItalic = bl;
        this.isBold = bl2;
    }

    public Color getColor() {
        return this.color;
    }

    public String getText() {
        return this.text;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isBold() {
        return this.isBold;
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public int compare(Object object) {
        return this.text.compareTo(((ColoredString)object).text);
    }

    public boolean equals(Object object) {
        if (object instanceof ColoredString) {
            ColoredString coloredString = (ColoredString)object;
            return this.color.equals(coloredString.color) && this.text.equals(coloredString.text);
        }
        return false;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setItalic(boolean bl) {
        this.isItalic = bl;
    }

    public void setBold(boolean bl) {
        this.isBold = bl;
    }

    @Override
    public boolean check(DFilter dFilter) {
        return Operators.test(dFilter.getOperator(), this.toString(), dFilter.getValue());
    }

    @Override
    public int intValue() {
        return Integer.parseInt(this.text);
    }

    @Override
    public long longValue() {
        return Long.parseLong(this.text);
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.text);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.text);
    }

    @Override
    public boolean booleanValue() {
        return "true".equalsIgnoreCase(this.text);
    }
}

