/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.log.Category;
import com.adesoft.rmi.GlobalRMIFlags;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public final class CompressedObject
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.CompressedObject");
    private final byte[] compressed;
    private volatile transient Object object;

    public CompressedObject(Object object) {
        if (!GlobalRMIFlags.getInstance().isLocalMode()) {
            byte[] byArray;
            try {
                byArray = CompressedObject.compress(object);
            }
            catch (Throwable throwable) {
                LOG.error((Object)throwable);
                byArray = null;
            }
            this.compressed = byArray;
        } else {
            this.compressed = null;
            this.object = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        if (null == this.object) {
            CompressedObject compressedObject = this;
            synchronized (compressedObject) {
                if (null == this.object) {
                    try {
                        this.object = CompressedObject.uncompress(this.compressed);
                    }
                    catch (Throwable throwable) {
                        LOG.error((Object)throwable);
                        return null;
                    }
                }
            }
        }
        return this.object;
    }

    private static byte[] compress(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MarshalOutputStream marshalOutputStream = new MarshalOutputStream(new GZIPOutputStream(byteArrayOutputStream));
        marshalOutputStream.writeObject(object);
        marshalOutputStream.flush();
        marshalOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static Object uncompress(byte[] byArray) throws IOException, ClassNotFoundException {
        return new MarshalInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))).readObject();
    }
}

