/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ConfigurationNode
implements Externalizable {
    private static final long serialVersionUID = 520L;
    private int oid;
    private boolean isSpecial;
    private boolean isGroup;
    private List children;

    public ConfigurationNode() {
    }

    public ConfigurationNode(int n) {
        this.oid = -1;
    }

    public ConfigurationNode(int n, int n2, boolean bl) {
        this.oid = n;
    }

    public void addChild(ConfigurationNode configurationNode) {
        this.children.add(configurationNode);
    }

    public Iterator children() {
        return this.children.iterator();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ConfigurationNode) {
            return ((ConfigurationNode)object).oid == this.oid;
        }
        return false;
    }

    public int getOid() {
        return this.oid;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public void setSpecial(boolean bl) {
        this.isSpecial = bl;
    }

    private ConfigurationNode getChildAt(int n) {
        return (ConfigurationNode)this.children.get(n);
    }

    public int getChildCount() {
        return null == this.children ? 0 : this.children.size();
    }

    public boolean isAGroup() {
        return this.isGroup;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.oid = objectInput.readInt();
        this.isSpecial = objectInput.readBoolean();
        int n = objectInput.readInt();
        boolean bl = this.isGroup = n >= 0;
        if (this.isGroup) {
            this.children = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                ConfigurationNode configurationNode = new ConfigurationNode();
                configurationNode.readExternal(objectInput);
                this.children.add(configurationNode);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.oid);
        objectOutput.writeBoolean(this.isSpecial);
        if (!this.isGroup) {
            objectOutput.writeInt(-1);
        } else {
            int n = this.getChildCount();
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).writeExternal(objectOutput);
            }
        }
    }
}

