/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.collections.Entry;
import com.adesoft.collections.MyHashTable;
import java.io.Serializable;
import java.util.Iterator;
import org.jdom.Element;

public final class CostWeights
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final MyHashTable weights;
    private double weightMovingSite;
    private boolean web;

    public CostWeights() {
        this.weights = new MyHashTable();
        this.weightMovingSite = 0.0;
        this.web = false;
    }

    public CostWeights(boolean bl) {
        this.weights = new MyHashTable();
        this.weightMovingSite = 0.0;
        this.web = bl;
    }

    public CostWeights(MyHashTable myHashTable, double d) {
        this.weights = myHashTable;
        this.weightMovingSite = d;
    }

    public void clear() {
        this.weights.clear();
        this.weightMovingSite = 0.0;
    }

    public double getWeight(int n) {
        Double d;
        if (this.web) {
            return 1.0;
        }
        if (null != this.weights && null != (d = (Double)this.weights.get(n))) {
            return d;
        }
        return 0.0;
    }

    public void setWeight(int n, double d) {
        this.weights.put(n, (Object)new Double(d));
    }

    public void setValues(MyHashTable myHashTable, double d) {
        this.setValues(myHashTable);
        this.weightMovingSite = d;
    }

    public void setValues(MyHashTable myHashTable) {
        this.weights.clear();
        Iterator iterator = myHashTable.entries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            int n = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Double) {
                this.weights.put(n, object);
                continue;
            }
            if (!(object instanceof Integer)) continue;
            double d = (double)((Integer)object).intValue() / 100.0;
            this.weights.put(n, (Object)new Double(d));
        }
    }

    public Element getXml() {
        Entry entry;
        Element element = new Element("weights");
        Iterator iterator = this.weights.entries();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            int n = entry.getKey();
            Double d = (Double)entry.getValue();
            Element element2 = new Element("weight");
            element2.addAttribute("id", n);
            element2.addAttribute("value", d.doubleValue());
            element.addChild(element2);
        }
        entry = new Element("weightMovingSite");
        entry.addAttribute("value", this.weightMovingSite);
        element.addChild((Element)entry);
        return element;
    }

    public double getWeightMovingSite() {
        return this.weightMovingSite;
    }

    public void setWeightMovingSite(double d) {
        this.weightMovingSite = d;
    }

    public MyHashTable getWeightsValues() {
        return this.weights;
    }
}

