/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.collections.IntDoubleTable;
import com.adesoft.log.Category;
import com.adesoft.struct.CalendarDate;
import java.io.Serializable;

public final class CountersManager
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.CountersManager");
    public static final int DAY = 1;
    public static final int WEEK = 2;
    public static final int MONTH = 4;
    public static final int YEAR = 8;
    private double _aMaxPerDay;
    private double _aMaxPerWeek;
    private double _aMaxPerMonth;
    private double _aMaxPerYear;
    private IntDoubleTable _aCountersUsedMapDay;
    private IntDoubleTable _aCountersUsedMapWeek;
    private IntDoubleTable _aCountersUsedMapMonth;
    private IntDoubleTable _aCountersUsedMapYear;
    private IntDoubleTable _aNbEntitiesMapDay;
    private IntDoubleTable _aNbEntitiesMapWeek;
    private IntDoubleTable _aNbEntitiesMapMonth;
    private IntDoubleTable _aNbEntitiesMapYear;
    private IntDoubleTable _aDurationMapDay;
    private IntDoubleTable _aDurationMapWeek;
    private IntDoubleTable _aDurationMapMonth;
    private IntDoubleTable _aDurationMapYear;
    private boolean _bIsUseCounters = true;

    public void addToDuration(CalendarDate calendarDate, double d) {
        this.addToDurationPerDay(calendarDate.getDay(), d);
        this.addToDurationPerWeek(calendarDate.getWeek(), d);
        this.addToDurationPerMonth(calendarDate.getMonth(), d);
        this.addToDurationPerYear(calendarDate.getYear(), d);
    }

    private double addToDurationPerDay(int n, double d) {
        double d2 = this.getDurationDayTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getDurationDayTable().put(n, d3);
        return d3;
    }

    private double addToDurationPerMonth(int n, double d) {
        double d2 = this.getDurationMonthTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getDurationMonthTable().put(n, d3);
        return d3;
    }

    private double addToDurationPerWeek(int n, double d) {
        double d2 = this.getDurationWeekTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getDurationWeekTable().put(n, d3);
        return d3;
    }

    private double addToDurationPerYear(int n, double d) {
        double d2 = this.getDurationYearTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getDurationYearTable().put(n, d3);
        return d3;
    }

    public void addToNbEntities(CalendarDate calendarDate, double d) {
        this.addToNbEntitiesPerDay(calendarDate.getDay(), d);
        this.addToNbEntitiesPerWeek(calendarDate.getWeek(), d);
        this.addToNbEntitiesPerMonth(calendarDate.getMonth(), d);
        this.addToNbEntitiesPerYear(calendarDate.getYear(), d);
    }

    private double addToNbEntitiesPerDay(int n, double d) {
        double d2 = this.getNbEntitiesDayTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getNbEntitiesDayTable().put(n, d3);
        return d3;
    }

    private double addToNbEntitiesPerMonth(int n, double d) {
        double d2 = this.getNbEntitiesMonthTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getNbEntitiesMonthTable().put(n, d3);
        return d3;
    }

    private double addToNbEntitiesPerWeek(int n, double d) {
        double d2 = this.getNbEntitiesWeekTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getNbEntitiesWeekTable().put(n, d3);
        return d3;
    }

    private double addToNbEntitiesPerYear(int n, double d) {
        double d2 = this.getNbEntitiesYearTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getNbEntitiesYearTable().put(n, d3);
        return d3;
    }

    public void addToCountersUsed(CalendarDate calendarDate, double d) {
        this.addToCounterUsedPerDay(calendarDate.getDay(), d);
        this.addToCounterUsedPerWeek(calendarDate.getWeek(), d);
        this.addToCounterUsedPerMonth(calendarDate.getMonth(), d);
        this.addToCounterUsedPerYear(calendarDate.getYear(), d);
    }

    private double addToCounterUsedPerDay(int n, double d) {
        double d2 = this.getUsedDayTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getUsedDayTable().put(n, d3);
        return d3;
    }

    private double addToCounterUsedPerMonth(int n, double d) {
        double d2 = this.getUsedMonthTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getUsedMonthTable().put(n, d3);
        return d3;
    }

    private double addToCounterUsedPerWeek(int n, double d) {
        double d2 = this.getUsedWeekTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getUsedWeekTable().put(n, d3);
        return d3;
    }

    private double addToCounterUsedPerYear(int n, double d) {
        double d2 = this.getUsedYearTable().get(n);
        double d3 = d;
        if (d2 > 0.0) {
            d3 += d2;
        }
        this.getUsedYearTable().put(n, d3);
        return d3;
    }

    public void dump() {
        if (this.isUseCounters()) {
            LOG.debug((Object)(" -Max Day   : " + this._aMaxPerDay));
            LOG.debug((Object)(" -Max Week  : " + this._aMaxPerWeek));
            LOG.debug((Object)(" -Max Month : " + this._aMaxPerMonth));
            LOG.debug((Object)(" -Max Year  : " + this._aMaxPerYear));
            LOG.debug((Object)" ");
            this.dump(this._aCountersUsedMapDay, " -Day Counters  :");
            this.dump(this._aCountersUsedMapWeek, " -Week Counters  :");
            this.dump(this._aCountersUsedMapMonth, " -Month Counters :");
            this.dump(this._aCountersUsedMapYear, " -Year Counters  :");
            LOG.debug((Object)" ");
            this.dump(this._aNbEntitiesMapDay, " -Day NbEntities   :");
            this.dump(this._aNbEntitiesMapWeek, " -Week NbEntities  :");
            this.dump(this._aNbEntitiesMapMonth, " -Month NbEntities :");
            this.dump(this._aNbEntitiesMapYear, " -Year NbEntities  :");
            LOG.debug((Object)" ");
            this.dump(this._aDurationMapDay, " -Day Duration   :");
            this.dump(this._aDurationMapWeek, " -Week Duration  :");
            this.dump(this._aDurationMapMonth, " -Month Duration :");
            this.dump(this._aDurationMapYear, " -Year Duration  :");
            LOG.debug((Object)" ");
        }
    }

    private void dump(IntDoubleTable intDoubleTable, String string) {
        if (null != intDoubleTable) {
            int[] nArray = intDoubleTable.getKeys();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                double d = intDoubleTable.get(n);
                LOG.debug((Object)(string + "  [" + n + "] : " + d));
            }
        }
    }

    public double getCounterFreePerDay(int n) {
        return this.getCounterMaxPerDay() - this.getUsedDayTable().get(n);
    }

    public double getCounterFreePerMonth(int n) {
        return this.getCounterMaxPerMonth() - this.getUsedMonthTable().get(n);
    }

    public double getCounterFreePerWeek(int n) {
        return this.getCounterMaxPerWeek() - this.getUsedWeekTable().get(n);
    }

    public double getCounterFreePerYear(int n) {
        return this.getCounterMaxPerYear() - this.getUsedYearTable().get(n);
    }

    public double getCounterMaxPerDay() {
        return this._aMaxPerDay;
    }

    public double getCounterMaxPerMonth() {
        return this._aMaxPerMonth;
    }

    public double getCounterMaxPerWeek() {
        return this._aMaxPerWeek;
    }

    public double getCounterMaxPerYear() {
        return this._aMaxPerYear;
    }

    public double getDurationPerDay(int n) {
        return this.getDurationDayTable().get(n);
    }

    public double getDurationPerMonth(int n) {
        return this.getDurationMonthTable().get(n);
    }

    public double getDurationPerWeek(int n) {
        return this.getDurationWeekTable().get(n);
    }

    public double getDurationPerYear(int n) {
        return this.getDurationYearTable().get(n);
    }

    public double getNbEntitiesPerDay(int n) {
        return this.getNbEntitiesDayTable().get(n);
    }

    public double getNbEntitiesPerMonth(int n) {
        return this.getNbEntitiesMonthTable().get(n);
    }

    public double getNbEntitiesPerWeek(int n) {
        return this.getNbEntitiesWeekTable().get(n);
    }

    public double getNbEntitiesPerYear(int n) {
        return this.getNbEntitiesYearTable().get(n);
    }

    public double getCounterUsedPerDay(int n) {
        return this.getUsedDayTable().get(n);
    }

    public double getCounterUsedPerMonth(int n) {
        return this.getUsedMonthTable().get(n);
    }

    public double getCounterUsedPerWeek(int n) {
        return this.getUsedWeekTable().get(n);
    }

    public double getCounterUsedPerYear(int n) {
        return this.getUsedYearTable().get(n);
    }

    public double getMaxCounterFor(int n) {
        IntDoubleTable intDoubleTable = null;
        switch (n) {
            case 1: {
                intDoubleTable = this.getUsedDayTable();
                break;
            }
            case 2: {
                intDoubleTable = this.getUsedWeekTable();
                break;
            }
            case 4: {
                intDoubleTable = this.getUsedMonthTable();
                break;
            }
            case 8: {
                intDoubleTable = this.getUsedYearTable();
            }
        }
        double d = 0.0;
        if (null != intDoubleTable && intDoubleTable.size() > 0) {
            int[] nArray = intDoubleTable.getKeys();
            for (int i = 0; i < nArray.length; ++i) {
                double d2 = intDoubleTable.get(nArray[i]);
                if (!(d2 > 0.0)) continue;
                d = Math.max(d, d2);
            }
        }
        return d;
    }

    public IntDoubleTable getDurationDayTable() {
        if (null == this._aDurationMapDay) {
            this._aDurationMapDay = new IntDoubleTable();
        }
        return this._aDurationMapDay;
    }

    public IntDoubleTable getDurationMonthTable() {
        if (null == this._aDurationMapMonth) {
            this._aDurationMapMonth = new IntDoubleTable();
        }
        return this._aDurationMapMonth;
    }

    public IntDoubleTable getDurationWeekTable() {
        if (null == this._aDurationMapWeek) {
            this._aDurationMapWeek = new IntDoubleTable();
        }
        return this._aDurationMapWeek;
    }

    public IntDoubleTable getDurationYearTable() {
        if (null == this._aDurationMapYear) {
            this._aDurationMapYear = new IntDoubleTable();
        }
        return this._aDurationMapYear;
    }

    public IntDoubleTable getNbEntitiesDayTable() {
        if (null == this._aNbEntitiesMapDay) {
            this._aNbEntitiesMapDay = new IntDoubleTable();
        }
        return this._aNbEntitiesMapDay;
    }

    public IntDoubleTable getNbEntitiesMonthTable() {
        if (null == this._aNbEntitiesMapMonth) {
            this._aNbEntitiesMapMonth = new IntDoubleTable();
        }
        return this._aNbEntitiesMapMonth;
    }

    public IntDoubleTable getNbEntitiesWeekTable() {
        if (null == this._aNbEntitiesMapWeek) {
            this._aNbEntitiesMapWeek = new IntDoubleTable();
        }
        return this._aNbEntitiesMapWeek;
    }

    public IntDoubleTable getNbEntitiesYearTable() {
        if (null == this._aNbEntitiesMapYear) {
            this._aNbEntitiesMapYear = new IntDoubleTable();
        }
        return this._aNbEntitiesMapYear;
    }

    public IntDoubleTable getUsedDayTable() {
        if (null == this._aCountersUsedMapDay) {
            this._aCountersUsedMapDay = new IntDoubleTable();
        }
        return this._aCountersUsedMapDay;
    }

    public IntDoubleTable getUsedMonthTable() {
        if (null == this._aCountersUsedMapMonth) {
            this._aCountersUsedMapMonth = new IntDoubleTable();
        }
        return this._aCountersUsedMapMonth;
    }

    public IntDoubleTable getUsedWeekTable() {
        if (null == this._aCountersUsedMapWeek) {
            this._aCountersUsedMapWeek = new IntDoubleTable();
        }
        return this._aCountersUsedMapWeek;
    }

    public IntDoubleTable getUsedYearTable() {
        if (null == this._aCountersUsedMapYear) {
            this._aCountersUsedMapYear = new IntDoubleTable();
        }
        return this._aCountersUsedMapYear;
    }

    public boolean isUseCounters() {
        return this._bIsUseCounters;
    }

    public void setCounterMaxPerDay(double d) {
        this._aMaxPerDay = d;
    }

    public void setCounterMaxPerMonth(double d) {
        this._aMaxPerMonth = d;
    }

    public void setCounterMaxPerWeek(double d) {
        this._aMaxPerWeek = d;
    }

    public void setCounterMaxPerYear(double d) {
        this._aMaxPerYear = d;
    }

    public void setCounterUsedPerDay(int n, double d) {
        this.getUsedDayTable().put(n, d);
    }

    public void setCounterUsedPerMonth(int n, double d) {
        this.getUsedMonthTable().put(n, d);
    }

    public void setCounterUsedPerWeek(int n, double d) {
        this.getUsedWeekTable().put(n, d);
    }

    public void setCounterUsedPerYear(int n, double d) {
        this.getUsedYearTable().put(n, d);
    }

    public void setUseCounters(boolean bl) {
        this._bIsUseCounters = bl;
    }
}

