/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.struct.CalendarDate;
import com.adesoft.struct.EtEvent;
import com.adesoft.struct.ResourceAffect;
import java.io.Serializable;
import java.util.Comparator;

public final class DateQuantity
implements Serializable {
    private static final long serialVersionUID = 520L;
    private ResourceAffect[] resourceAffect;
    private boolean isResourcesLocked;
    private boolean isUnactiveKeepResourcesLocked;
    private boolean isBooked;
    private String date;
    private EtEvent event;
    private int absoluteDay;
    private int startSlot;
    private int durationInSlots;
    private int durationInMinutes;
    private CalendarDate calendarDate;

    public DateQuantity(EtEvent etEvent, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4, ResourceAffect[] resourceAffectArray, CalendarDate calendarDate, String string) {
        this.resourceAffect = resourceAffectArray;
        this.date = string;
        this.event = etEvent;
        this.isResourcesLocked = bl;
        this.isUnactiveKeepResourcesLocked = bl2;
        this.isBooked = bl3;
        this.absoluteDay = n;
        this.startSlot = n2;
        this.durationInSlots = n3;
        this.durationInMinutes = n4;
        this.calendarDate = calendarDate;
    }

    public static Comparator getComparator() {
        Comparator comparator = null;
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                DateQuantity dateQuantity = (DateQuantity)object;
                DateQuantity dateQuantity2 = (DateQuantity)object2;
                int n = dateQuantity.getAbsoluteDay() - dateQuantity2.getAbsoluteDay();
                if (0 == n) {
                    n = dateQuantity.getStartSlot() - dateQuantity2.getStartSlot();
                }
                return n;
            }
        };
        return comparator;
    }

    public int getAbsoluteDay() {
        return this.absoluteDay;
    }

    public final CalendarDate getCalendarDate() {
        return this.calendarDate;
    }

    public String getDate() {
        return this.date;
    }

    public int getDuration() {
        return this.durationInSlots;
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public EtEvent getEvent() {
        return this.event;
    }

    public ResourceAffect[] getResourceAffect() {
        return this.resourceAffect;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public final int getWeek() {
        return this.getCalendarDate().getWeek();
    }

    public void setResourceAffect(ResourceAffect[] resourceAffectArray) {
        this.resourceAffect = resourceAffectArray;
    }

    public boolean isResourcesLocked() {
        return this.isResourcesLocked;
    }

    public boolean isUnactiveKeepResourcesLocked() {
        return this.isUnactiveKeepResourcesLocked;
    }

    public boolean isBooked() {
        return this.isBooked;
    }
}

