/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EntityNode
implements Externalizable {
    private static final long serialVersionUID = 520L;
    private int oid;
    private boolean isGroup;
    private boolean isSpecial;
    private List children;

    public EntityNode() {
    }

    public EntityNode(int n) {
        this.oid = -1;
        this.isGroup = true;
        this.children = new ArrayList(n);
    }

    public EntityNode(int n, int n2, boolean bl) {
        this.oid = n;
        this.isGroup = bl;
        this.children = new ArrayList(n2);
    }

    public void addChild(EntityNode entityNode) {
        this.children.add(entityNode);
    }

    public Iterator children() {
        return this.children.iterator();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EntityNode) {
            return ((EntityNode)object).oid == this.oid;
        }
        return false;
    }

    private EntityNode getChildAt(int n) {
        return (EntityNode)this.children.get(n);
    }

    public int getChildCount() {
        return null == this.children ? 0 : this.children.size();
    }

    public int getOid() {
        return this.oid;
    }

    public boolean isAGroup() {
        return this.isGroup;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public void setSpecial(boolean bl) {
        this.isSpecial = bl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.oid = objectInput.readInt();
        this.isSpecial = objectInput.readBoolean();
        int n = objectInput.readInt();
        boolean bl = this.isGroup = n >= 0;
        if (this.isGroup) {
            this.children = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                EntityNode entityNode = new EntityNode();
                entityNode.readExternal(objectInput);
                this.children.add(entityNode);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.oid);
        objectOutput.writeBoolean(this.isSpecial);
        if (!this.isGroup) {
            objectOutput.writeInt(-1);
        } else {
            int n = this.getChildCount();
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).writeExternal(objectOutput);
            }
        }
    }
}

