/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.config.ConfigManager;
import com.adesoft.struct.Field;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.jdom.Element;

public abstract class LogDataParser {
    private HashMap<String, String> categoryKeywords;
    private HashMap<String, String> apiFields;
    private HashMap<String, ArrayList<String>> activityVisibleFiledsAndApi;
    private HashMap<String, HashMap<String, ArrayList<String>>> resourceVisibleFiledsAndApi;

    public String getDataEvent(Element element, Date date, int n, boolean bl) throws RemoteException {
        int[] nArray;
        if (null == element) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append(this.get("LabelName"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("name"));
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("LabelId"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("id"));
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("LabelCourseIdFilter"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("activityId"));
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("column.Session"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("session"));
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("column.Repetition"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("repetition"));
            stringBuffer.append("<br>");
        }
        if (n != 16) {
            int n2 = element.getInt("week");
            int n3 = element.getInt("day");
            int n4 = element.getInt("slot");
            Date date2 = this.getDate(n2, n3, n4);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.get("DatePattern") + " " + this.get("HourPattern"));
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            stringBuffer.append("Date");
            stringBuffer.append(" : ");
            stringBuffer.append(simpleDateFormat.format(date2));
            stringBuffer.append("<br>");
        }
        if (!bl) {
            stringBuffer.append(this.get("LabelDuration"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("duration"));
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("column.InfoEvent"));
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString("note"));
            stringBuffer.append("<br>");
            if (element.getBoolean("isLockPosition")) {
                stringBuffer.append(this.get("column.PositionLocked"));
                stringBuffer.append("<br>");
            }
            if (element.getBoolean("isLockResources")) {
                stringBuffer.append(this.get("column.ResourcesLocked"));
                stringBuffer.append("<br>");
            }
            if (element.getBoolean("isSoftKeepResources")) {
                stringBuffer.append(this.get("column.UnactiveKeepResourcesLocked"));
                stringBuffer.append("<br>");
            }
        }
        if (null != element.getChild("resources")) {
            stringBuffer.append("<br><b>");
            stringBuffer.append(this.get("type.Participants"));
            stringBuffer.append("</b><br>");
            for (Element element2 : element.getChild("resources").getChildrenArray()) {
                int n2 = element2.getInt("id");
                nArray = this.checkLoggedResource(n2, date);
                if (nArray[0] == 0) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                    continue;
                }
                if (nArray[0] == 2) continue;
                if (nArray[0] == 0) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(element2.getString("quantity"));
                    stringBuffer.append(" ");
                    stringBuffer.append(this.getLink(nArray[1], element2.getString("name")));
                    if (nArray[0] == 0) {
                        stringBuffer.append(" (");
                        stringBuffer.append(this.get("LogDestroyed"));
                        stringBuffer.append(")");
                    }
                }
                stringBuffer.append("<br>");
            }
        }
        if (null != element.getChild("eventParticipants")) {
            stringBuffer.append("<b>");
            stringBuffer.append(this.get("type.Participants"));
            stringBuffer.append("</b><br>");
            for (Element element3 : element.getChild("eventParticipants").getChildrenArray()) {
                int n3 = element3.getInt("id");
                nArray = this.checkLoggedResource(n3, date);
                if (nArray[0] == 0) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                    continue;
                }
                if (nArray[0] == 2) continue;
                if (nArray[0] == 0) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(element3.getString("quantity"));
                    stringBuffer.append(" ");
                    stringBuffer.append(this.getLink(nArray[1], element3.getString("name")));
                    if (nArray[0] == 0) {
                        stringBuffer.append(" (");
                        stringBuffer.append(this.get("LogDestroyed"));
                        stringBuffer.append(")");
                    }
                }
                stringBuffer.append("<br>");
            }
        }
        return stringBuffer.toString();
    }

    public String getDataLink(Element element) {
        Element[] elementArray;
        if (null == element) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.get("LabelName"));
        stringBuffer.append(" : ");
        stringBuffer.append(element.getString("name"));
        stringBuffer.append("<br>");
        stringBuffer.append(this.get("LabelLinkType"));
        stringBuffer.append(" : ");
        String string = element.getString("type");
        stringBuffer.append(this.getKeyword(string));
        stringBuffer.append("<br>");
        if (element.getBoolean("isActive")) {
            stringBuffer.append(this.get("LabelActive"));
        } else {
            stringBuffer.append(this.get("LabelUnactive"));
        }
        stringBuffer.append("<br>");
        stringBuffer.append(this.get("LabelApplyLink"));
        stringBuffer.append(" : ");
        stringBuffer.append(this.getKeyword(element.getString("between")));
        if (element.getBoolean("isContinuous")) {
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("CheckContinuous"));
        }
        this.writeProfile(stringBuffer, element);
        if (string.equals("sequence")) {
            elementArray = element.getChild("sequence");
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("LabelSequenceDescribe"));
            stringBuffer.append(" ");
            stringBuffer.append(this.getKeyword(elementArray.getString("type")));
            stringBuffer.append(" ");
            stringBuffer.append(this.get("LabelOthers"));
            stringBuffer.append(" ");
            stringBuffer.append(this.get("LabelAtLeast"));
            stringBuffer.append(" ");
            stringBuffer.append(elementArray.getString("atLeast"));
            stringBuffer.append(" ");
            stringBuffer.append(this.getKeyword(elementArray.getString("atLeastUnit")));
            stringBuffer.append(", ");
            stringBuffer.append(this.get("LabelAtMost"));
            stringBuffer.append(" ");
            stringBuffer.append(elementArray.getString("atMost"));
            stringBuffer.append(" ");
            stringBuffer.append(this.getKeyword(elementArray.getString("atMostUnit")));
            stringBuffer.append("<br>");
            if (elementArray.getBoolean("countVacationDays")) {
                stringBuffer.append(this.get("CountVacationDays"));
                stringBuffer.append("<br>");
            }
            if (elementArray.getBoolean("countVacationSlots")) {
                stringBuffer.append(this.get("CountVacationSlots"));
                stringBuffer.append("<br>");
            }
            if (!elementArray.getBoolean("discrete")) {
                stringBuffer.append(this.get("Timeline"));
                stringBuffer.append("<br>");
            }
        } else if (string.equals("successive")) {
            elementArray = element.getChild("successive");
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("LabelConsecutiveDescribe"));
            stringBuffer.append(" ");
            stringBuffer.append(elementArray.getString("gap"));
            stringBuffer.append(" ");
            stringBuffer.append(this.getKeyword(elementArray.getString("unit")));
            stringBuffer.append(" ");
            stringBuffer.append(this.get("LabelCountFrom"));
            stringBuffer.append(" ");
            stringBuffer.append(this.getKeyword(elementArray.getString("mode")));
            stringBuffer.append("<br>");
            if (elementArray.getBoolean("countVacationDays")) {
                stringBuffer.append(this.get("CountVacationDays"));
                stringBuffer.append("<br>");
            }
            if (elementArray.getBoolean("countVacationSlots")) {
                stringBuffer.append(this.get("CountVacationSlots"));
                stringBuffer.append("<br>");
            }
            if (elementArray.getBoolean("transfertLag")) {
                stringBuffer.append(this.get("TransfertLag"));
                stringBuffer.append("<br>");
            }
        } else if (string.equals("notSameDay")) {
            elementArray = element.getChild("notSameDay");
            stringBuffer.append("<br>");
            stringBuffer.append(this.getNsdKeyword(elementArray.getString("mode"), elementArray.getString("unit")));
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<br><b>");
        stringBuffer.append(this.get("type.Courses"));
        stringBuffer.append("</b><br>");
        for (Element element2 : element.getChild("activities").getChildrenArray()) {
            stringBuffer.append(element2.getString("name"));
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    private String getNsdKeyword(String string, String string2) {
        if (string.equals("same")) {
            if (string2.equals("slot")) {
                return this.get("radio.NsdSameSlot");
            }
            if (string2.equals("day")) {
                return this.get("radio.NsdSameDay");
            }
            if (string2.equals("week")) {
                return this.get("radio.NsdSameWeek");
            }
            if (string2.equals("time")) {
                return this.get("radio.NsdSameTime");
            }
            if (string2.equals("weekDay")) {
                return this.get("radio.NsdSameWeekDay");
            }
        } else if (string.equals("notSame")) {
            if (string2.equals("slot")) {
                return this.get("radio.NsdDifferentSlot");
            }
            if (string2.equals("day")) {
                return this.get("radio.NsdDifferentDay");
            }
            if (string2.equals("week")) {
                return this.get("radio.NsdDifferentWeek");
            }
            if (string2.equals("time")) {
                return this.get("radio.NsdDifferentTime");
            }
            if (string2.equals("weekDay")) {
                return this.get("radio.NsdDifferentWeekDay");
            }
        }
        return "";
    }

    private String getKeyword(String string) {
        if (string.equals("successive")) {
            return this.get("tip.CreateConsecutive");
        }
        if (string.equals("sequence")) {
            return this.get("tip.CreateSequence");
        }
        if (string.equals("notSameDay")) {
            return this.get("tip.CreateNsd");
        }
        if (string.equals("course")) {
            return this.get("LabelLinkCourse");
        }
        if (string.equals("rep")) {
            return this.get("LabelLinkRep");
        }
        if (string.equals("repNext")) {
            return this.get("LabelLinkRepNext");
        }
        if (string.equals("repPred")) {
            return this.get("LabelLinkRepPred");
        }
        if (string.equals("sess")) {
            return this.get("LabelLinkSess");
        }
        if (string.equals("sessNext")) {
            return this.get("LabelLinkSessNext");
        }
        if (string.equals("sessPred")) {
            return this.get("LabelLinkSessPred");
        }
        if (string.equals("slot")) {
            return this.get("LabelUnitSlot");
        }
        if (string.equals("hour")) {
            return this.get("LabelUnitHour");
        }
        if (string.equals("minute")) {
            return this.get("LabelUnitMinute");
        }
        if (string.equals("day")) {
            return this.get("LabelUnitDay");
        }
        if (string.equals("week")) {
            return this.get("LabelUnitWeek");
        }
        if (string.equals("precede")) {
            return this.get("LabelPrecede");
        }
        if (string.equals("follow")) {
            return this.get("LabelFollow");
        }
        if (string.equals("appart")) {
            return this.get("LabelApart");
        }
        if (string.equals("sequence")) {
            return this.get("LabelSequence");
        }
        if (string.equals("fromStart")) {
            return this.get("LabelStartFromBegin");
        }
        if (string.equals("fromEnd")) {
            return this.get("LabelStartFromEnd");
        }
        return "";
    }

    public String getDataCategories(Element element, Date date, HashMap<String, HashMap<String, ArrayList<String>>> hashMap) throws RemoteException {
        if (null == element) {
            return "";
        }
        String string = element.getString("category");
        return this.getData(element, date, hashMap.get(string));
    }

    public String getDataWorkflow(Element element, Date date, int n) throws RemoteException {
        if (null == element) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.get("LabelName"));
        stringBuffer.append(" : ");
        stringBuffer.append(element.getString("name"));
        stringBuffer.append("<br>");
        this.writeResources(stringBuffer, element, date);
        if (null != element.getChild("events")) {
            for (Element element2 : element.getChild("events").getChildrenArray()) {
                stringBuffer.append("<br><br><hr>");
                stringBuffer.append(this.getDataEvent(element2, date, n, true));
            }
        }
        return stringBuffer.toString();
    }

    public String getData(Element element, Date date, HashMap<String, ArrayList<String>> hashMap) throws RemoteException {
        if (null == element) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = hashMap.get("fields");
        ArrayList<String> arrayList2 = hashMap.get("api");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            String string2 = arrayList2.get(i);
            if (arrayList.get(i).equals("TAB_PARTICIPANTS")) {
                this.writeResources(stringBuffer, element, date);
                continue;
            }
            if (arrayList.get(i).equals("TAB_SECURITY")) {
                this.writeProfile(stringBuffer, element);
                continue;
            }
            if (arrayList.get(i).equals("COST")) {
                this.writeConstraints(stringBuffer, element, "type.Costs", "costs");
                continue;
            }
            if (arrayList.get(i).equals("CARAC")) {
                this.writeConstraints(stringBuffer, element, "type.Caracteristics", "caracteristics");
                continue;
            }
            if (arrayList.get(i).equals("COUNTERS")) {
                this.writeConstraints(stringBuffer, element, "LabelUseCounters", "counters");
                continue;
            }
            if (arrayList.get(i).equals("OPTIMIZE_QUALITY")) {
                this.writeQuality(stringBuffer, element);
                continue;
            }
            if (arrayList.get(i).equals("SETUPTIME")) continue;
            if (arrayList.get(i).equals("TAB_SETMEMBERS")) {
                this.writeSetMembers(stringBuffer, element, date);
                continue;
            }
            if (arrayList.get(i).equals("TAB_SETMEMBERSHIPS")) {
                this.writeSetMemberships(stringBuffer, element, date);
                continue;
            }
            try {
                stringBuffer.append(this.get(Field.getByName(string).getLabel()));
            }
            catch (NullPointerException nullPointerException) {
                stringBuffer.append(string);
            }
            stringBuffer.append(" : ");
            stringBuffer.append(element.getString(string2));
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    private void writeConstraints(StringBuffer stringBuffer, Element element, String string, String string2) {
        stringBuffer.append("<br><b>");
        stringBuffer.append(this.get(string));
        stringBuffer.append("</b><br>");
        if (null != element.getChild("constraints").getChild(string2)) {
            for (Element element2 : element.getChild("constraints").getChild(string2).getChildrenArray()) {
                stringBuffer.append(element2.getString("name"));
                stringBuffer.append(" : ");
                stringBuffer.append(element2.getString("value"));
                stringBuffer.append("<br>");
            }
        }
    }

    private void writeQuality(StringBuffer stringBuffer, Element element) {
        stringBuffer.append("<br>");
        stringBuffer.append(this.get("LabelDistribution"));
        stringBuffer.append(" : ");
        stringBuffer.append(element.getChild("constraints").getString("distribution"));
        stringBuffer.append("<br>");
        stringBuffer.append(this.get("LabelQuality"));
        stringBuffer.append(" : ");
        stringBuffer.append(element.getChild("constraints").getString("quality"));
        stringBuffer.append("<br>");
    }

    private void writeSetMembers(StringBuffer stringBuffer, Element element, Date date) throws RemoteException {
        stringBuffer.append("<br><b>");
        stringBuffer.append(this.get("column.MembersName"));
        stringBuffer.append("</b><br>");
        for (Element element2 : element.getChild("allMembers").getChildrenArray()) {
            int n = element2.getInt("id");
            int[] nArray = this.checkLoggedResource(n, date);
            if (nArray[0] == 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.get("LogDestroyed"));
                stringBuffer.append(")");
                continue;
            }
            if (nArray[0] == 2) continue;
            stringBuffer.append(element2.getString("quantity"));
            stringBuffer.append(" ");
            stringBuffer.append(this.getLink(nArray[1], element2.getString("name")));
            if (nArray[0] == 1) {
                stringBuffer.append("(");
                stringBuffer.append(this.get("LogDestroyed"));
                stringBuffer.append(")");
            }
            stringBuffer.append("<br>");
        }
    }

    private void writeSetMemberships(StringBuffer stringBuffer, Element element, Date date) throws RemoteException {
        stringBuffer.append("<br><b>");
        stringBuffer.append(this.get("TitleSetMemberShips"));
        stringBuffer.append("</b><br>");
        for (Element element2 : element.getChild("memberships").getChildrenArray()) {
            int n = element2.getInt("id");
            int[] nArray = this.checkLoggedResource(n, date);
            if (nArray[0] == 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.get("LogDestroyed"));
                stringBuffer.append(")");
            } else if (nArray[0] != 2) {
                stringBuffer.append(this.getLink(nArray[1], element2.getString("name")));
                if (nArray[0] == 1) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                }
            }
            stringBuffer.append("<br>");
        }
    }

    private void writeResources(StringBuffer stringBuffer, Element element, Date date) throws RemoteException {
        int[] nArray;
        Element element2 = element.getChild("resources");
        stringBuffer.append("<br><b>");
        stringBuffer.append(this.get("type.Participants"));
        stringBuffer.append("</b>");
        boolean bl = true;
        for (Element element3 : element2.getChildrenArray("and")) {
            int n = element3.getInt("id");
            int[] nArray2 = this.checkLoggedResource(n, date);
            if (nArray2[0] == 2) continue;
            if (bl) {
                stringBuffer.append("<br>");
                stringBuffer.append(this.get("Labelimpose"));
                stringBuffer.append(" : ");
            } else {
                stringBuffer.append(" / ");
            }
            if (nArray2[0] == 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.get("LogDestroyed"));
                stringBuffer.append(")");
            } else {
                stringBuffer.append(element3.getInt("quantity"));
                stringBuffer.append(" ");
                stringBuffer.append(this.getLink(nArray2[1], element3.getString("name")));
                if (nArray2[0] == 1) {
                    stringBuffer.append(" (");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                }
            }
            bl = false;
        }
        for (Element element3 : element2.getChildrenArray("or")) {
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("Labelchoose"));
            stringBuffer.append(" ");
            stringBuffer.append(element3.getInt("quantity"));
            stringBuffer.append(" ");
            if (null != this.getCategoryKeywords().get(element3.getString("category"))) {
                stringBuffer.append(this.getCategoryKeywords().get(element3.getString("category")));
            } else {
                stringBuffer.append(element3.getString("category"));
            }
            bl = true;
            Element[] elementArray = element3.getChildrenArray("and");
            int n = elementArray.length;
            for (int i = 0; i < n; ++i) {
                Element element4 = elementArray[i];
                nArray = this.checkLoggedResource(element4.getInt("id"), date);
                if (nArray[0] == 2) continue;
                if (bl) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.get("Labelamong"));
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append(" / ");
                }
                if (nArray[0] == 0) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(element4.getInt("quantity"));
                    stringBuffer.append(" ");
                    stringBuffer.append(this.getLink(nArray[1], element4.getString("name")));
                    if (nArray[0] == 1) {
                        stringBuffer.append(" (");
                        stringBuffer.append(this.get("LogDestroyed"));
                        stringBuffer.append(")");
                    }
                }
                bl = false;
            }
        }
        for (Element element3 : element2.getChildrenArray("orRequest")) {
            stringBuffer.append("<br>");
            stringBuffer.append(this.get("LabelrequestOf"));
            stringBuffer.append(" ");
            stringBuffer.append(element3.getInt("quantity"));
            stringBuffer.append(" ");
            if (null != this.getCategoryKeywords().get(element3.getString("category"))) {
                stringBuffer.append(this.getCategoryKeywords().get(element3.getString("category")));
            } else {
                stringBuffer.append(element3.getString("category"));
            }
            bl = true;
            for (Element element4 : element3.getChildrenArray("and")) {
                nArray = this.checkLoggedResource(element4.getInt("id"), date);
                if (nArray[0] == 2) continue;
                if (bl) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.get("Labelamong"));
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append(" / ");
                }
                if (nArray[0] == 0) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                }
                stringBuffer.append(element4.getInt("quantity"));
                stringBuffer.append(" ");
                stringBuffer.append(this.getLink(nArray[1], element4.getString("name")));
                if (nArray[0] == 1) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.get("LogDestroyed"));
                    stringBuffer.append(")");
                }
                bl = false;
            }
        }
    }

    public abstract String getLink(int var1, String var2);

    private void writeProfile(StringBuffer stringBuffer, Element element) {
        stringBuffer.append("<br>");
        stringBuffer.append(this.get("type.Profile"));
        stringBuffer.append(" : ");
        stringBuffer.append(element.getChild("rights").getString("profileName"));
        stringBuffer.append("<br>");
    }

    private HashMap<String, String> getCategoryKeywords() {
        if (null == this.categoryKeywords) {
            this.categoryKeywords = new HashMap();
            this.categoryKeywords.put("trainee", this.get("type.Category1"));
            this.categoryKeywords.put("instructor", this.get("type.Category2"));
            this.categoryKeywords.put("classroom", this.get("type.Category3"));
            this.categoryKeywords.put("equipment", this.get("type.Category4"));
            this.categoryKeywords.put("category5", this.get("type.Category5"));
            this.categoryKeywords.put("category6", this.get("type.Category6"));
            this.categoryKeywords.put("category7", this.get("type.Category7"));
            this.categoryKeywords.put("category8", this.get("type.Category8"));
            this.categoryKeywords.put("empty_or", this.get("LabelEmptyChoice"));
        }
        return this.categoryKeywords;
    }

    public abstract String get(String var1);

    public abstract int[] checkLoggedResource(int var1, Date var2) throws RemoteException;

    public abstract Date getDate(int var1, int var2, int var3) throws RemoteException;

    public HashMap<String, ArrayList<String>> getActivityVisibleFields() {
        if (null == this.activityVisibleFiledsAndApi) {
            this.activityVisibleFiledsAndApi = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ConfigManager configManager = ConfigManager.getInstance();
            Element element = configManager.readXmlFile("ActivityTab");
            for (Element element2 : element.getChildrenArray()) {
                if (element2.getString("id").equals("TAB_DATA")) {
                    for (Element element3 : element2.getChildrenArray()) {
                        if (element3.getString("id").equals("INFO")) {
                            for (Element element4 : element3.getChildrenArray("field")) {
                                this.getApiField(configManager, arrayList, arrayList2, element4);
                            }
                        }
                        if (!element3.getString("id").equals("INFO_NOTES")) continue;
                        this.getApiField(configManager, arrayList, arrayList2, element3);
                    }
                    continue;
                }
                if (element2.getString("id").equals("TAB_MOREDATA")) {
                    for (Element element3 : element2.getChild("panel").getChildrenArray("field")) {
                        this.getApiField(configManager, arrayList, arrayList2, element3);
                    }
                    continue;
                }
                if (element2.getString("id").equals("TAB_PARTICIPANTS")) {
                    this.getApiField(configManager, arrayList, arrayList2, element2);
                    continue;
                }
                if (!element2.getString("id").equals("TAB_SECURITY")) continue;
                this.getApiField(configManager, arrayList, arrayList2, element2);
            }
            this.activityVisibleFiledsAndApi.put("fields", arrayList);
            this.activityVisibleFiledsAndApi.put("api", arrayList2);
        }
        return this.activityVisibleFiledsAndApi;
    }

    public HashMap<String, HashMap<String, ArrayList<String>>> getResourceVisibleFields() {
        if (null == this.resourceVisibleFiledsAndApi) {
            int n;
            this.resourceVisibleFiledsAndApi = new HashMap();
            ConfigManager configManager = ConfigManager.getInstance();
            Element element = configManager.readXmlFile("Category");
            Element[] elementArray = element.getChildrenArray();
            for (n = 0; n < elementArray.length; ++n) {
                int n2 = elementArray[n].getInt("sameas");
                if (n2 == -1) continue;
                elementArray[n] = elementArray[n2 - 1];
            }
            for (n = 0; n < elementArray.length; ++n) {
                Element element2 = elementArray[n];
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
                for (Element element3 : element2.getChild("tabs").getChildrenArray()) {
                    if (element3.getString("id").equals("TAB_DATA")) {
                        for (Element element4 : element3.getChildrenArray()) {
                            if (element4.getString("id").equals("INFO")) {
                                for (Element element5 : element4.getChildrenArray("field")) {
                                    this.getApiField(configManager, arrayList, arrayList2, element5);
                                }
                            }
                            if (!element4.getString("id").equals("INFO_RESOURCE")) continue;
                            this.getApiField(configManager, arrayList, arrayList2, element4);
                        }
                        continue;
                    }
                    if (element3.getString("id").equals("TAB_MOREDATA")) {
                        for (Element element4 : element3.getChild("panel").getChildrenArray("field")) {
                            this.getApiField(configManager, arrayList, arrayList2, element4);
                        }
                        continue;
                    }
                    if (element3.getString("id").equals("TAB_CONSTRAINTS") || element3.getString("id").equals("TAB_COUNTERS")) {
                        for (Element element4 : element3.getChildrenArray()) {
                            this.getApiField(configManager, arrayList, arrayList2, element4);
                        }
                        continue;
                    }
                    if (!element3.getString("id").equals("TAB_SECURITY") && !element3.getString("id").equals("TAB_SETMEMBERS") && !element3.getString("id").equals("TAB_SETMEMBERSHIPS")) continue;
                    this.getApiField(configManager, arrayList, arrayList2, element3);
                }
                hashMap.put("fields", arrayList);
                hashMap.put("api", arrayList2);
                this.resourceVisibleFiledsAndApi.put(this.getApiCategory(n + 1), hashMap);
            }
        }
        return this.resourceVisibleFiledsAndApi;
    }

    private void getApiField(ConfigManager configManager, ArrayList<String> arrayList, ArrayList<String> arrayList2, Element element) {
        String string = element.getString("module");
        if (!"".equals(string) && !configManager.hasModule(string)) {
            return;
        }
        String string2 = element.getString("visible");
        if (string2.equals("false")) {
            return;
        }
        if (!this.hasPermission(string2)) {
            return;
        }
        if (!element.getString("id").equals("INFO_NOTES")) {
            arrayList.add(element.getString("id"));
        } else {
            arrayList.add("INFO_ACTIVITY");
        }
        arrayList2.add(this.getApiFields().get(element.getString("id")));
    }

    public abstract boolean hasPermission(String var1);

    private HashMap<String, String> getApiFields() {
        if (null == this.apiFields) {
            this.apiFields = new HashMap();
            this.apiFields.put("NAME", "name");
            this.apiFields.put("CODE_ACTIVITY", "code");
            this.apiFields.put("TYPE_ACTIVITY", "type");
            this.apiFields.put("WEB_ACTIVITY", "url");
            this.apiFields.put("DURATION", "duration");
            this.apiFields.put("REPETITION", "repetition");
            this.apiFields.put("INFO_NOTES", "info");
            this.apiFields.put("SIZE", "size");
            this.apiFields.put("TIMEZONE_ACTIVITY", "timezone");
            this.apiFields.put("CODEX_ACTIVITY", "codeX");
            this.apiFields.put("CODEY_ACTIVITY", "codeY");
            this.apiFields.put("CODEZ_ACTIVITY", "codeZ");
            this.apiFields.put("MAXSEATS", "maxSeats");
            this.apiFields.put("SEATSLEFT", "seatsLeft");
            this.apiFields.put("TAB_PARTICIPANTS", "resources");
            this.apiFields.put("TAB_SECURITY", "profile");
            this.apiFields.put("CODE_RESOURCE", "code");
            this.apiFields.put("TYPE_RESOURCE", "type");
            this.apiFields.put("WEB_RESOURCE", "url");
            this.apiFields.put("EMAIL", "email");
            this.apiFields.put("NUMBER", "number");
            this.apiFields.put("CAPACITY", "size");
            this.apiFields.put("INFO_RESOURCE", "info");
            this.apiFields.put("JOBCATEGORY", "jobCategory");
            this.apiFields.put("MANAGER", "manager");
            this.apiFields.put("ADDRESS1", "address1");
            this.apiFields.put("ADDRESS2", "address2");
            this.apiFields.put("ZIPCODE", "zipCode");
            this.apiFields.put("CITY", "city");
            this.apiFields.put("STATE", "state");
            this.apiFields.put("COUNTRY", "country");
            this.apiFields.put("TELEPHONE", "telephone");
            this.apiFields.put("FAX", "fax");
            this.apiFields.put("CODEX_RESOURCE", "codeX");
            this.apiFields.put("CODEY_RESOURCE", "codeY");
            this.apiFields.put("CODEZ_RESOURCE", "codeZ");
            this.apiFields.put("TIMEZONE_RESOURCE", "timezone");
            this.apiFields.put("COST", "costs");
            this.apiFields.put("CARAC", "carac");
            this.apiFields.put("COUNTERS", "counters");
            this.apiFields.put("OPTIMIZE_QUALITY", "quality");
            this.apiFields.put("SETUPTIME", "setupTime");
            this.apiFields.put("TAB_SETMEMBERS", "setupTime");
            this.apiFields.put("TAB_SETMEMBERSHIPS", "setupTime");
        }
        return this.apiFields;
    }

    private String getApiCategory(int n) {
        if (n == 1) {
            return "trainee";
        }
        if (n == 2) {
            return "instructor";
        }
        if (n == 3) {
            return "classroom";
        }
        if (n == 4) {
            return "equipment";
        }
        if (n == 5) {
            return "category5";
        }
        if (n == 6) {
            return "category6";
        }
        if (n == 7) {
            return "category7";
        }
        if (n == 8) {
            return "category8";
        }
        return "trainee";
    }
}

