/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Period
implements Serializable {
    private static final long serialVersionUID = 938102470450213875L;
    private String start;
    private String end;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yyyy");

    public Period() {
        this("-1", "-1");
        SDF.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Period(String string, String string2) {
        this.start = string;
        this.end = string2;
        SDF.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String getEnd() {
        return this.end;
    }

    public String getStart() {
        return this.start;
    }

    public void setEnd(String string) {
        this.end = string;
    }

    public boolean isStartBefore(String string) {
        if (this.getStart().equals("-1") || this.getStart().equals(string)) {
            return true;
        }
        try {
            Date date = SDF.parse(string);
            Date date2 = SDF.parse(this.getStart());
            return date2.before(date);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return false;
        }
    }

    public boolean isEndAfter(String string) {
        return this.nbDaysAfter(string) > 0;
    }

    public int nbDaysAfter(String string) {
        if (this.getEnd().equals("-1")) {
            return Integer.MAX_VALUE;
        }
        try {
            Date date = SDF.parse(string);
            Date date2 = SDF.parse(this.getEnd());
            return (int)((date2.getTime() - date.getTime()) / 86400000L + 1L);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return 0;
        }
    }

    public Date getStartDate() {
        if (!this.getStart().equals("-1")) {
            try {
                return SDF.parse(this.start);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return null;
    }

    public Date getEndDate() {
        if (!this.getEnd().equals("-1")) {
            try {
                return SDF.parse(this.end);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.end == null ? 0 : this.end.hashCode());
        n = 31 * n + (this.start == null ? 0 : this.start.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Period period = (Period)object;
        if (this.end == null ? period.end != null : !this.end.equals(period.end)) {
            return false;
        }
        return !(this.start == null ? period.start != null : !this.start.equals(period.start));
    }
}

