/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.beans.AdeApi6;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.EntityGroupError;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.log.Category;
import com.adesoft.struct.CalendarDate;
import com.adesoft.struct.CountersManager;
import com.adesoft.struct.DateQuantity;
import com.adesoft.struct.DaySlots;
import com.adesoft.struct.EntitiesResourcesToolsManager;
import com.adesoft.struct.MaxManager;
import com.adesoft.struct.Period;
import com.adesoft.struct.ResourceAffect;
import com.adesoft.struct.Settings;
import com.adesoft.struct.ValueAndPeriods;
import com.adesoft.struct.participants.NodeAndOr;
import com.adesoft.struct.participants.NodeOr;
import com.adesoft.struct.participants.NodeOrChild;
import com.adesoft.struct.participants.NodeOrEntity;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class ResourcesEditorManager {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.ResourcesEditorManager");
    private EntitiesResourcesToolsManager _aManager;
    private MaxManager _aMaxManager;
    private DateQuantity[] _dateQuantities;
    private NodeAndOr _rootNode;
    private boolean[] _isEventResourcesModified;
    private int[] _absolutesDays;
    private DateQuantity[] _displayableDateQuantities;
    private boolean _bIsLinked;

    public ResourcesEditorManager(NodeAndOr nodeAndOr, DateQuantity[] dateQuantityArray, AdeApi6 adeApi6) throws RemoteException, EntityGroupError, ProjectNotFoundException, AdeException {
        this._rootNode = nodeAndOr;
        this._rootNode.sortByName();
        this._dateQuantities = dateQuantityArray;
        this.setDisplayableDateQuantityMode(true);
        this.orderDateQuantities();
        this.initialize(null, adeApi6);
    }

    public ResourcesEditorManager(NodeAndOr nodeAndOr, DateQuantity[] dateQuantityArray, Settings settings) throws RemoteException, EntityGroupError, ProjectNotFoundException, AdeException {
        this._rootNode = nodeAndOr;
        this._rootNode.sortByName();
        this._dateQuantities = dateQuantityArray;
        this.setDisplayableDateQuantityMode(true);
        this.orderDateQuantities();
        this.initialize(settings, null);
    }

    private int computeMaxQuantityFor(NodeAndOr nodeAndOr, DateQuantity dateQuantity) {
        return this.computeMaxQuantityFor(nodeAndOr, dateQuantity, false);
    }

    private int computeMaxQuantityFor(NodeAndOr nodeAndOr, DateQuantity dateQuantity, boolean bl) {
        int n = 99999;
        int n2 = 99999;
        double d = 99999.0;
        int n3 = dateQuantity.getAbsoluteDay();
        int n4 = dateQuantity.getStartSlot();
        int n5 = dateQuantity.getDuration();
        DaySlots daySlots = null;
        if (null != nodeAndOr.getParent() && nodeAndOr.getParent().getType() == 2 && ((NodeOr)nodeAndOr.getParent()).isContinuous() && !dateQuantity.isUnactiveKeepResourcesLocked() || bl) {
            for (int i = 0; i < this.getDateQuantityCount(); ++i) {
                if (!this.getDateQuantity(i).isUnactiveKeepResourcesLocked()) {
                    int n6;
                    n3 = this.getDateQuantity(i).getAbsoluteDay();
                    n4 = this.getDateQuantity(i).getStartSlot();
                    n5 = this.getDateQuantity(i).getDuration();
                    DaySlots daySlots2 = new DaySlots(this.getToolsManager().getDaySlots(nodeAndOr.getEntity(), n3).getDaySlots());
                    daySlots = new DaySlots(daySlots2.getDaySlots().length, 0);
                    daySlots.add(n4, n5, nodeAndOr.getQuantity());
                    CountersManager countersManager = this.getToolsManager().getCountersManager(nodeAndOr.getEntity());
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MAX_VALUE;
                    double d4 = Double.MAX_VALUE;
                    double d5 = Double.MAX_VALUE;
                    if (countersManager.isUseCounters()) {
                        d2 = countersManager.getCounterFreePerDay(this.getDateQuantity(i).getCalendarDate().getDay());
                        d3 = countersManager.getCounterFreePerWeek(this.getDateQuantity(i).getCalendarDate().getWeek());
                        d4 = countersManager.getCounterFreePerMonth(this.getDateQuantity(i).getCalendarDate().getMonth());
                        d5 = countersManager.getCounterFreePerYear(this.getDateQuantity(i).getCalendarDate().getYear());
                    }
                    double d6 = (double)this.getDateQuantity(i).getDurationInMinutes() * ((NodeOrEntity)nodeAndOr).getLoadFactor();
                    double d7 = (double)this.getDateQuantity(i).getDurationInMinutes() * ((NodeOrEntity)nodeAndOr).getLoadFactor();
                    double d8 = (double)this.getDateQuantity(i).getDurationInMinutes() * ((NodeOrEntity)nodeAndOr).getLoadFactor();
                    double d9 = (double)this.getDateQuantity(i).getDurationInMinutes() * ((NodeOrEntity)nodeAndOr).getLoadFactor();
                    if (this.isLinked()) {
                        daySlots2.add(n4, n5, this.getQuantity(this.getDateQuantity(i), nodeAndOr));
                        if (countersManager.isUseCounters()) {
                            d2 += d6 * (double)this.getQuantity(this.getDateQuantity(i), nodeAndOr);
                            d3 += d7 * (double)this.getQuantity(this.getDateQuantity(i), nodeAndOr);
                            d4 += d8 * (double)this.getQuantity(this.getDateQuantity(i), nodeAndOr);
                            d5 += d9 * (double)this.getQuantity(this.getDateQuantity(i), nodeAndOr);
                        }
                    }
                    for (n6 = 0; n6 < this.getDateQuantityCount(); ++n6) {
                        int n7;
                        int n8;
                        if (this.getDateQuantity(n6) == this.getDateQuantity(i) || this.getDateQuantity(i).isUnactiveKeepResourcesLocked()) continue;
                        int n9 = this.getDateQuantity(n6).getAbsoluteDay();
                        if (n9 == n3) {
                            n8 = this.getDateQuantity(n6).getStartSlot();
                            n7 = this.getDateQuantity(n6).getDuration();
                            daySlots.add(n8, n7, nodeAndOr.getQuantity());
                            if (this.isLinked()) {
                                daySlots2.add(n8, n7, this.getQuantity(this.getDateQuantity(n6), nodeAndOr));
                            }
                        }
                        if (!countersManager.isUseCounters() || this.getDateQuantity(n6).getCalendarDate().getYear() != this.getDateQuantity(i).getCalendarDate().getYear()) continue;
                        n8 = new Double((double)this.getDateQuantity(n6).getDurationInMinutes() * ((NodeOrEntity)nodeAndOr).getLoadFactor()).intValue();
                        n7 = n8 * this.getQuantity(this.getDateQuantity(n6), nodeAndOr);
                        d9 += (double)n8;
                        if (this.isLinked()) {
                            d5 += (double)n7;
                        }
                        if (this.getDateQuantity(n6).getCalendarDate().getMonth() != this.getDateQuantity(i).getCalendarDate().getMonth()) continue;
                        d8 += (double)n8;
                        if (this.isLinked()) {
                            d4 += (double)n7;
                        }
                        if (this.getDateQuantity(n6).getCalendarDate().getWeek() != this.getDateQuantity(i).getCalendarDate().getWeek()) continue;
                        d7 += (double)n8;
                        if (this.isLinked()) {
                            d3 += (double)n7;
                        }
                        if (this.getDateQuantity(n6).getCalendarDate().getDay() != this.getDateQuantity(i).getCalendarDate().getDay()) continue;
                        d6 += (double)n8;
                        if (!this.isLinked()) continue;
                        d2 += (double)n7;
                    }
                    n6 = -1;
                    try {
                        n6 = daySlots2.getNbMin(n4, n5, daySlots) * nodeAndOr.getQuantity();
                    }
                    catch (Exception exception) {
                        LOG.debug((Object)("Error in Required for " + nodeAndOr));
                    }
                    n2 = Math.min(n2, n6);
                    if (countersManager.isUseCounters()) {
                        if (((NodeOrEntity)nodeAndOr).getLoadFactor() > 0.0) {
                            d2 = d2 / d6 / (double)nodeAndOr.getQuantity() * (double)nodeAndOr.getQuantity();
                            d3 = d3 / d7 / (double)nodeAndOr.getQuantity() * (double)nodeAndOr.getQuantity();
                            d4 = d4 / d8 / (double)nodeAndOr.getQuantity() * (double)nodeAndOr.getQuantity();
                            d5 = d5 / d9 / (double)nodeAndOr.getQuantity() * (double)nodeAndOr.getQuantity();
                        } else {
                            d2 = 2.147483647E9;
                            d3 = 2.147483647E9;
                            d4 = 2.147483647E9;
                            d5 = 2.147483647E9;
                        }
                        d = Math.min(d, d2);
                        d = Math.min(d, d3);
                        d = Math.min(d, d4);
                        d = Math.min(d, d5);
                    } else {
                        d = 2.147483647E9;
                    }
                }
                n = (int)Math.min((double)n2, d);
            }
        } else if (null != nodeAndOr.getParent() && nodeAndOr.getParent().getType() != 2) {
            n = 0;
        } else if (nodeAndOr instanceof NodeOrEntity) {
            DaySlots daySlots3 = this.getToolsManager().getDaySlots(nodeAndOr.getEntity(), n3);
            daySlots = new DaySlots(daySlots3.getDaySlots().length, 0);
            daySlots.add(n4, n5, nodeAndOr.getQuantity());
            try {
                n2 = daySlots3.getNbMin(n4, n5, daySlots) * nodeAndOr.getQuantity();
            }
            catch (Exception exception) {
                LOG.debug((Object)("Error in Required for " + nodeAndOr));
            }
            CountersManager countersManager = this.getToolsManager().getCountersManager(nodeAndOr.getEntity());
            int n10 = Integer.MAX_VALUE;
            int n11 = Integer.MAX_VALUE;
            int n12 = Integer.MAX_VALUE;
            int n13 = Integer.MAX_VALUE;
            if (((NodeOrEntity)nodeAndOr).getLoadFactor() > 0.0 && countersManager.isUseCounters()) {
                n10 = new Double(countersManager.getCounterFreePerDay(dateQuantity.getCalendarDate().getDay()) / (double)dateQuantity.getDurationInMinutes() / ((NodeOrEntity)nodeAndOr).getLoadFactor()).intValue();
                n11 = new Double(countersManager.getCounterFreePerWeek(dateQuantity.getCalendarDate().getWeek()) / (double)dateQuantity.getDurationInMinutes() / ((NodeOrEntity)nodeAndOr).getLoadFactor()).intValue();
                n12 = new Double(countersManager.getCounterFreePerMonth(dateQuantity.getCalendarDate().getMonth()) / (double)dateQuantity.getDurationInMinutes() / ((NodeOrEntity)nodeAndOr).getLoadFactor()).intValue();
                n13 = new Double(countersManager.getCounterFreePerYear(dateQuantity.getCalendarDate().getYear()) / (double)dateQuantity.getDurationInMinutes() / ((NodeOrEntity)nodeAndOr).getLoadFactor()).intValue();
            }
            if (countersManager.isUseCounters()) {
                d = Math.min(d, (double)n10);
                d = Math.min(d, (double)n11);
                d = Math.min(d, (double)n12);
                d = Math.min(d, (double)n13);
                n = (int)Math.min((double)n2, d);
            } else {
                n = n2;
            }
            n /= nodeAndOr.getQuantity();
            n *= nodeAndOr.getQuantity();
        }
        if (n < 0) {
            n = 0;
        }
        return n += this.getQuantity(dateQuantity, nodeAndOr);
    }

    public DateQuantity[] getDateQuantities() {
        return this._dateQuantities;
    }

    public void setDisplayableDateQuantityMode(boolean bl) {
        if (bl) {
            this._displayableDateQuantities = this.getDateQuantities();
        } else {
            ArrayList<DateQuantity> arrayList = new ArrayList<DateQuantity>();
            for (int i = 0; i < this.getDateQuantityCount(); ++i) {
                if (this.getDateQuantity(i).isBooked()) continue;
                arrayList.add(this.getDateQuantity(i));
            }
            this._displayableDateQuantities = new DateQuantity[arrayList.size()];
            arrayList.toArray(this._displayableDateQuantities);
        }
    }

    public DateQuantity getDisplayableDateQuantity(int n) {
        if (null != this._displayableDateQuantities) {
            return this._displayableDateQuantities[n];
        }
        return null;
    }

    public int getDisplayableDateQuantityCount() {
        int n = 0;
        if (null != this._displayableDateQuantities) {
            n = this._displayableDateQuantities.length;
        }
        return n;
    }

    public DateQuantity getDateQuantity(int n) {
        if (n < 0 || n >= this.getDateQuantityCount()) {
            return null;
        }
        return this.getDateQuantities()[n];
    }

    public int getDateQuantityCount() {
        if (null == this.getDateQuantities()) {
            return 0;
        }
        return this.getDateQuantities().length;
    }

    public int getGlobalFreeFor(NodeAndOr nodeAndOr, boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            n2 = this.getMaxQuantityFor(nodeAndOr, this.getDateQuantity(i), true) - this.getQuantity(this.getDateQuantity(i), nodeAndOr);
            n = 0 == i ? n2 : Math.min(n, n2);
        }
        return n;
    }

    public int getGlobalUsedFor(NodeAndOr nodeAndOr) {
        boolean bl = true;
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            int n3 = this.getQuantity(this.getDateQuantity(i), nodeAndOr);
            if (n3 <= 0) continue;
            ++n2;
            if (n >= 0 && n != n3) {
                n = Math.min(n, n3);
                bl = false;
                continue;
            }
            n = n3;
        }
        if (n2 == this.getDateQuantityCount()) {
            if (!bl) {
                return -n;
            }
        } else {
            n = n > 0 ? 0 : Integer.MIN_VALUE;
        }
        return n;
    }

    public int getIndexForDateQuantity(DateQuantity dateQuantity) {
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            if (this.getDateQuantity(i) != dateQuantity) continue;
            return i;
        }
        return -1;
    }

    public MaxManager getMaxManager() {
        if (null == this._aMaxManager) {
            this._aMaxManager = new MaxManager();
        }
        return this._aMaxManager;
    }

    public int getMaxQuantityFor(NodeAndOr nodeAndOr, DateQuantity dateQuantity) {
        return this.computeMaxQuantityFor(nodeAndOr, dateQuantity);
    }

    public int getMaxQuantityFor(NodeAndOr nodeAndOr, DateQuantity dateQuantity, boolean bl) {
        return this.computeMaxQuantityFor(nodeAndOr, dateQuantity, bl);
    }

    public int getNbEvents() {
        if (null == this.getDateQuantities()) {
            return 0;
        }
        return this.getDateQuantities().length;
    }

    public int getQuantity(DateQuantity dateQuantity, NodeAndOr nodeAndOr) {
        ResourceAffect[] resourceAffectArray = dateQuantity.getResourceAffect();
        if (null != resourceAffectArray) {
            if (nodeAndOr.getType() == 2) {
                NodeOr nodeOr = (NodeOr)nodeAndOr;
                int n = 0;
                int n2 = 0;
                boolean bl = true;
                for (int i = 0; i < nodeOr.getChildCount(); ++i) {
                    try {
                        NodeOrEntity nodeOrEntity = (NodeOrEntity)nodeOr.getChildAt(i);
                        n2 = this.getQuantity(dateQuantity, nodeOrEntity) / nodeOrEntity.getQuantity();
                        bl &= 0 == this.getQuantity(dateQuantity, nodeOrEntity) % nodeOrEntity.getQuantity();
                        n += n2;
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    n = -n;
                }
                return n;
            }
            for (int i = 0; i < resourceAffectArray.length; ++i) {
                if (resourceAffectArray[i].getEntity() != nodeAndOr.getEntity() || resourceAffectArray[i].getNodeId() != nodeAndOr.getId()) continue;
                return resourceAffectArray[i].getSelectedQuantity();
            }
        }
        return 0;
    }

    public NodeAndOr getRootNode() {
        return this._rootNode;
    }

    public EntitiesResourcesToolsManager getToolsManager() {
        if (null == this._aManager) {
            this._aManager = new EntitiesResourcesToolsManager();
        }
        return this._aManager;
    }

    private void initialize(Settings settings, AdeApi6 adeApi6) throws RemoteException, EntityGroupError, ProjectNotFoundException, AdeException {
        Comparable<Integer> comparable;
        int n;
        this._isEventResourcesModified = new boolean[this.getNbEvents()];
        Arrays.fill(this._isEventResourcesModified, false);
        HashMap<Integer, DateQuantity> hashMap = new HashMap<Integer, DateQuantity>();
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            DateQuantity dateQuantity = this.getDateQuantity(i);
            n = dateQuantity.getAbsoluteDay();
            comparable = new Integer(n);
            hashMap.put((Integer)comparable, dateQuantity);
        }
        this._absolutesDays = new int[hashMap.size()];
        Iterator iterator = hashMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this._absolutesDays[n2] = n = ((Integer)iterator.next()).intValue();
            ++n2;
        }
        if (null != this.getRootNode()) {
            for (n = 0; n < this.getRootNode().getChildCount(); ++n) {
                comparable = this.getRootNode().getChildAt(n);
                if (((NodeAndOr)comparable).getType() != 2) continue;
                for (int i = 0; i < ((NodeAndOr)comparable).getChildCount(); ++i) {
                    Object object;
                    NodeOrEntity nodeOrEntity;
                    NodeOrChild nodeOrChild = (NodeOrChild)((NodeAndOr)comparable).getChildAt(i);
                    if (!(nodeOrChild instanceof NodeOrEntity) || !(nodeOrEntity = (NodeOrEntity)nodeOrChild).isLeaf() && nodeOrEntity.getType() != 2) continue;
                    ArrayList<CalendarDate> arrayList = new ArrayList<CalendarDate>();
                    for (int j = 0; j < this._absolutesDays.length; ++j) {
                        int n3;
                        object = null;
                        if (adeApi6 != null) {
                            object = adeApi6.getDayDate(this._absolutesDays[j]);
                        } else if (settings != null) {
                            int n4 = settings.getNDays();
                            n3 = this._absolutesDays[j] / n4;
                            int n5 = this._absolutesDays[j] % n4;
                            object = settings.getDayDate(n3, n5);
                        }
                        int[] nArray = new int[]{};
                        n3 = 1;
                        Set<Set<Integer>> set = nodeOrEntity.getCostsIds();
                        if (set != null) {
                            block5: for (Set<Integer> set2 : set) {
                                for (int n6 : set2) {
                                    ValueAndPeriods valueAndPeriods = nodeOrEntity.getEntity().getCost(n6);
                                    for (Period period : valueAndPeriods.getPeriods()) {
                                        if (!period.isStartBefore((String)object) || !period.isEndAfter((String)object)) continue;
                                        continue block5;
                                    }
                                }
                                n3 = 0;
                                break;
                            }
                        }
                        if (n3 != 0) {
                            DateQuantity dateQuantity = (DateQuantity)hashMap.get(new Integer(this._absolutesDays[j]));
                            arrayList.add(dateQuantity.getCalendarDate());
                            int n7 = dateQuantity.getWeek();
                            int n8 = dateQuantity.getEvent().getDay();
                            nArray = nodeOrEntity.getEntity().getQuantityAvailable(n7, n8);
                        }
                        this.getToolsManager().setDaySlots(nodeOrEntity.getEntity(), this._absolutesDays[j], nArray);
                    }
                    CalendarDate[] calendarDateArray = new CalendarDate[arrayList.size()];
                    arrayList.toArray(calendarDateArray);
                    object = new CountersManager();
                    object = nodeOrEntity.getEntity().fillCountersManager(calendarDateArray, (CountersManager)object);
                    this.getToolsManager().setCountersManager(nodeOrEntity.getEntity(), (CountersManager)object);
                }
            }
        }
    }

    public boolean isLinked() {
        return this._bIsLinked;
    }

    public boolean isNodesOk(DateQuantity dateQuantity) {
        for (int i = 0; i < this.getRootNode().getChildCount(); ++i) {
            NodeAndOr nodeAndOr = this.getRootNode().getChildAt(i);
            if (nodeAndOr.getType() != 2 && (null == nodeAndOr.getParent() || nodeAndOr.getParent().getType() != 1 || nodeAndOr.getType() == 3)) continue;
            int n = this.getQuantity(dateQuantity, nodeAndOr);
            int n2 = nodeAndOr.getQuantity();
            if (n <= 0 || n == n2) continue;
            return false;
        }
        return true;
    }

    public boolean isNodesOk() {
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            DateQuantity dateQuantity = this.getDateQuantity(i);
            if (this.isNodesOk(dateQuantity)) continue;
            return false;
        }
        return true;
    }

    public boolean isOrNodeOkForAll(NodeAndOr nodeAndOr) {
        if (nodeAndOr.getType() != 2) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            n = this.getQuantity(this.getDateQuantity(i), nodeAndOr);
            if (n == (n2 = nodeAndOr.getQuantity())) continue;
            return false;
        }
        return true;
    }

    public boolean isResourcesModified(DateQuantity dateQuantity) {
        int n = this.getIndexForDateQuantity(dateQuantity);
        if (-1 < n) {
            return this._isEventResourcesModified[n];
        }
        return false;
    }

    private void orderDateQuantities() {
        if (null != this.getDateQuantities()) {
            Comparator comparator = DateQuantity.getComparator();
            Arrays.sort(this.getDateQuantities(), comparator);
        }
    }

    public void resetValues() {
        for (int i = 0; i < this.getDateQuantityCount(); ++i) {
            DateQuantity dateQuantity = this.getDateQuantity(i);
            if (dateQuantity.isResourcesLocked()) continue;
            this.resetValues(dateQuantity, this.getRootNode());
        }
    }

    private void resetValues(DateQuantity dateQuantity, NodeAndOr nodeAndOr) {
        if (nodeAndOr.getChildCount() == 0) {
            int n;
            if (nodeAndOr.getParent() != this.getRootNode() && (n = this.getQuantity(dateQuantity, nodeAndOr)) > 0 && this.canModifyCell(dateQuantity, nodeAndOr)) {
                this.setCurrentQuantity(dateQuantity, nodeAndOr, 0, false);
            }
        } else {
            for (int i = 0; i < nodeAndOr.getChildCount(); ++i) {
                this.resetValues(dateQuantity, nodeAndOr.getChildAt(i));
            }
        }
    }

    private boolean canModifyCell(DateQuantity dateQuantity, NodeAndOr nodeAndOr) {
        DateQuantity[] dateQuantityArray;
        NodeOr nodeOr;
        if (null == dateQuantity) {
            return false;
        }
        if (dateQuantity.isResourcesLocked()) {
            return false;
        }
        if (!nodeAndOr.isEditable()) {
            return false;
        }
        if (nodeAndOr.getAndOrParent() instanceof NodeOr && (nodeOr = (NodeOr)nodeAndOr.getAndOrParent()).isContinuous() && null != (dateQuantityArray = this.getDateQuantities())) {
            for (int i = 0; i < dateQuantityArray.length; ++i) {
                if (!dateQuantityArray[i].isResourcesLocked()) continue;
                return false;
            }
        }
        return true;
    }

    public void setCurrentQuantity(DateQuantity dateQuantity, NodeAndOr nodeAndOr, int n, boolean bl) {
        this.setQuantityToResources(dateQuantity, nodeAndOr, n);
        if (dateQuantity.isUnactiveKeepResourcesLocked()) {
            return;
        }
        if (nodeAndOr.getParent() != null && nodeAndOr.getParent().getType() == 2 && (((NodeOr)nodeAndOr.getParent()).isContinuous() || this.isLinked())) {
            for (int i = 0; i < this.getDateQuantityCount(); ++i) {
                if (this.getDateQuantity(i) == dateQuantity || this.getDateQuantity(i).isUnactiveKeepResourcesLocked()) continue;
                this.setQuantityToResources(this.getDateQuantity(i), nodeAndOr, n);
            }
        }
    }

    public void setLinked(boolean bl) {
        this._bIsLinked = bl;
    }

    private void setQuantityToResources(DateQuantity dateQuantity, NodeAndOr nodeAndOr, int n) {
        boolean bl = false;
        ResourceAffect[] resourceAffectArray = dateQuantity.getResourceAffect();
        int n2 = 0;
        if (null != resourceAffectArray) {
            int n3;
            for (int i = 0; i < resourceAffectArray.length; ++i) {
                if (resourceAffectArray[i].getEntity() != nodeAndOr.getEntity() || resourceAffectArray[i].getNodeId() != nodeAndOr.getId()) continue;
                bl = true;
                n2 = resourceAffectArray[i].getSelectedQuantity();
                resourceAffectArray[i].setSelectedQuantity(n);
            }
            if (!bl) {
                ResourceAffect resourceAffect = new ResourceAffect(nodeAndOr.getId(), n, nodeAndOr.getEntity());
                ResourceAffect[] resourceAffectArray2 = new ResourceAffect[resourceAffectArray.length + 1];
                for (n3 = 0; n3 < resourceAffectArray.length; ++n3) {
                    resourceAffectArray2[n3] = resourceAffectArray[n3];
                }
                resourceAffectArray2[resourceAffectArray2.length - 1] = resourceAffect;
                dateQuantity.setResourceAffect(resourceAffectArray2);
            }
            this._isEventResourcesModified[this.getIndexForDateQuantity((DateQuantity)dateQuantity)] = true;
            DaySlots daySlots = this.getToolsManager().getDaySlots(nodeAndOr.getEntity(), dateQuantity.getAbsoluteDay());
            int n4 = dateQuantity.getStartSlot();
            n3 = dateQuantity.getDuration();
            int n5 = n - n2;
            daySlots.remove(n4, n3, n5);
            CountersManager countersManager = this.getToolsManager().getCountersManager(nodeAndOr.getEntity());
            if (countersManager.isUseCounters()) {
                int n6 = new Double((double)n5 * ((NodeOrEntity)nodeAndOr).getLoadFactor() * (double)dateQuantity.getDurationInMinutes()).intValue();
                countersManager.addToCountersUsed(dateQuantity.getCalendarDate(), n6);
            }
        }
    }
}

