/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct;

import com.adesoft.config.ConfigManager;
import com.adesoft.modules.Modules;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class WizardTFData
implements Serializable {
    private static final long serialVersionUID = 520L;
    public static final int NB_SLOT2 = 289;
    private static final int NB_WEEKS_DEFAULT = 52;
    private static final int NB_WEEKS_1 = 104;
    private static final int NB_WEEKS_2 = 1620;
    private static final int NB_DAYS_DEFAULT = 7;
    private static final int NB_DAYS_1 = 7;
    private static final int NB_DAYS_2 = 14;
    private static volatile Date[] defaultWeekDates;
    private boolean canModify;
    private int granularity;
    private String[] weeks;
    private String[] days;
    private String[] slots;
    private Date[] dates;
    private int[] offsets;
    private Date[] times;
    private int firstWeek;
    private int lastWeek;
    private int firstDay;
    private int lastDay;
    private int firstSlot;
    private int lastSlot;
    private int firstVisibleWeek;
    private int lastVisibleWeek;

    public boolean canModify() {
        return this.canModify;
    }

    public String[] getDayNames() {
        return this.days;
    }

    public int[] getDayOffsets() {
        return this.offsets;
    }

    public static int getNbWeeks() {
        if (ConfigManager.getInstance().hasModule(Modules.WEEKS2)) {
            return 1620;
        }
        if (ConfigManager.getInstance().hasModule(Modules.WEEKS1)) {
            return 104;
        }
        return 52;
    }

    public static int getNbDays() {
        if (ConfigManager.getInstance().hasModule(Modules.WEEKS2)) {
            return 14;
        }
        if (ConfigManager.getInstance().hasModule(Modules.WEEKS1)) {
            return 7;
        }
        return 7;
    }

    public static String[] getDefaultDayNames() {
        String[] stringArray = new String[WizardTFData.getNbDays()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "day" + (i + 1);
        }
        return stringArray;
    }

    public static int[] getDefaultDayOffsets() {
        int[] nArray = new int[WizardTFData.getNbDays()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + 1;
        }
        return nArray;
    }

    public static String[] getDefaultSlotNames(int n) {
        int n2;
        int n3 = 289;
        if (60 == n) {
            n3 = 25;
        } else if (30 == n) {
            n3 = 49;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        String[] stringArray = new String[n3];
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        if (5 == n) {
            calendar.set(11, 8);
        }
        int n4 = Math.min(1 + 1440 / n, n3);
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = calendar.get(11);
            int n6 = calendar.get(12);
            String string = n5 >= 10 ? "" + n5 : "0" + n5;
            String string2 = n6 >= 10 ? "" + n6 : "0" + n6;
            stringArray[n2] = string + "h" + string2;
            calendar.add(12, n);
        }
        for (n2 = n4; n2 < n3; ++n2) {
            stringArray[n2] = "00h00";
        }
        return stringArray;
    }

    public static Date[] getDefaultSlotTimes(int n) {
        int n2;
        int n3 = 289;
        if (60 == n) {
            n3 = 25;
        } else if (30 == n) {
            n3 = 49;
        }
        Date[] dateArray = new Date[n3];
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (5 == n) {
            calendar.set(11, 8);
        }
        Date date = calendar.getTime();
        int n4 = Math.min(1 + 1440 / n, n3);
        for (n2 = 0; n2 < n4; ++n2) {
            dateArray[n2] = calendar.getTime();
            calendar.add(12, n);
        }
        for (n2 = n4; n2 < n3; ++n2) {
            dateArray[n2] = date;
        }
        return dateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date[] getDefaultWeekDates() {
        if (null != defaultWeekDates) return (Date[])defaultWeekDates.clone();
        Class<WizardTFData> clazz = WizardTFData.class;
        synchronized (WizardTFData.class) {
            if (null != defaultWeekDates) return (Date[])defaultWeekDates.clone();
            Date[] dateArray = new Date[WizardTFData.getNbWeeks()];
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.setTime(new Date());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(7, calendar.getFirstDayOfWeek());
            calendar.set(3, 1);
            for (int i = 0; i < dateArray.length; ++i) {
                dateArray[i] = calendar.getTime();
                calendar.add(3, 1);
            }
            defaultWeekDates = dateArray;
            // ** MonitorExit[var0] (shouldn't be in output)
            return (Date[])defaultWeekDates.clone();
        }
    }

    public static Date[] getDefaultMonthDates(int n) {
        Date[] dateArray = new Date[WizardTFData.getNbWeeks()];
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date());
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.set(3, 1);
        for (int i = 0; i < dateArray.length; ++i) {
            dateArray[i] = calendar.getTime();
            calendar.add(3, 1);
            if (i != dateArray.length - 1) continue;
            calendar.set(7, calendar.getFirstDayOfWeek() + n - 1);
            calendar.add(3, 1);
        }
        return dateArray;
    }

    public static String[] getDefaultWeekNames() {
        String[] stringArray = new String[WizardTFData.getNbWeeks()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "week" + (i + 1);
        }
        return stringArray;
    }

    public int getFirstDay() {
        return this.firstDay;
    }

    public int getFirstSlot() {
        return this.firstSlot;
    }

    public int getFirstWeek() {
        return this.firstWeek;
    }

    public int getFirstVisibleWeek() {
        return this.firstVisibleWeek;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public int getLastDay() {
        return this.lastDay;
    }

    public int getLastSlot() {
        return this.lastSlot;
    }

    public int getLastWeek() {
        return this.lastWeek;
    }

    public int getLastVisibleWeek() {
        return this.lastVisibleWeek;
    }

    public String[] getSlotNames() {
        return this.slots;
    }

    public Date[] getSlotTimes() {
        return this.times;
    }

    public Date[] getWeekDates() {
        return this.dates;
    }

    public String[] getWeekNames() {
        return this.weeks;
    }

    public void setCanModify(boolean bl) {
        this.canModify = bl;
    }

    public void setDayNames(String[] stringArray) {
        this.days = stringArray;
    }

    public void setDayOffsets(int[] nArray) {
        this.offsets = nArray;
    }

    public void setDefaultValues(String[] stringArray, String[] stringArray2) {
        this.canModify = true;
        this.granularity = 30;
        this.times = WizardTFData.getDefaultSlotTimes(this.granularity);
        this.dates = WizardTFData.getDefaultWeekDates();
        this.offsets = WizardTFData.getDefaultDayOffsets();
        this.weeks = stringArray;
        this.days = stringArray2;
        this.slots = WizardTFData.getDefaultSlotNames(this.granularity);
        this.firstWeek = 0;
        this.lastWeek = 0;
        this.firstDay = 0;
        this.lastDay = 6;
        this.firstSlot = 6;
        this.lastSlot = 10;
        this.firstVisibleWeek = 0;
        this.lastVisibleWeek = 0;
    }

    public void setFirstDay(int n) {
        this.firstDay = n;
    }

    public void setFirstSlot(int n) {
        this.firstSlot = n;
    }

    public void setFirstWeek(int n) {
        this.firstWeek = n;
    }

    public void setFirstVistbleWeek(int n) {
        this.firstVisibleWeek = n;
    }

    public void setGranularity(int n) {
        if (n != this.granularity) {
            this.granularity = n;
            if (5 != n) {
                this.firstSlot = 480 / n;
                this.lastSlot = 1140 / n - 1;
            } else {
                this.firstSlot = 0;
                this.lastSlot = 287;
            }
            this.times = WizardTFData.getDefaultSlotTimes(this.granularity);
            this.slots = WizardTFData.getDefaultSlotNames(this.granularity);
        }
    }

    public void setLastDay(int n) {
        this.lastDay = n;
    }

    public void setLastSlot(int n) {
        this.lastSlot = n;
    }

    public void setLastWeek(int n) {
        this.lastWeek = n;
    }

    public void setLastVisibleWeek(int n) {
        this.lastVisibleWeek = n;
    }

    public void setSlotNames(String[] stringArray) {
        this.slots = stringArray;
    }

    public void setSlotTimes(Date[] dateArray) {
        this.times = dateArray;
    }

    public void setWeekDates(Date[] dateArray) {
        this.dates = dateArray;
    }

    public void setWeekNames(String[] stringArray) {
        this.weeks = stringArray;
    }
}

