/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.configurations;

import com.adesoft.log.Category;
import com.adesoft.struct.Field;
import com.adesoft.struct.configurations.ConfigurationIO;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class Configuration
implements Serializable,
Comparable {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.configurations.CourseMembers");
    private static final long serialVersionUID = 520L;
    public static final int ENGINE = 0;
    public static final int VISUALIZATION = 8;
    private static final int FILTER = 64;
    public static final int FILTER_PARTICIPANT = 65;
    public static final int FILTER_COURSE = 66;
    public static final int FILTER_LINKS = 68;
    public static final int FILTER_USER = 72;
    private static final int SEARCH = 128;
    public static final int SEARCH_PARTICIPANT = 129;
    public static final int SEARCH_COURSE = 130;
    public static final int SEARCH_LINKS = 132;
    public static final int SEARCH_USER = 136;
    public static final int DYNAMIC_LIST = 256;
    private final int id;
    private final int type;
    private String name;
    private String profileName;
    private String ownerName;
    private String buffer;
    private int dynamicListEntityType = -1;
    private Set<Set<Integer>> costsIds;
    private boolean isNoFilter;

    public Configuration(int n, String string, int n2, String string2, boolean bl, Set<Set<Integer>> set) {
        if (!bl && -1 == n) {
            throw new IllegalArgumentException("Invalid oid (-1) : Use ConfigurationsManagerImpl.createConfiguration");
        }
        if (!bl && null == string2) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        this.id = n;
        this.name = string;
        this.profileName = "";
        this.ownerName = "";
        this.buffer = string2;
        this.type = n2;
        this.isNoFilter = bl;
        this.costsIds = set;
    }

    public Configuration(int n, String string, int n2, String string2, boolean bl) {
        this(n, string, n2, string2, bl, null);
    }

    public Configuration(int n, String string, int n2, String string2) {
        this(n, string, n2, string2, null);
    }

    public Configuration(int n, String string, int n2, String string2, Set<Set<Integer>> set) {
        this(n, string, n2, string2, false, set);
    }

    public static Comparator getComparator(Field field, boolean bl) {
        Comparator comparator = null;
        final int n = bl ? 1 : -1;
        final Field field2 = field;
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                Configuration configuration = (Configuration)object;
                Configuration configuration2 = (Configuration)object2;
                if (configuration.isNoFilter) {
                    return -1;
                }
                if (configuration2.isNoFilter) {
                    return 1;
                }
                int n2 = ((Configuration)object).compareTo(object2, field2);
                return n2 *= n;
            }
        };
        return comparator;
    }

    public int getDynamicListEntityType() {
        if (256 == this.getType()) {
            if (-1 == this.dynamicListEntityType && !"".equals(this.getBuffer())) {
                if (this.getBuffer().contains("IS_STUDENT")) {
                    this.dynamicListEntityType = 1;
                } else if (this.getBuffer().contains("IS_TEACHER")) {
                    this.dynamicListEntityType = 2;
                } else if (this.getBuffer().contains("IS_CLASSROOM")) {
                    this.dynamicListEntityType = 3;
                } else if (this.getBuffer().contains("IS_RESOURCE")) {
                    this.dynamicListEntityType = 4;
                } else if (this.getBuffer().contains("IS_CATEGORY5")) {
                    this.dynamicListEntityType = 5;
                } else if (this.getBuffer().contains("IS_CATEGORY6")) {
                    this.dynamicListEntityType = 6;
                } else if (this.getBuffer().contains("IS_CATEGORY7")) {
                    this.dynamicListEntityType = 7;
                } else if (this.getBuffer().contains("IS_CATEGORY8")) {
                    this.dynamicListEntityType = 8;
                }
            }
            return this.dynamicListEntityType;
        }
        return -1;
    }

    public Set<Set<Integer>> getCostsIds() {
        return this.costsIds;
    }

    public int compareTo(Object object, Field field) {
        if (Field.NAME == field) {
            return this.name.toLowerCase().compareTo(((Configuration)object).name.toLowerCase());
        }
        if (Field.ID == field) {
            return this.id - ((Configuration)object).getId();
        }
        if (Field.PROFILE == field) {
            return this.profileName.compareTo(((Configuration)object).profileName);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Configuration) {
            return this.getId() == ((Configuration)object).getId();
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public int compareTo(Object object) {
        Configuration configuration = (Configuration)object;
        if (0 == this.getName().compareTo(configuration.getName())) {
            return this.getId() - configuration.getId();
        }
        return this.getName().compareTo(configuration.getName());
    }

    public final int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setBuffer(String string) {
        this.buffer = string;
        this.costsIds = new HashSet<Set<Integer>>();
        try {
            Document document = new SAXBuilder().build((Reader)new StringReader(this.buffer));
            Element element = document.getRootElement();
            Element[] elementArray = element.getChildrenArray();
            for (int i = 0; i < elementArray.length; ++i) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                Element[] elementArray2 = elementArray[i].getChildrenArray();
                for (int j = 0; j < elementArray2.length; ++j) {
                    Attribute attribute = elementArray2[j].getAttribute("name");
                    if (attribute == null || !attribute.getValue().startsWith("COST-")) continue;
                    hashSet.add(Integer.parseInt(attribute.getValue().substring("COST-".length())));
                }
                if (hashSet.isEmpty()) continue;
                this.costsIds.add(hashSet);
            }
        }
        catch (JDOMException jDOMException) {
            LOG.error((Object)jDOMException);
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public static boolean isFilter(int n) {
        return 64 == (0x40 & n);
    }

    public static boolean isSearch(int n) {
        return 128 == (0x80 & n);
    }

    public boolean update(ConfigurationIO configurationIO) {
        String string = configurationIO.getBuffer();
        if (null != string && !string.equals(this.getBuffer())) {
            this.buffer = string;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isNoFilter() {
        return this.isNoFilter;
    }
}

