/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.links;

import com.adesoft.struct.links.ConsecutiveInfo;
import com.adesoft.struct.links.NsdInfo;
import com.adesoft.struct.links.SequenceInfo;
import java.io.Serializable;

public class CreateLink
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final SequenceInfo sequenceInfo;
    private final NsdInfo nsdInfo;
    private final ConsecutiveInfo consecutiveInfo;
    private final boolean active;
    private final boolean continuous;
    private final short betweenValue;
    public static final CreateLink DEFAULT = new CreateLink(SequenceInfo.DEFAULT, false, false, 0);

    public CreateLink(SequenceInfo sequenceInfo, boolean bl, boolean bl2, short s) {
        this.sequenceInfo = sequenceInfo;
        this.nsdInfo = null;
        this.consecutiveInfo = null;
        this.active = bl;
        this.continuous = bl2;
        this.betweenValue = s;
    }

    public CreateLink(int n) {
        if (3 == n) {
            this.sequenceInfo = SequenceInfo.DEFAULT;
            this.nsdInfo = null;
            this.consecutiveInfo = null;
        } else if (1 == n) {
            this.sequenceInfo = null;
            this.nsdInfo = NsdInfo.DEFAULT;
            this.consecutiveInfo = null;
        } else if (4 == n) {
            this.sequenceInfo = null;
            this.nsdInfo = null;
            this.consecutiveInfo = ConsecutiveInfo.DEFAULT;
        } else {
            throw new IllegalArgumentException("Invalid link type : " + n);
        }
        this.active = true;
        this.continuous = false;
        this.betweenValue = 0;
    }

    public CreateLink(SequenceInfo sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
        this.nsdInfo = null;
        this.consecutiveInfo = null;
        this.active = true;
        this.continuous = false;
        this.betweenValue = 0;
    }

    public CreateLink(boolean bl, boolean bl2, short s, NsdInfo nsdInfo) {
        this.sequenceInfo = null;
        this.nsdInfo = nsdInfo;
        this.consecutiveInfo = null;
        this.active = bl;
        this.continuous = bl2;
        this.betweenValue = s;
    }

    public CreateLink(boolean bl, boolean bl2, short s, ConsecutiveInfo consecutiveInfo) {
        this.sequenceInfo = null;
        this.nsdInfo = null;
        this.consecutiveInfo = consecutiveInfo;
        this.active = bl;
        this.continuous = bl2;
        this.betweenValue = s;
    }

    public CreateLink(boolean bl, boolean bl2, short s, SequenceInfo sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
        this.nsdInfo = null;
        this.consecutiveInfo = null;
        this.active = bl;
        this.continuous = bl2;
        this.betweenValue = s;
    }

    public SequenceInfo getSequenceInfo() {
        return this.sequenceInfo;
    }

    public NsdInfo getNsdInfo() {
        return this.nsdInfo;
    }

    public ConsecutiveInfo getConsecutiveInfo() {
        return this.consecutiveInfo;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public boolean isBetweenCourse() {
        return this.betweenValue == 0;
    }

    public boolean isBetweenRep() {
        return this.betweenValue == 1;
    }

    public boolean isBetweenRepNext() {
        return this.betweenValue == 3;
    }

    public boolean isBetweenRepPred() {
        return this.betweenValue == 4;
    }

    public boolean isBetweenSess() {
        return this.betweenValue == 2;
    }

    public boolean isBetweenSessNext() {
        return this.betweenValue == 5;
    }

    public boolean isBetweenSessPred() {
        return this.betweenValue == 6;
    }

    public int getType() {
        if (null != this.sequenceInfo) {
            return 3;
        }
        if (null != this.nsdInfo) {
            return 1;
        }
        if (null != this.consecutiveInfo) {
            return 4;
        }
        throw new IllegalArgumentException("Wrong link type");
    }
}

