/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.links;

import java.io.Serializable;

public final class NsdInfo
implements Serializable {
    private static final long serialVersionUID = 520L;
    public static final int SLOT = 0;
    public static final int DAY = 1;
    public static final int WEEK = 2;
    public static final int TIME = 3;
    public static final int WEEKDAY = 4;
    public static final int NOTSAME = 0;
    public static final int SAME = 1;
    private final int mode;
    private final int unit;
    private static final NsdInfo[][] allInfo = new NsdInfo[2][5];
    public static final int DEFAULT_MODE = 0;
    public static final int DEFAULT_UNIT = 1;
    public static final NsdInfo DEFAULT;

    private NsdInfo(int n, int n2) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Wrong NSD mode : " + n);
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("Wrong NSD unit : " + n2);
        }
        this.mode = n;
        this.unit = n2;
    }

    public static final NsdInfo get(int n, int n2) {
        return allInfo[n][n2];
    }

    public int getMode() {
        return this.mode;
    }

    public int getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return this.mode + 100 * this.unit;
    }

    public boolean equals(Object object) {
        if (object instanceof NsdInfo) {
            NsdInfo nsdInfo = (NsdInfo)object;
            return this.mode == nsdInfo.mode && this.unit == nsdInfo.unit;
        }
        return false;
    }

    public String toString() {
        return "NSD : mode=" + this.getMode() + ", unit=" + this.getUnit() + ",between=";
    }

    static {
        NsdInfo.allInfo[0][0] = new NsdInfo(0, 0);
        NsdInfo.allInfo[0][1] = new NsdInfo(0, 1);
        NsdInfo.allInfo[0][2] = new NsdInfo(0, 2);
        NsdInfo.allInfo[0][3] = new NsdInfo(0, 3);
        NsdInfo.allInfo[0][4] = new NsdInfo(0, 4);
        NsdInfo.allInfo[1][0] = new NsdInfo(1, 0);
        NsdInfo.allInfo[1][1] = new NsdInfo(1, 1);
        NsdInfo.allInfo[1][2] = new NsdInfo(1, 2);
        NsdInfo.allInfo[1][3] = new NsdInfo(1, 3);
        NsdInfo.allInfo[1][4] = new NsdInfo(1, 4);
        DEFAULT = allInfo[0][1];
    }
}

