/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.links;

import com.adesoft.collections.MyHashTable;
import java.io.Serializable;

public final class SequenceInfo
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final MyHashTable values = new MyHashTable();
    private final byte mode;
    private final int atLeast;
    private final int atMost;
    private final byte atLeastUnit;
    private final byte atMostUnit;
    private final boolean discrete;
    private final boolean countVacationDays;
    private final boolean countVacationSlots;
    public static final byte PRECEDE = 0;
    public static final byte FOLLOW = 1;
    public static final byte APART = 2;
    public static final byte SEQUENCE = 3;
    public static final byte SLOT = 0;
    public static final byte DAY = 1;
    public static final byte WEEK = 2;
    public static final byte MINUTE = 3;
    public static final byte HOUR = 4;
    public static final boolean DEFAULT_VACATION_DAYS = false;
    public static final boolean DEFAULT_VACATION_SLOTS = false;
    public static final boolean DEFAULT_DISCRETE = true;
    public static final SequenceInfo DEFAULT = new SequenceInfo(0, 0, 1, 0, 2, true, false, false);
    public static final SequenceInfo DEFAULT_FOLLOW = new SequenceInfo(1, 0, 1, 0, 2, true, false, false);

    private SequenceInfo(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        this.mode = (byte)n;
        this.atLeast = n2;
        this.atMost = n3;
        this.atLeastUnit = (byte)n4;
        this.atMostUnit = (byte)n5;
        this.discrete = bl;
        this.countVacationDays = bl2;
        this.countVacationSlots = bl3;
    }

    public static synchronized SequenceInfo get(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        int n6 = (bl ? 1 : 0) + (bl3 ? 1 : 0) * 2 + (bl2 ? 1 : 0) * 4 + 8 * n + 32 * n4 + 256 * n5 + 2048 * n2 + 2048000 * n3;
        SequenceInfo sequenceInfo = (SequenceInfo)values.get(n6);
        if (null == sequenceInfo) {
            sequenceInfo = new SequenceInfo(n, n2, n3, n4, n5, bl, bl2, bl3);
            values.put(n6, (Object)sequenceInfo);
        }
        return sequenceInfo;
    }

    public int getAtLeast() {
        return this.atLeast;
    }

    public byte getAtLeastUnit() {
        return this.atLeastUnit;
    }

    public int getAtMost() {
        return this.atMost;
    }

    public byte getAtMostUnit() {
        return this.atMostUnit;
    }

    public byte getMode() {
        return this.mode;
    }

    public byte getType() {
        return this.mode;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public boolean isCountVacationSlots() {
        return this.countVacationSlots;
    }

    public boolean isCountVacationDays() {
        return this.countVacationDays;
    }

    public boolean sameWeek() {
        return false;
    }

    public boolean sameDay() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof SequenceInfo) {
            SequenceInfo sequenceInfo = (SequenceInfo)object;
            return this.mode == sequenceInfo.mode && this.discrete == sequenceInfo.discrete && this.countVacationSlots == sequenceInfo.countVacationSlots && this.countVacationDays == sequenceInfo.countVacationDays && this.atLeast == sequenceInfo.atLeast && this.atMost == sequenceInfo.atMost && this.atLeastUnit == sequenceInfo.atLeastUnit && this.atMostUnit == sequenceInfo.atMostUnit;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Sequence : ");
        stringBuffer.append("Mode=" + this.mode + ",");
        stringBuffer.append("MinGap=" + this.atLeast + ",");
        stringBuffer.append("MaxGap=" + this.atMost + ",");
        stringBuffer.append("MinUnit=" + this.atLeastUnit + ",");
        stringBuffer.append("MaxUnit=" + this.atMostUnit + ",");
        stringBuffer.append("Discrete=" + this.discrete + ",");
        stringBuffer.append("VacationDays=" + this.countVacationDays + ",");
        stringBuffer.append("VacationSlots=" + this.countVacationSlots);
        return stringBuffer.toString();
    }
}

