/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.participants;

import com.adesoft.arrays.IntArray;
import com.adesoft.struct.Entity;
import com.adesoft.struct.configurations.Configuration;
import com.adesoft.struct.participants.NodeAnd;
import com.adesoft.struct.participants.NodeOrEntity;
import java.io.Serializable;
import java.util.Arrays;

public abstract class NodeAndOr
implements Serializable,
Comparable {
    private static final long serialVersionUID = 520L;
    public static final int NODE_AND = 1;
    public static final int NODE_OR = 2;
    public static final int NODE_ENTITY = 3;
    public static final int NODE_LIST = 4;
    public static final int EDIT_ALL = 0;
    public static final int EDIT_OR_ENTITY_LEAVES = 1;
    public static final int EDIT_WORKFLOW_LEAVES = 2;
    public static final int EDIT_ANDS = 3;
    protected final int id;
    protected NodeAndOr[] children;
    protected int quantity;
    protected NodeAndOr parent;
    protected boolean editable;

    protected NodeAndOr(int n, int n2) {
        this.id = n;
        this.quantity = n2;
        this.editable = false;
        this.children = new NodeAndOr[0];
    }

    public void add(NodeAndOr nodeAndOr) {
        if (null != nodeAndOr) {
            int n = this.children.length;
            NodeAndOr[] nodeAndOrArray = new NodeAndOr[n + 1];
            System.arraycopy(this.children, 0, nodeAndOrArray, 0, n);
            nodeAndOrArray[n] = nodeAndOr;
            this.children = nodeAndOrArray;
            nodeAndOr.setParent(this);
        }
    }

    public String dump(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            for (n2 = 1; n2 < n; ++n2) {
                stringBuffer.append("    ");
            }
            if (2 == this.getType()) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append(this.toString());
                if (this.isWorkflow()) {
                    stringBuffer.append(" *");
                }
            }
            if (0 != this.getQuantity()) {
                stringBuffer.append(" (");
                stringBuffer.append(this.getQuantity());
                stringBuffer.append(')');
            }
            stringBuffer.append('\n');
        }
        n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(this.getChildAt(i).dump(n + 1));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NodeAndOr) {
            NodeAndOr nodeAndOr = (NodeAndOr)object;
            return this.id == nodeAndOr.id && this.quantity == nodeAndOr.quantity && this.children == nodeAndOr.children;
        }
        return false;
    }

    public NodeAndOr getAndOrParent() {
        if (this.getType() != 2 && this.getParent() != null) {
            return this.getParent().getAndOrParent();
        }
        return this;
    }

    public final NodeAndOr getChildAt(int n) {
        return this.children[n];
    }

    public final int getChildCount() {
        return null != this.children ? this.children.length : 0;
    }

    public void getChildrensEntityNodes(IntArray intArray, IntArray intArray2) {
        if (null != intArray) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                NodeAndOr nodeAndOr = this.getChildAt(i);
                if (nodeAndOr.getType() == 2 || nodeAndOr.getType() == 3 && !nodeAndOr.isLeaf()) {
                    nodeAndOr.getChildrensEntityNodes(intArray, intArray2);
                    continue;
                }
                intArray.add(nodeAndOr.getId());
                if (null == intArray2) continue;
                intArray2.add(nodeAndOr.getQuantity());
            }
        }
    }

    public Entity getEntity() {
        return null;
    }

    public Configuration getList() {
        return null;
    }

    public int getEntityType() {
        return -1;
    }

    public int getId() {
        return this.id;
    }

    public static final NodeAnd getNewRoot() {
        return new NodeAnd(-1, 1);
    }

    public final NodeAndOr getNode(int n) {
        if (n == this.id) {
            return this;
        }
        if (!this.isLeaf()) {
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                NodeAndOr nodeAndOr = this.getChildAt(i).getNode(n);
                if (null == nodeAndOr) continue;
                return nodeAndOr;
            }
        }
        return null;
    }

    public NodeOrEntity getNode(Entity entity) {
        if (this.getEntity() == entity) {
            return (NodeOrEntity)this;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            NodeOrEntity nodeOrEntity = this.getChildAt(i).getNode(entity);
            if (null == nodeOrEntity) continue;
            return nodeOrEntity;
        }
        return null;
    }

    public NodeAndOr getParent() {
        return this.parent;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public abstract int getType();

    public int hashCode() {
        return this.id;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public abstract boolean isLeaf();

    public abstract boolean isWorkflow();

    public boolean isWorkflowOR() {
        return false;
    }

    public boolean remove(NodeAndOr nodeAndOr) {
        int n = -1;
        int n2 = this.children.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.children[i].equals(nodeAndOr)) continue;
            n = i;
            this.children[i] = null;
            break;
        }
        if (-1 != n) {
            NodeAndOr[] nodeAndOrArray = new NodeAndOr[n2 - 1];
            for (int i = 0; i < n2; ++i) {
                if (i < n) {
                    nodeAndOrArray[i] = this.children[i];
                    continue;
                }
                if (i <= n) continue;
                nodeAndOrArray[i - 1] = this.children[i];
            }
            this.children = nodeAndOrArray;
            return true;
        }
        return false;
    }

    public void replace(NodeAndOr nodeAndOr, NodeAndOr nodeAndOr2) {
        for (int i = this.children.length - 1; i >= 0; --i) {
            if (!this.children[i].equals(nodeAndOr)) continue;
            this.children[i] = nodeAndOr2;
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setParent(NodeAndOr nodeAndOr) {
        this.parent = nodeAndOr;
    }

    public void setQuantity(int n) {
        this.quantity = n;
    }

    public abstract void setWorkflow(boolean var1, boolean var2);

    public abstract int compareTo(Object var1);

    public final void sortByName() {
        if (null != this.children) {
            Arrays.sort(this.children);
            for (int i = this.children.length - 1; i >= 0; --i) {
                this.children[i].sortByName();
            }
        }
    }
}

