/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.participants;

import com.adesoft.struct.participants.NodeAndOr;
import com.adesoft.struct.participants.NodeGroup;
import java.io.Serializable;

public final class NodeOr
extends NodeGroup
implements Serializable {
    private static final long serialVersionUID = 520L;
    private int entityType = -1;
    private boolean continuous;

    public NodeOr(int n, int n2, boolean bl) {
        super(n, n2);
        this.continuous = bl;
    }

    @Override
    public void add(NodeAndOr nodeAndOr) {
        super.add(nodeAndOr);
        if (null != nodeAndOr) {
            this.entityType = nodeAndOr.getEntityType();
        }
    }

    public static final NodeOr createVirtualNode() {
        return new NodeOr(-1, 1, false);
    }

    @Override
    public int getEntityType() {
        return this.entityType;
    }

    @Override
    public int getType() {
        return 2;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public boolean isVirtual() {
        return -1 == this.getId();
    }

    @Override
    public boolean isWorkflowOR() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            NodeAndOr nodeAndOr = this.getChildAt(i);
            if (!nodeAndOr.isWorkflow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(NodeAndOr nodeAndOr) {
        boolean bl = super.remove(nodeAndOr);
        if (0 == this.getChildCount()) {
            this.entityType = -1;
        }
        return bl;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public void setEntityType(int n) {
        this.entityType = n;
    }

    public String toString() {
        return "OR";
    }

    @Override
    public boolean isWorkflow() {
        return this.isWorkflowOR();
    }

    @Override
    public int compareTo(Object object) {
        NodeAndOr nodeAndOr = (NodeAndOr)object;
        if (2 != nodeAndOr.getType()) {
            return 1;
        }
        return this.getId() - this.getId();
    }
}

