/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.participants;

import com.adesoft.log.Category;
import com.adesoft.struct.Entity;
import com.adesoft.struct.Field;
import com.adesoft.struct.participants.NodeAndOr;
import com.adesoft.struct.participants.NodeOrChild;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.Set;

public final class NodeOrEntity
extends NodeOrChild
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.NodeOrEntity");
    protected Entity entity;
    private int oid;
    private int type;
    private String name;
    private String path;
    private boolean isAGroup;
    private Set<Set<Integer>> costsIds;
    private int used;

    public NodeOrEntity(int n, Entity entity, int n2, int n3, double d, String string, boolean bl, boolean bl2) {
        super(n, n3, d, string, bl, bl2);
        this.entity = entity;
        this.oid = n2;
        this.used = 0;
        try {
            this.type = entity.getEntityType();
            this.name = entity.getName();
            this.isAGroup = entity.isAGroup();
            this.path = entity.getPath();
        }
        catch (RemoteException remoteException) {
            LOG.debug((Object)remoteException);
        }
    }

    public NodeOrEntity(int n, Entity entity, int n2, int n3, double d, String[] stringArray, boolean bl, boolean bl2) {
        this(n, entity, n2, n3, d, stringArray, bl, bl2, null);
    }

    public NodeOrEntity(int n, Entity entity, int n2, int n3, double d, String[] stringArray, boolean bl, boolean bl2, Set<Set<Integer>> set) {
        super(n, n3, d, stringArray, bl, bl2);
        this.entity = entity;
        this.oid = n2;
        this.costsIds = set;
        this.used = 0;
        try {
            this.type = entity.getEntityType();
            this.name = entity.getName();
            this.isAGroup = entity.isAGroup();
            this.path = entity.getPath();
        }
        catch (RemoteException remoteException) {
            LOG.debug((Object)remoteException);
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public int getEntityType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int getType() {
        return 3;
    }

    public int getUsed() {
        return this.used;
    }

    @Override
    public boolean isLeaf() {
        return !this.isAGroup;
    }

    public boolean isOrChild() {
        return null != this.getParent() && this.getParent().getType() == 2;
    }

    public void setEntity(Entity entity) throws RemoteException {
        this.entity = entity;
        this.name = entity.getName();
        this.type = entity.getEntityType();
        this.isAGroup = entity.isAGroup();
        this.path = entity.getPath();
        this.oid = entity.getOid();
    }

    public void setUsed(int n) {
        this.used = n;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Object object) {
        NodeAndOr nodeAndOr = (NodeAndOr)object;
        if (3 != nodeAndOr.getType()) {
            return -1;
        }
        try {
            return this.getEntity().getName().compareTo(nodeAndOr.getEntity().getName());
        }
        catch (RemoteException remoteException) {
            return this.getId() - nodeAndOr.getId();
        }
    }

    public static Comparator getComparator(Field field, boolean bl) {
        return null;
    }

    public int getOid() {
        return this.oid;
    }

    public Set<Set<Integer>> getCostsIds() {
        return this.costsIds;
    }
}

