/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.participants;

import com.adesoft.log.Category;
import com.adesoft.struct.configurations.Configuration;
import com.adesoft.struct.participants.NodeAndOr;
import com.adesoft.struct.participants.NodeOrChild;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class NodeOrList
extends NodeOrChild
implements Serializable,
Comparable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.struct.participants.NodeOrList");
    protected Configuration list;
    private int type;
    private String name;

    public NodeOrList(int n, Configuration configuration, int n2, double d, String[] stringArray, boolean bl, boolean bl2) {
        super(n, n2, d, stringArray, bl, bl2);
        this.list = configuration;
        try {
            this.type = this.getListType(configuration);
            this.name = configuration.getName();
        }
        catch (JDOMException jDOMException) {
            LOG.debug((Object)jDOMException);
        }
    }

    public NodeOrList(int n, Configuration configuration, int n2, double d, String string, boolean bl, boolean bl2) {
        super(n, n2, d, string, bl, bl2);
        this.list = configuration;
        try {
            this.type = this.getListType(configuration);
            this.name = configuration.getName();
        }
        catch (JDOMException jDOMException) {
            LOG.debug((Object)jDOMException);
        }
    }

    private int getListType(Configuration configuration) throws JDOMException {
        Document document = new SAXBuilder().build((Reader)new StringReader(configuration.getBuffer()));
        Element element = document.getRootElement();
        Element[] elementArray = element.getChildrenArray();
        for (int i = 0; i < elementArray.length; ++i) {
            Element[] elementArray2 = elementArray[i].getChildrenArray();
            for (int j = 0; j < elementArray2.length; ++j) {
                String string = elementArray2[j].getAttribute("name").getValue();
                if ("IS_STUDENT".equals(string)) {
                    return 1;
                }
                if ("IS_TEACHER".equals(string)) {
                    return 2;
                }
                if ("IS_CLASSROOM".equals(string)) {
                    return 3;
                }
                if ("IS_RESOURCE".equals(string)) {
                    return 4;
                }
                if ("IS_CATEGORY5".equals(string)) {
                    return 5;
                }
                if ("IS_CATEGORY6".equals(string)) {
                    return 6;
                }
                if ("IS_CATEGORY7".equals(string)) {
                    return 7;
                }
                if (!"IS_CATEGORY8".equals(string)) continue;
                return 8;
            }
        }
        return -1;
    }

    @Override
    public Configuration getList() {
        return this.list;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getEntityType() {
        return this.type;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    private String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Object object) {
        NodeAndOr nodeAndOr = (NodeAndOr)object;
        if (4 != nodeAndOr.getType()) {
            return -1;
        }
        return this.getName().compareTo(nodeAndOr.getList().getName());
    }

    public String toString() {
        return this.name;
    }
}

