/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.timeframes;

import com.adesoft.javaengine.InfoConflict;
import java.io.Serializable;
import java.rmi.Remote;

public final class AdvancedBehaviour
implements Serializable,
Remote {
    private static final long serialVersionUID = 520L;
    private byte availabilityLevel = 0;
    private InfoConflict[] warnings = null;

    public AdvancedBehaviour(byte by) {
        this.availabilityLevel = by;
        this.warnings = null;
    }

    public AdvancedBehaviour(AdvancedBehaviour advancedBehaviour) {
        this.availabilityLevel = advancedBehaviour.getAvailabilityLevel();
        this.warnings = (InfoConflict[])advancedBehaviour.getWarnings().clone();
    }

    public AdvancedBehaviour() {
        this.availabilityLevel = 0;
        this.warnings = null;
    }

    public byte getAvailabilityLevel() {
        return this.availabilityLevel;
    }

    public void setAvailabilityLevel(byte by) {
        this.availabilityLevel = by;
    }

    public void setWarnings(InfoConflict[] infoConflictArray) {
        this.warnings = this.translateConflictsToWarnings(infoConflictArray);
    }

    private InfoConflict[] translateConflictsToWarnings(InfoConflict[] infoConflictArray) {
        if (null != infoConflictArray && infoConflictArray.length > 0) {
            for (int i = 0; i < infoConflictArray.length; ++i) {
                infoConflictArray[i].setType(-infoConflictArray[i].getType());
            }
        }
        return infoConflictArray;
    }

    public InfoConflict[] getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        if (null != this.warnings) {
            return this.warnings.length > 0;
        }
        return false;
    }
}

