/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.timeframes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Adler32;

public final class Available
implements Serializable {
    private static final long serialVersionUID = 520L;
    public static final int NB_PRIORITIES = 7;
    public static final byte MAX = 3;
    public static final byte MOY = 2;
    public static final byte MIN = 1;
    public static final byte NOT = 0;
    public static final byte SLOT = 4;
    public static final byte DAY = 5;
    public static final byte WARN = 6;
    private static final int[] priorities = new int[7];
    public static final byte[][] inter;
    private static final boolean[] valid;
    private final byte[] dispo;

    private Available(int n, byte by) {
        this.dispo = new byte[n];
        if (0 != by) {
            Arrays.fill(this.dispo, by);
        }
    }

    private Available(Available available) {
        this.dispo = (byte[])available.dispo.clone();
    }

    public Available copy() {
        return new Available(this);
    }

    public byte get(int n) {
        return this.dispo[n];
    }

    public void set(int n, byte by) {
        this.dispo[n] = by;
    }

    public void setMostAvailable(Available available, int n) {
        if (Available.getPriority(available.get(n)) < Available.getPriority(this.get(n))) {
            this.set(n, available.get(n));
        }
    }

    public void setLeastAvailable(int n, byte by) {
        if (Available.getPriority(by) > Available.getPriority(this.get(n))) {
            this.set(n, by);
        }
    }

    public int size() {
        return this.dispo.length;
    }

    public void resetToMax(int n) {
        this.dispo[n] = 3;
    }

    public void resetToMax() {
        Arrays.fill(this.dispo, (byte)3);
    }

    public boolean isAvailable(int n) {
        return valid[this.dispo[n]];
    }

    public boolean[] isAvailable() {
        boolean[] blArray = new boolean[this.dispo.length];
        for (int i = blArray.length - 1; i >= 0; --i) {
            blArray[i] = this.isAvailable(i);
        }
        return blArray;
    }

    public boolean hasAvailable() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.isAvailable(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isVacation(int n) {
        return 4 == this.dispo[n] || 5 == this.dispo[n];
    }

    public void clear(int n, int n2) {
        Arrays.fill(this.dispo, n, n2, (byte)0);
    }

    public void clear(int n) {
        this.dispo[n] = 0;
    }

    public static Available getAvailable(int n) {
        return new Available(n, 3);
    }

    public static Available getNotAvailable(int n) {
        return new Available(n, 0);
    }

    public static final int getPriority(byte by) {
        try {
            return priorities[by];
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Invalid level : " + by);
        }
    }

    public static final boolean isNotAvailable(byte by) {
        return !valid[by];
    }

    public static final boolean isAvailable(byte by) {
        return valid[by];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dispo.length; ++i) {
            stringBuffer.append(this.dispo[i]);
        }
        return stringBuffer.toString();
    }

    public static final void checkLevel(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid level : " + by);
            }
        }
    }

    public static final byte intersectLevels(byte by, byte by2) {
        if (by < 0 || by2 < 0) {
            return Available.shadedLevel(inter[Available.plainLevel(by)][Available.plainLevel(by2)]);
        }
        return inter[by][by2];
    }

    public static final boolean isValidLevel(byte by) {
        return valid[by];
    }

    private static final byte plainLevel(byte by) {
        return by < 0 ? (byte)(-by) : by;
    }

    private static final byte shadedLevel(byte by) {
        return by <= 0 ? by : (byte)(-by);
    }

    public long getCRC() {
        Adler32 adler32 = new Adler32();
        adler32.update(this.dispo, 0, this.dispo.length);
        return adler32.getValue();
    }

    public int hashCode() {
        long l = this.getCRC();
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Available) {
            return Arrays.equals(this.dispo, ((Available)object).dispo);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        int n = 1000000;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        byte[] byArray = new byte[100];
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            arrayList.add(byArray.clone());
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l);
        long l3 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(new byte[100]);
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l4 - l3);
    }

    public String toHex() {
        int n = this.dispo.length;
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            if ((this.dispo[i] & 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Long.toString(this.dispo[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    public byte[] getData() {
        return this.dispo;
    }

    static {
        Available.priorities[0] = 4;
        Available.priorities[1] = 2;
        Available.priorities[2] = 1;
        Available.priorities[3] = 0;
        Available.priorities[4] = 5;
        Available.priorities[5] = 6;
        Available.priorities[6] = 3;
        inter = new byte[7][7];
        Available.inter[3][3] = 3;
        Available.inter[3][2] = 2;
        Available.inter[3][1] = 1;
        Available.inter[3][0] = -3;
        Available.inter[3][4] = -3;
        Available.inter[3][5] = -3;
        Available.inter[3][6] = 6;
        Available.inter[2][3] = 2;
        Available.inter[2][2] = 2;
        Available.inter[2][1] = 1;
        Available.inter[2][0] = -2;
        Available.inter[2][4] = -2;
        Available.inter[2][5] = -2;
        Available.inter[2][6] = 6;
        Available.inter[1][3] = 1;
        Available.inter[1][2] = 1;
        Available.inter[1][1] = 1;
        Available.inter[1][0] = -1;
        Available.inter[1][4] = -1;
        Available.inter[1][5] = -1;
        Available.inter[1][6] = 6;
        Available.inter[0][3] = -3;
        Available.inter[0][2] = -2;
        Available.inter[0][1] = -1;
        Available.inter[0][0] = 0;
        Available.inter[0][4] = -4;
        Available.inter[0][5] = -5;
        Available.inter[0][6] = 0;
        Available.inter[4][3] = -3;
        Available.inter[4][2] = -2;
        Available.inter[4][1] = -1;
        Available.inter[4][0] = -4;
        Available.inter[4][4] = 4;
        Available.inter[4][5] = 5;
        Available.inter[4][6] = -6;
        Available.inter[5][3] = -3;
        Available.inter[5][2] = -2;
        Available.inter[5][1] = -1;
        Available.inter[5][0] = -5;
        Available.inter[5][4] = 5;
        Available.inter[5][5] = 5;
        Available.inter[5][6] = -6;
        Available.inter[6][3] = 6;
        Available.inter[6][2] = 6;
        Available.inter[6][1] = 6;
        Available.inter[6][0] = 0;
        Available.inter[6][4] = -6;
        Available.inter[6][5] = -6;
        Available.inter[6][6] = 6;
        valid = new boolean[7];
        Available.valid[3] = true;
        Available.valid[2] = true;
        Available.valid[1] = true;
        Available.valid[0] = false;
        Available.valid[4] = false;
        Available.valid[5] = false;
        Available.valid[6] = true;
    }
}

