/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.struct.timeframes;

import com.adesoft.struct.AdeDate;
import com.adesoft.struct.timeframes.Available;
import java.io.Serializable;
import java.util.ArrayList;

public final class FrameValues
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final int nbDays;
    private final int nbSlots;
    private final int nbWeeks;
    private final int slotSize;
    private final Available previousValues;
    private final Available newValues;

    public FrameValues(int n, int n2, int n3, int n4, Available available) {
        this.nbWeeks = n;
        this.nbDays = n2;
        this.nbSlots = n3;
        this.slotSize = n4;
        this.previousValues = available;
        this.newValues = available.copy();
    }

    public int size() {
        return this.previousValues.size();
    }

    private final int getIndex(int n, int n2, int n3) {
        return n * this.nbDays * this.nbSlots + n2 * this.nbSlots + n3;
    }

    public int getDaySize() {
        return this.nbSlots;
    }

    public byte getLevel(int n, int n2, int n3) {
        return this.newValues.get(n * this.nbDays * this.nbSlots + n2 * this.nbSlots + n3);
    }

    public byte getLevel(int n) {
        return this.newValues.get(n);
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public Available getValues() {
        return this.newValues;
    }

    public int getWeekSize() {
        return this.nbDays;
    }

    public int getYearSize() {
        return this.nbWeeks;
    }

    public void intersectLevel(int n, int n2, int n3, byte by) {
        this.intersectLevel(this.getIndex(n, n2, n3), by);
    }

    public void intersectLevel(int n, byte by) {
        byte by2 = this.newValues.get(n);
        if (by != by2) {
            byte by3 = Available.intersectLevels(by2, by);
            this.previousValues.set(n, by3);
            this.newValues.set(n, by3);
        }
    }

    public boolean isModified(int n, int n2, int n3) {
        int n4 = this.getIndex(n, n2, n3);
        return this.newValues.get(n4) != this.previousValues.get(n4);
    }

    public boolean isModified(int n) {
        return this.newValues.get(n) != this.previousValues.get(n);
    }

    public boolean isModified() {
        return !this.previousValues.equals(this.newValues);
    }

    public void setLevel(int n, int n2, byte by) {
        int n3 = n * this.nbDays * this.nbSlots + n2;
        this.newValues.set(n3, by);
    }

    public boolean wasACellCleared() {
        int n = this.newValues.size();
        for (int i = n - 1; i >= 0; --i) {
            if (this.newValues.get(i) == this.previousValues.get(i) || Available.isAvailable((byte)Math.abs(this.getLevel(i))) && !this.previousValues.isVacation(i)) continue;
            return true;
        }
        return false;
    }

    public int getFirstUsedPosition() {
        int n = this.newValues.size();
        for (int i = 0; i < n; ++i) {
            if (!Available.isAvailable((byte)Math.abs(this.getLevel(i)))) continue;
            return i;
        }
        return -1;
    }

    public int getLastUsedPosition() {
        int n = this.newValues.size();
        for (int i = n - 1; i >= 0; --i) {
            if (!Available.isAvailable((byte)Math.abs(this.getLevel(i)))) continue;
            return i;
        }
        return -1;
    }

    public AdeDate getDate(int n) {
        if (-1 == n) {
            return null;
        }
        int n2 = n % this.nbSlots;
        int n3 = (n /= this.nbSlots) % this.nbDays;
        int n4 = n / this.nbDays;
        return new AdeDate(n4, n3, n2);
    }

    public boolean isShaded(int n) {
        if (n >= 0 && n < this.newValues.size()) {
            return this.newValues.get(n) < 0;
        }
        return false;
    }

    private int getIndex(AdeDate adeDate) {
        int n = adeDate.getWeek();
        int n2 = adeDate.getDay();
        int n3 = adeDate.getHour();
        return n * (this.nbDays * this.nbSlots) + n2 * this.nbSlots + n3;
    }

    public void setRange(AdeDate adeDate, AdeDate adeDate2) {
        int n = this.newValues.size();
        int n2 = 0;
        int n3 = n;
        if (null != adeDate) {
            n2 = this.getIndex(adeDate);
        }
        if (null != adeDate2) {
            n3 = this.getIndex(new AdeDate(adeDate2.getWeek(), adeDate2.getDay() + 1, 0));
        }
        for (int i = 0; i < n; ++i) {
            if (i >= n2 && i < n3) {
                this.newValues.resetToMax(i);
                continue;
            }
            this.newValues.clear(i);
        }
    }

    public ArrayList<Integer[]> getDifferences() {
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        byte[] byArray = this.previousValues.getData();
        byte[] byArray2 = this.newValues.getData();
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.nbWeeks * this.nbDays * this.nbSlots; ++i) {
            boolean bl3;
            if (i != 0) {
                bl = byArray2[i - 1] != byArray2[i];
            }
            boolean bl4 = bl3 = byArray[i] != byArray2[i];
            if (n == -1 && bl3) {
                n = i;
                n2 = i;
                continue;
            }
            if (n == -1) continue;
            if (byArray2[i] == 0 || byArray2[i] == 5 || byArray2[i] == 4 || byArray[i] == 0 || byArray[i] == 5 || byArray[i] == 4) {
                bl2 = true;
            }
            if (!bl && bl3) {
                n2 = i;
                continue;
            }
            Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n2)};
            if (bl2) {
                arrayList.add(integerArray);
                bl2 = false;
            }
            if (bl3) {
                n = i;
                n2 = i;
                continue;
            }
            n = -1;
            n2 = -1;
        }
        return arrayList;
    }
}

