/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.log.Category;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.Header;
import com.adesoft.timetable.MyIterator;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.ToolTipBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public abstract class AbstractLegend
extends JPanel {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.timetable.AbstractLegend");
    protected static final Color COLOR_HIGHLIGHT = new Color(255, 75, 75);
    private final Axis axis;
    private EtGrid et;
    private Preferences pref;
    private final List toolTips = new ArrayList();

    public AbstractLegend(Axis axis) {
        this.axis = axis;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected final Graphics2D getGraphics2D() {
        return (Graphics2D)this.getGraphics();
    }

    protected final int getWidth(Graphics2D graphics2D, String string) {
        try {
            if (null == string || 0 == string.length()) {
                string = " ";
            }
            TextLayout textLayout = new TextLayout(string, this.getPreferences().getFontLegend(), graphics2D.getFontRenderContext());
            return (int)textLayout.getAdvance();
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable);
            return 0;
        }
    }

    protected final Preferences getPreferences() {
        return this.pref;
    }

    protected final EtGrid getGrid() {
        return this.et;
    }

    protected final Axis getAxis() {
        return this.axis;
    }

    final Header getRoot() {
        if (null == this.getGrid()) {
            return null;
        }
        if (Axis.X == this.getAxis()) {
            return this.getGrid().getHRoot();
        }
        return this.getGrid().getVRoot();
    }

    protected final int getNColumns() {
        return null != this.getGrid() ? this.getGrid().getNbColumns() : 0;
    }

    protected final int getNRows() {
        return null != this.getGrid() ? this.getGrid().getVSize() : 0;
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.clearToolTips();
        if (0 != n && 0 != n2) {
            this.render((Graphics2D)graphics, n, n2);
        }
    }

    protected static void drawRecAndText(Graphics2D graphics2D, int n, int n2, int n3, int n4, String string, String string2, boolean bl, AbstractLegend abstractLegend, Color color, boolean bl2) {
        AbstractLegend.drawRec(graphics2D, n, n2, n3, n4, bl, abstractLegend.getAxis(), bl2);
        AbstractLegend.drawText(graphics2D, n, n2, n3, n4, string, string2, abstractLegend, bl ? Color.black : color);
    }

    protected static void drawRec(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, Axis axis, boolean bl2) {
        if (bl) {
            graphics2D.setColor(COLOR_HIGHLIGHT);
            graphics2D.fillRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics2D.drawLine(n, n2, n + n3, n2);
    }

    private void registerToolTip(String string, Rectangle rectangle) {
        this.toolTips.add(new ToolTipBox(rectangle, string));
    }

    private void clearToolTips() {
        this.toolTips.clear();
    }

    protected static void drawText(Graphics2D graphics2D, int n, int n2, int n3, int n4, String string, String string2, AbstractLegend abstractLegend, Color color) {
        if (null != abstractLegend) {
            abstractLegend.registerToolTip(string2, new Rectangle(n, n2, n3, n4));
        }
        if (n3 > 4) {
            try {
                if (null != string && 0 != string.length()) {
                    MyIterator myIterator = new MyIterator();
                    FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                    AttributedString attributedString = new AttributedString(string);
                    attributedString.addAttribute(TextAttribute.FONT, graphics2D.getFont());
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), myIterator, fontRenderContext);
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(n3);
                    if (null != textLayout) {
                        double d = 0.0;
                        if (graphics2D.getStroke() instanceof BasicStroke) {
                            d = ((BasicStroke)graphics2D.getStroke()).getLineWidth();
                        }
                        double d2 = textLayout.getAdvance();
                        double d3 = textLayout.getBounds().getHeight();
                        if (d3 > (double)(n4 - 2)) {
                            AffineTransform affineTransform = graphics2D.getTransform();
                            double d4 = (double)(n4 - 2) / d3;
                            graphics2D.scale(d4, d4);
                            graphics2D.setColor(color);
                            textLayout.draw(graphics2D, (float)((d + (double)n + ((double)n3 - d2 * d4) / 2.0) / d4), (float)(((double)n2 + ((double)n4 + d3 * d4) / 2.0) / d4));
                            graphics2D.setTransform(affineTransform);
                        } else {
                            graphics2D.setColor(color);
                            textLayout.draw(graphics2D, (float)(d + (double)n + ((double)n3 - d2) / 2.0), (float)((double)n2 + ((double)n4 + d3) / 2.0));
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOG.error((Object)exception);
            }
        }
    }

    public void setData(Graphics2D graphics2D, EtGrid etGrid, Preferences preferences) {
        this.pref = preferences;
        this.et = etGrid;
    }

    public abstract void render(Graphics2D var1, int var2, int var3);

    public abstract int getDimWidth();

    public abstract int getDimHeight();

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        for (ToolTipBox toolTipBox : this.toolTips) {
            if (!toolTipBox.getBounds().contains(mouseEvent.getPoint())) continue;
            return toolTipBox.getText();
        }
        return null;
    }

    protected int getNPerPage() {
        int n = Axis.X == this.getAxis() ? (null == this.getGrid() ? 0 : this.getGrid().getNbColumns()) : (null == this.getGrid() ? 0 : this.getGrid().getVSize());
        return n;
    }
}

