/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.collections.MyHashTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class AxisCategory
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Map categoriesByNames = new HashMap();
    public static final MyHashTable categoriesByIndexes = new MyHashTable();
    public static final AxisCategory HOUR = new AxisCategory("HOUR");
    public static final AxisCategory DAY = new AxisCategory("DAY");
    public static final AxisCategory WEEK = new AxisCategory("WEEK");
    public static final AxisCategory ENTITY = new AxisCategory("ENTITY");
    public static final AxisCategory NONE = new AxisCategory("NONE");
    public static final String SEPARATOR = "#";
    public static final int MAX_INDEX = 4;
    private final String name;

    private AxisCategory(String string) {
        this.name = string;
        categoriesByNames.put(string, this);
        categoriesByIndexes.put(this.getIndex(), (Object)this);
    }

    public int getIndex() {
        if ("HOUR".equalsIgnoreCase(this.name)) {
            return 0;
        }
        if ("DAY".equalsIgnoreCase(this.name)) {
            return 1;
        }
        if ("WEEK".equalsIgnoreCase(this.name)) {
            return 2;
        }
        if ("ENTITY".equalsIgnoreCase(this.name)) {
            return 3;
        }
        return -1;
    }

    public static AxisCategory decode(String string) {
        if (null == string) {
            return NONE;
        }
        if (string.equalsIgnoreCase(HOUR.toString())) {
            return HOUR;
        }
        if (string.equalsIgnoreCase(DAY.toString())) {
            return DAY;
        }
        if (string.equalsIgnoreCase(WEEK.toString())) {
            return WEEK;
        }
        if (string.equalsIgnoreCase(ENTITY.toString())) {
            return ENTITY;
        }
        if (string.equalsIgnoreCase(NONE.toString())) {
            return NONE;
        }
        return NONE;
    }

    public static List decodeStrings(String string) {
        if (null == string) {
            return null;
        }
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            arrayList.add(AxisCategory.decode(string2));
        }
        return arrayList;
    }

    public static String encodeStrings(AxisCategory[] axisCategoryArray) {
        if (null == axisCategoryArray || 0 == axisCategoryArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (axisCategoryArray.length > 0) {
            for (int i = 0; i < axisCategoryArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(SEPARATOR);
                }
                stringBuffer.append(axisCategoryArray[i].toString());
            }
        } else {
            stringBuffer.append("NONE");
        }
        return stringBuffer.toString();
    }

    public static String encodeStrings(List list) {
        if (null == list || 0 == list.size()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(SEPARATOR);
                }
                stringBuffer.append(list.get(i).toString());
            }
        } else {
            stringBuffer.append("NONE");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.name;
    }

    public Object readResolve() {
        return categoriesByNames.get(this.name);
    }

    public static AxisCategory getCategoryByIndex(int n) {
        AxisCategory axisCategory = (AxisCategory)categoriesByIndexes.get(n);
        return axisCategory;
    }
}

