/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.IntArray;
import com.adesoft.collections.MyHashTable;
import com.adesoft.config.ConfigManager;
import com.adesoft.modules.Modules;
import com.adesoft.timetable.TempEvent;
import java.io.Serializable;

public final class CostsEt
implements Serializable {
    private static final long serialVersionUID = 520L;
    private final int nbCols;
    private final int nbRows;
    private final int nbCosts;
    private final int[] costsIds;
    private final String[] costsNames;
    private final double[][] costsCols;
    private final double[][] costsRows;
    private final double[] costsMovingCols;
    private final double[] costsMovingRows;
    private final MyHashTable eventOidsCols;
    private final MyHashTable eventOidsRows;
    private final double[] costsCumuls;
    private final IntArray eventOidsCosts;

    public CostsEt(int[] nArray, String[] stringArray, int n, int n2) {
        this.costsIds = nArray;
        this.costsNames = stringArray;
        this.nbCols = n2;
        this.nbRows = n;
        this.nbCosts = null != this.costsIds ? this.costsIds.length : 0;
        this.eventOidsCols = new MyHashTable();
        this.eventOidsRows = new MyHashTable();
        this.costsCumuls = new double[this.nbCosts + 1];
        this.eventOidsCosts = new IntArray();
        this.costsCols = new double[this.getNbCols()][this.getNbCosts()];
        this.costsRows = new double[this.getNbRows()][this.getNbCosts()];
        this.costsMovingCols = new double[this.getNbCols()];
        this.costsMovingRows = new double[this.getNbRows()];
    }

    public double[][] getCostsCols() {
        return this.costsCols;
    }

    public double[][] getCostsRows() {
        return this.costsRows;
    }

    public double[] getCostsMovingCols() {
        return this.costsMovingCols;
    }

    public double[] getCostsMovingRows() {
        return this.costsMovingRows;
    }

    public final int getNbCols() {
        return this.nbCols;
    }

    public final int getNbRows() {
        return this.nbRows;
    }

    public final int getNbCosts() {
        return this.nbCosts;
    }

    public final int[] getCostsIds() {
        return this.costsIds;
    }

    public String[] getCostsNames() {
        return this.costsNames;
    }

    public void add(int n, int n2, TempEvent tempEvent) {
        if (null != tempEvent) {
            this.add(n, n2, tempEvent.getCosts(), tempEvent.getMovingCost(), tempEvent.getOid());
        }
    }

    private void add(int n, int n2, double[] dArray, double d, int n3) {
        int n4;
        if (!this.isRegisteredColEventOid(n, n3)) {
            if (null != dArray) {
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    this.addCol(n, n4, dArray[n4]);
                }
            }
            this.addMovingCol(n, d);
            this.registerColEventOid(n, n3);
        }
        if (!this.isRegisteredRowEventOid(n2, n3)) {
            if (null != dArray) {
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    this.addRow(n2, n4, dArray[n4]);
                }
            }
            this.addMovingRow(n2, d);
            this.registerRowEventOid(n2, n3);
        }
        if (!this.isRegisteredCostsEventOid(n3)) {
            if (null != dArray) {
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    this.addCost(n4 + 1, dArray[n4]);
                }
            }
            this.addCost(0, d);
            this.registerCostsEventOid(n3);
        }
    }

    private void addCol(int n, int n2, double d) {
        double[] dArray = this.costsCols[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    private void addRow(int n, int n2, double d) {
        double[] dArray = this.costsRows[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    private void addMovingCol(int n, double d) {
        int n2 = n;
        this.costsMovingCols[n2] = this.costsMovingCols[n2] + d;
    }

    private void addMovingRow(int n, double d) {
        int n2 = n;
        this.costsMovingRows[n2] = this.costsMovingRows[n2] + d;
    }

    public double[] getCostsCol(int n) {
        return this.costsCols[n];
    }

    public double getCostCol(int n, int n2) {
        return this.costsCols[n][n2];
    }

    public double[] getCostsRow(int n) {
        return this.costsRows[n];
    }

    public double getCostRow(int n, int n2) {
        return this.costsRows[n][n2];
    }

    public double getCostCol(int n, boolean bl) {
        double d = -1.0;
        double[] dArray = this.costsCols[n];
        if (null != dArray) {
            d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i];
            }
        }
        if (ConfigManager.getInstance().hasModule(Modules.SITES) && bl) {
            d += this.getCostsMovingCols()[n];
        }
        return d;
    }

    public double getCostRow(int n, boolean bl) {
        double d = -1.0;
        double[] dArray = this.costsRows[n];
        if (null != dArray) {
            d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i];
            }
        }
        if (ConfigManager.getInstance().hasModule(Modules.SITES) && bl) {
            d += this.getCostsMovingRows()[n];
        }
        return d;
    }

    public double getCost(int n) {
        return this.costsCumuls[n];
    }

    public double getCost() {
        double d = -1.0;
        if (null != this.costsCumuls) {
            d = 0.0;
            for (int i = 0; i < this.costsCumuls.length; ++i) {
                d += this.costsCumuls[i];
            }
        }
        return d;
    }

    private void addCost(int n, double d) {
        int n2 = n;
        this.costsCumuls[n2] = this.costsCumuls[n2] + d;
    }

    private void registerColEventOid(int n, int n2) {
        IntArray intArray = (IntArray)this.eventOidsCols.get(n);
        if (null == intArray) {
            intArray = new IntArray();
            this.eventOidsCols.put(n, (Object)intArray);
        }
        intArray.add(n2);
    }

    private void registerRowEventOid(int n, int n2) {
        IntArray intArray = (IntArray)this.eventOidsRows.get(n);
        if (null == intArray) {
            intArray = new IntArray();
            this.eventOidsRows.put(n, (Object)intArray);
        }
        intArray.add(n2);
    }

    private void registerCostsEventOid(int n) {
        this.eventOidsCosts.add(n);
    }

    private boolean isRegisteredColEventOid(int n, int n2) {
        IntArray intArray = (IntArray)this.eventOidsCols.get(n);
        if (null != intArray) {
            return intArray.contains(n2);
        }
        return false;
    }

    private boolean isRegisteredRowEventOid(int n, int n2) {
        IntArray intArray = (IntArray)this.eventOidsRows.get(n);
        if (null != intArray) {
            return intArray.contains(n2);
        }
        return false;
    }

    private boolean isRegisteredCostsEventOid(int n) {
        return this.eventOidsCosts.contains(n);
    }
}

