/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.timetable.Column;
import com.adesoft.timetable.CostsEt;
import com.adesoft.timetable.EtData;
import com.adesoft.timetable.Header;
import com.adesoft.timetable.HistoData;
import com.adesoft.timetable.TempEvent;
import java.io.Serializable;

public final class EtGrid
implements Serializable {
    private static final long serialVersionUID = 520L;
    private Header hRoot;
    private Header vRoot;
    private final int vSize;
    private final EtData[] tables;
    private CostsEt costsEt;
    private String[] costNames;
    private final int granularity;
    private final int nbSlots;
    private final HistoData histoData;

    public EtGrid(int n, int n2, int n3, String[] stringArray, HistoData histoData) {
        this.vSize = n;
        this.granularity = n2;
        this.nbSlots = n3;
        this.costNames = stringArray;
        this.histoData = histoData;
        this.tables = new EtData[this.vSize];
    }

    public HistoData getHistoData() {
        return this.histoData;
    }

    public int getNbSlots() {
        return this.nbSlots;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public Header getHRoot() {
        return this.hRoot;
    }

    public int getNbColumns() {
        EtData etData;
        if (this.getVSize() > 0 && null != (etData = this.getTimetable(0))) {
            return etData.size();
        }
        return 0;
    }

    public EtData getTimetable(int n) {
        return this.tables[n];
    }

    public Header getVRoot() {
        return this.vRoot;
    }

    public int getVSize() {
        return this.vSize;
    }

    public void setHRoot(Header header) {
        this.hRoot = header;
    }

    public void setTimetable(int n, EtData etData) {
        this.tables[n] = etData;
    }

    public void setVRoot(Header header) {
        this.vRoot = header;
    }

    public CostsEt getCostsEt() {
        return this.costsEt;
    }

    public void setCostsEt(CostsEt costsEt) {
        this.costsEt = costsEt;
    }

    public String[] getCostNames() {
        return this.costNames;
    }

    public void validate(int[] nArray, boolean bl) {
        for (int i = this.getVSize() - 1; i >= 0; --i) {
            EtData etData = this.getTimetable(i);
            if (null == etData) continue;
            int n = etData.size();
            for (int j = 0; j < n; ++j) {
                etData.getColumn(j).reorganize();
            }
            etData.update();
        }
        if (null != nArray && 0 != nArray.length || bl) {
            CostsEt costsEt = new CostsEt(nArray, this.getCostNames(), this.getVSize(), this.getNbColumns());
            for (int i = 0; i < this.getVSize(); ++i) {
                EtData etData = this.getTimetable(i);
                Column[] columnArray = etData.getColumns();
                int n = null != columnArray ? columnArray.length : 0;
                for (int j = 0; j < n; ++j) {
                    Column column = etData.getColumn(j);
                    if (column.getNbEvents() <= 0) continue;
                    TempEvent[] tempEventArray = column.getXmlEvents();
                    for (int k = 0; k < tempEventArray.length; ++k) {
                        costsEt.add(j, i, tempEventArray[k]);
                    }
                }
            }
            this.setCostsEt(costsEt);
        } else {
            this.setCostsEt(null);
        }
    }
}

