/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.timetable.CaseEt;
import com.adesoft.timetable.ColumnIterator;
import com.adesoft.timetable.EventsGroup;
import com.adesoft.timetable.EventsGroupImpl;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;

public abstract class EventGrouper
implements Comparator<EventsGroup> {
    public static final int MODE_NONE = -1;
    public static final int MODE_EVENT = 0;
    public static final int MODE_COURSE = 1;
    public static final int MODE_FOLDER = 2;
    public static final int NEXT_OK = 1;
    public static final int SIZE_OK = 2;
    public static final EventGrouper PORTRAIT = new EventGrouper(){

        @Override
        public int getPrimaryNextToStatus(Rectangle rectangle, Rectangle rectangle2) {
            return EventGrouper.getNextColStatus(rectangle, rectangle2);
        }

        @Override
        public int getSecondaryNextToStatus(Rectangle rectangle, Rectangle rectangle2) {
            return EventGrouper.getNextRowStatus(rectangle, rectangle2);
        }

        @Override
        public boolean isSecondaryNextTo(Rectangle rectangle, Rectangle rectangle2) {
            return EventGrouper.isNextRow(rectangle, rectangle2);
        }

        @Override
        public int compare(EventsGroup eventsGroup, EventsGroup eventsGroup2) {
            return this.compareYX(eventsGroup, eventsGroup2);
        }

        @Override
        public EventGrouper getPrimaryComparator() {
            return this;
        }

        @Override
        public EventGrouper getSecondaryComparator() {
            return LANDSCAPE;
        }
    };
    public static final EventGrouper LANDSCAPE = new EventGrouper(){

        @Override
        public int getPrimaryNextToStatus(Rectangle rectangle, Rectangle rectangle2) {
            return EventGrouper.getNextRowStatus(rectangle, rectangle2);
        }

        @Override
        public int getSecondaryNextToStatus(Rectangle rectangle, Rectangle rectangle2) {
            return EventGrouper.getNextColStatus(rectangle, rectangle2);
        }

        @Override
        public boolean isSecondaryNextTo(Rectangle rectangle, Rectangle rectangle2) {
            return EventGrouper.isNextCol(rectangle, rectangle2);
        }

        @Override
        public int compare(EventsGroup eventsGroup, EventsGroup eventsGroup2) {
            return this.compareXY(eventsGroup, eventsGroup2);
        }

        @Override
        public EventGrouper getPrimaryComparator() {
            return this;
        }

        @Override
        public EventGrouper getSecondaryComparator() {
            return PORTRAIT;
        }
    };

    public abstract int getPrimaryNextToStatus(Rectangle var1, Rectangle var2);

    public abstract int getSecondaryNextToStatus(Rectangle var1, Rectangle var2);

    public abstract boolean isSecondaryNextTo(Rectangle var1, Rectangle var2);

    public abstract EventGrouper getPrimaryComparator();

    public abstract EventGrouper getSecondaryComparator();

    public final int compareXY(EventsGroup eventsGroup, EventsGroup eventsGroup2) {
        int n = (int)(eventsGroup.getShape().getMinX() * 10000.0 + eventsGroup.getShape().getMinY());
        int n2 = (int)(eventsGroup2.getShape().getMinX() * 10000.0 + eventsGroup2.getShape().getMinY());
        return n - n2;
    }

    public final int compareYX(EventsGroup eventsGroup, EventsGroup eventsGroup2) {
        int n = (int)(eventsGroup.getShape().getMinY() * 10000.0 + eventsGroup.getShape().getMinX());
        int n2 = (int)(eventsGroup2.getShape().getMinY() * 10000.0 + eventsGroup2.getShape().getMinX());
        return n - n2;
    }

    protected static final boolean isNextRow(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.getMinY() == rectangle.getMaxY() || rectangle2.getMinY() == 1.0 + rectangle.getMaxY();
    }

    protected static final boolean isNextCol(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.getMinX() == rectangle.getMaxX() || rectangle2.getMinX() == 1.0 + rectangle.getMaxX();
    }

    protected static final int getNextColStatus(Rectangle rectangle, Rectangle rectangle2) {
        int n = 0;
        n += EventGrouper.isNextCol(rectangle, rectangle2) ? 1 : 0;
        return n += EventGrouper.isSameHeightAndPlace(rectangle, rectangle2) ? 2 : 0;
    }

    protected static final int getNextRowStatus(Rectangle rectangle, Rectangle rectangle2) {
        int n = 0;
        if (EventGrouper.isNextRow(rectangle, rectangle2)) {
            ++n;
        }
        if (EventGrouper.isSameWidthAndPlace(rectangle, rectangle2)) {
            n += 2;
        }
        return n;
    }

    private static final boolean isSameHeightAndPlace(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.height == rectangle2.height && rectangle.getMinY() == rectangle2.getMinY();
    }

    private static final boolean isSameWidthAndPlace(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.width == rectangle2.width && rectangle.getMinX() == rectangle2.getMinX();
    }

    public final EventsGroup groupEvents(List list, ColumnIterator columnIterator, int n, int n2) {
        EventsGroup eventsGroup = null;
        while (columnIterator.hasNext()) {
            CaseEt caseEt = (CaseEt)columnIterator.next();
            if (!(caseEt.getStart() >= n && caseEt.getStart() <= n2 || caseEt.getStart() + caseEt.getDuration() >= n && caseEt.getStart() + caseEt.getDuration() <= n2) && (caseEt.getStart() > n || caseEt.getStart() + caseEt.getDuration() < n2)) continue;
            if (null != eventsGroup && eventsGroup.getGroupOid() == caseEt.getGroupOid() && this.isSecondaryNextTo(eventsGroup.getShape(), caseEt.getShape())) {
                eventsGroup.add(caseEt);
                continue;
            }
            eventsGroup = new EventsGroupImpl(caseEt);
            list.add(eventsGroup);
        }
        return eventsGroup;
    }
}

